<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration Successful</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gradient-to-br from-blue-50 via-white to-red-50">
    <div class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-2xl w-full">
            <!-- Success Icon -->
            <div class="text-center mb-8">
                <div class="relative inline-block">
                    <div class="absolute inset-0 bg-gradient-to-r from-green-400 to-emerald-500 rounded-full blur-2xl opacity-40 animate-pulse"></div>
                    <div class="relative w-32 h-32 bg-gradient-to-r from-green-500 to-emerald-600 rounded-full flex items-center justify-center shadow-2xl mx-auto">
                        <i class="fas fa-check text-white text-6xl"></i>
                    </div>
                </div>
            </div>

            <!-- Success Card -->
            <div class="bg-white rounded-3xl shadow-2xl border-2 border-gray-100 overflow-hidden">
                <div class="bg-gradient-to-r from-green-500 to-emerald-600 text-white p-6 text-center">
                    <h1 class="text-3xl font-bold">Registration Successful!</h1>
                </div>
                
                <div class="p-8">
                    <div class="text-center mb-6">
                        <h2 class="text-2xl font-bold text-gray-900 mb-2">Thank You for Registering!</h2>
                        <p class="text-gray-600">Your membership application has been received</p>
                    </div>
                    
                    <div class="bg-gradient-to-r from-blue-50 to-indigo-50 border-2 border-blue-200 rounded-2xl p-6 mb-6">
                        <div class="flex items-start">
                            <i class="fas fa-info-circle text-blue-600 text-2xl mr-3 mt-1"></i>
                            <p class="text-blue-900">
                                Your membership registration has been submitted successfully and is currently 
                                <span class="font-bold">pending approval</span> by the church administration.
                            </p>
                        </div>
                    </div>
                    
                    <div class="bg-gray-50 rounded-2xl p-6 mb-6">
                        <h3 class="font-bold text-gray-900 mb-4 flex items-center text-lg">
                            <i class="fas fa-list-check text-blue-600 mr-2"></i>
                            What Happens Next?
                        </h3>
                        <ul class="space-y-3">
                            <li class="flex items-start">
                                <span class="flex-shrink-0 w-8 h-8 bg-gradient-to-r from-blue-600 to-red-600 text-white rounded-full flex items-center justify-center font-bold mr-3">1</span>
                                <span class="text-gray-700 pt-1">Your application will be reviewed by the membership committee</span>
                            </li>
                            <li class="flex items-start">
                                <span class="flex-shrink-0 w-8 h-8 bg-gradient-to-r from-blue-600 to-red-600 text-white rounded-full flex items-center justify-center font-bold mr-3">2</span>
                                <span class="text-gray-700 pt-1">You will be contacted within 5-7 business days</span>
                            </li>
                            <li class="flex items-start">
                                <span class="flex-shrink-0 w-8 h-8 bg-gradient-to-r from-blue-600 to-red-600 text-white rounded-full flex items-center justify-center font-bold mr-3">3</span>
                                <span class="text-gray-700 pt-1">An interview may be scheduled if required</span>
                            </li>
                            <li class="flex items-start">
                                <span class="flex-shrink-0 w-8 h-8 bg-gradient-to-r from-blue-600 to-red-600 text-white rounded-full flex items-center justify-center font-bold mr-3">4</span>
                                <span class="text-gray-700 pt-1">You will receive your membership confirmation via email/SMS</span>
                            </li>
                        </ul>
                    </div>
                    
                    <div class="text-center">
                        <a href="<?php echo e(url('/')); ?>" 
                           class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 text-white font-bold text-lg rounded-2xl hover:from-blue-700 hover:via-purple-700 hover:to-red-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                            <i class="fas fa-home mr-2"></i>
                            Return to Home
                        </a>
                    </div>

                    <div class="mt-6 text-center">
                        <p class="text-sm text-gray-600">
                            <i class="fas fa-envelope mr-1"></i>
                            Questions? Contact the church office for assistance
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/member-registration/success.blade.php ENDPATH**/ ?>