<?php $__env->startSection('title', 'Edit Member'); ?>
<?php $__env->startSection('subtitle', 'Update member information'); ?>

<?php $__env->startSection('content'); ?>

<!-- Success/Error Messages -->
<?php if(session('success')): ?>
    <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-check-circle text-green-400"></i>
            </div>
            <div class="ml-3">
                <p class="text-sm font-medium text-green-800"><?php echo e(session('success')); ?></p>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-exclamation-circle text-red-400"></i>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-red-800">Please correct the following errors:</h3>
                <div class="mt-2 text-sm text-red-700">
                    <ul class="list-disc pl-5 space-y-1">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<div class="max-w-4xl mx-auto space-y-6">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Edit Member: <?php echo e($member->full_name ?? 'Member Name'); ?></h1>
            <p class="text-gray-600 mt-1">Update member information and details</p>
        </div>
        <div class="flex gap-3">
            <a href="<?php echo e(route('members.show', $member->id ?? 1)); ?>" class="inline-flex items-center px-4 py-2 bg-blue-100 text-blue-700 font-medium rounded-xl hover:bg-blue-200 transition-colors duration-200">
                <i class="fas fa-eye mr-2"></i>
                View Profile
            </a>
            <a href="<?php echo e(route('members.index')); ?>" class="inline-flex items-center px-4 py-2 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors duration-200">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Members
            </a>
        </div>
    </div>

    <form action="<?php echo e(route('members.update', $member->id ?? 1)); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <!-- Personal Information -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center mb-6">
                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-xl flex items-center justify-center mr-3">
                    <i class="fas fa-user text-white"></i>
                </div>
                <h2 class="text-lg font-semibold text-gray-900">Personal Information</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Photo Upload -->
                <div class="md:col-span-1">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Profile Photo</label>
                    <div class="flex flex-col items-center">
                        <div class="w-32 h-32 bg-gradient-to-br from-blue-100 to-cyan-100 rounded-full flex items-center justify-center mb-4 overflow-hidden">
                            <?php if($member->photo_path ?? false): ?>
                                <img id="photo-preview" src="<?php echo e(asset('storage/' . $member->photo_path)); ?>" alt="<?php echo e($member->full_name); ?>" class="w-full h-full object-cover">
                            <?php else: ?>
                                <img id="photo-preview" src="" alt="Preview" class="w-full h-full object-cover hidden">
                                <i id="photo-icon" class="fas fa-camera text-3xl text-blue-500"></i>
                            <?php endif; ?>
                        </div>
                        <input type="file" name="photo" id="photo" accept="image/*" class="hidden">
                        <button type="button" onclick="document.getElementById('photo').click()" class="px-4 py-2 bg-blue-50 text-blue-600 rounded-lg hover:bg-blue-100 transition-colors text-sm">
                            <i class="fas fa-upload mr-2"></i>Change Photo
                        </button>
                    </div>
                </div>

                <!-- Name Fields -->
                <div class="md:col-span-2 grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="title" class="block text-sm font-medium text-gray-700 mb-2">Title</label>
                        <select name="title" id="title" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Title</option>
                            <option value="Mr." <?php echo e(($member->title ?? old('title')) == 'Mr.' ? 'selected' : ''); ?>>Mr.</option>
                            <option value="Mrs." <?php echo e(($member->title ?? old('title')) == 'Mrs.' ? 'selected' : ''); ?>>Mrs.</option>
                            <option value="Ms." <?php echo e(($member->title ?? old('title')) == 'Ms.' ? 'selected' : ''); ?>>Ms.</option>
                            <option value="Dr." <?php echo e(($member->title ?? old('title')) == 'Dr.' ? 'selected' : ''); ?>>Dr.</option>
                            <option value="Rev." <?php echo e(($member->title ?? old('title')) == 'Rev.' ? 'selected' : ''); ?>>Rev.</option>
                            <option value="Pastor" <?php echo e(($member->title ?? old('title')) == 'Pastor' ? 'selected' : ''); ?>>Pastor</option>
                        </select>
                    </div>

                    <div>
                        <label for="first_name" class="block text-sm font-medium text-gray-700 mb-2">First Name <span class="text-red-500">*</span></label>
                        <input type="text" name="first_name" id="first_name" required class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->first_name ?? old('first_name')); ?>">
                        <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label for="middle_name" class="block text-sm font-medium text-gray-700 mb-2">Middle Name</label>
                        <input type="text" name="middle_name" id="middle_name" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->middle_name ?? old('middle_name')); ?>">
                    </div>

                    <div>
                        <label for="last_name" class="block text-sm font-medium text-gray-700 mb-2">Last Name <span class="text-red-500">*</span></label>
                        <input type="text" name="last_name" id="last_name" required class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->last_name ?? old('last_name')); ?>">
                        <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label for="date_of_birth" class="block text-sm font-medium text-gray-700 mb-2">Date of Birth</label>
                        <input type="date" name="date_of_birth" id="date_of_birth" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->date_of_birth ? $member->date_of_birth->format('Y-m-d') : old('date_of_birth')); ?>">
                    </div>

                    <div>
                        <label for="gender" class="block text-sm font-medium text-gray-700 mb-2">Gender</label>
                        <select name="gender" id="gender" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Gender</option>
                            <option value="male" <?php echo e(($member->gender ?? old('gender')) == 'male' ? 'selected' : ''); ?>>Male</option>
                            <option value="female" <?php echo e(($member->gender ?? old('gender')) == 'female' ? 'selected' : ''); ?>>Female</option>
                        </select>
                    </div>

                    <div>
                        <label for="marital_status" class="block text-sm font-medium text-gray-700 mb-2">Marital Status</label>
                        <select name="marital_status" id="marital_status" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Status</option>
                            <option value="single" <?php echo e(($member->marital_status ?? old('marital_status')) == 'single' ? 'selected' : ''); ?>>Single</option>
                            <option value="married" <?php echo e(($member->marital_status ?? old('marital_status')) == 'married' ? 'selected' : ''); ?>>Married</option>
                            <option value="divorced" <?php echo e(($member->marital_status ?? old('marital_status')) == 'divorced' ? 'selected' : ''); ?>>Divorced</option>
                            <option value="widowed" <?php echo e(($member->marital_status ?? old('marital_status')) == 'widowed' ? 'selected' : ''); ?>>Widowed</option>
                        </select>
                    </div>

                    <div>
                        <label for="occupation" class="block text-sm font-medium text-gray-700 mb-2">Occupation</label>
                        <input type="text" name="occupation" id="occupation" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->occupation ?? old('occupation')); ?>">
                    </div>

                    <div>
                        <label for="highest_qualification" class="block text-sm font-medium text-gray-700 mb-2">Highest Qualification</label>
                        <select name="highest_qualification" id="highest_qualification" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Qualification</option>
                            <option value="none" <?php echo e(($member->highest_qualification ?? old('highest_qualification')) == 'none' ? 'selected' : ''); ?>>No Formal Education</option>
                            <option value="primary" <?php echo e(($member->highest_qualification ?? old('highest_qualification')) == 'primary' ? 'selected' : ''); ?>>Primary School</option>
                            <option value="jhs" <?php echo e(($member->highest_qualification ?? old('highest_qualification')) == 'jhs' ? 'selected' : ''); ?>>Junior High School</option>
                            <option value="shs" <?php echo e(($member->highest_qualification ?? old('highest_qualification')) == 'shs' ? 'selected' : ''); ?>>Senior High School</option>
                            <option value="tertiary" <?php echo e(($member->highest_qualification ?? old('highest_qualification')) == 'tertiary' ? 'selected' : ''); ?>>Tertiary/University</option>
                            <option value="postgraduate" <?php echo e(($member->highest_qualification ?? old('highest_qualification')) == 'postgraduate' ? 'selected' : ''); ?>>Postgraduate</option>
                            <option value="professional" <?php echo e(($member->highest_qualification ?? old('highest_qualification')) == 'professional' ? 'selected' : ''); ?>>Professional Certification</option>
                            <option value="other" <?php echo e(($member->highest_qualification ?? old('highest_qualification')) == 'other' ? 'selected' : ''); ?>>Other</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact Information -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center mb-6">
                <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-emerald-600 rounded-xl flex items-center justify-center mr-3">
                    <i class="fas fa-phone text-white"></i>
                </div>
                <h2 class="text-lg font-semibold text-gray-900">Contact Information</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                    <input type="email" name="email" id="email" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->email ?? old('email')); ?>">
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">Primary Phone</label>
                    <input type="tel" name="phone" id="phone" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->phone ?? old('phone')); ?>">
                </div>

                <div>
                    <label for="alternate_phone" class="block text-sm font-medium text-gray-700 mb-2">Alternate Phone</label>
                    <input type="tel" name="alternate_phone" id="alternate_phone" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->alternate_phone ?? old('alternate_phone')); ?>">
                </div>

                <div>
                    <label for="employer" class="block text-sm font-medium text-gray-700 mb-2">Employer</label>
                    <input type="text" name="employer" id="employer" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->employer ?? old('employer')); ?>">
                </div>

                <div class="md:col-span-2">
                    <label for="address" class="block text-sm font-medium text-gray-700 mb-2">GPS Address/Location</label>
                    <textarea name="address" id="address" rows="3" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"><?php echo e($member->address ?? old('address')); ?></textarea>
                </div>

                <div>
                    <label for="city" class="block text-sm font-medium text-gray-700 mb-2">City</label>
                    <input type="text" name="city" id="city" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->city ?? old('city')); ?>">
                </div>

                <div>
                    <label for="state" class="block text-sm font-medium text-gray-700 mb-2">Region/State/Province</label>
                    <input type="text" name="state" id="state" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->state ?? old('state')); ?>">
                </div>

                <div>
                    <label for="postal_code" class="block text-sm font-medium text-gray-700 mb-2">Postal Code</label>
                    <input type="text" name="postal_code" id="postal_code" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->postal_code ?? old('postal_code')); ?>">
                </div>

                <div>
                    <label for="country" class="block text-sm font-medium text-gray-700 mb-2">Country</label>
                    <input type="text" name="country" id="country" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->country ?? old('country')); ?>">
                </div>
            </div>
        </div>

        <!-- Membership Information -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center mb-6">
                <div class="w-10 h-10 bg-gradient-to-br from-orange-500 to-red-600 rounded-xl flex items-center justify-center mr-3">
                    <i class="fas fa-id-card text-white"></i>
                </div>
                <h2 class="text-lg font-semibold text-gray-900">Membership Information</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <div>
                    <label for="member_id" class="block text-sm font-medium text-gray-700 mb-2">Member ID</label>
                    <input type="text" name="member_id" id="member_id" class="block w-full px-3 py-2 bg-gray-50 border border-gray-300 rounded-lg" value="<?php echo e($member->member_id ?? 'Auto-generated'); ?>" readonly>
                </div>

                <div>
                    <label for="membership_date" class="block text-sm font-medium text-gray-700 mb-2">Membership Date</label>
                    <input type="date" name="membership_date" id="membership_date" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e($member->membership_date ? $member->membership_date->format('Y-m-d') : old('membership_date')); ?>">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Year Group</label>
                    <?php if($member->yearGroup): ?>
                        <div class="p-3 rounded-lg border-2" style="background-color: <?php echo e($member->yearGroup->color); ?>20; border-color: <?php echo e($member->yearGroup->color); ?>40;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-3 h-3 rounded-full mr-2" style="background-color: <?php echo e($member->yearGroup->color); ?>;"></div>
                                    <span class="font-medium text-gray-900"><?php echo e($member->yearGroup->name); ?></span>
                                    <?php if($member->yearGroup->abbreviation): ?>
                                        <span class="ml-2 px-2 py-1 text-xs font-bold rounded" style="background-color: <?php echo e($member->yearGroup->color); ?>; color: white;"><?php echo e($member->yearGroup->abbreviation); ?></span>
                                    <?php endif; ?>
                                </div>
                                <?php if($member->age): ?>
                                    <span class="text-sm text-gray-600">Age: <?php echo e($member->age); ?></span>
                                <?php endif; ?>
                            </div>
                            <p class="text-xs text-gray-600 mt-1"><?php echo e($member->yearGroup->description); ?></p>
                        </div>
                    <?php else: ?>
                        <div class="p-3 bg-gray-50 border border-gray-200 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-exclamation-triangle text-yellow-500 mr-2"></i>
                                <span class="text-sm text-gray-700">
                                    <strong>Not Assigned</strong><br>
                                    Year group will be assigned when date of birth is provided.
                                </span>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <div>
                    <label for="membership_status" class="block text-sm font-medium text-gray-700 mb-2">Membership Status</label>
                    <select name="membership_status" id="membership_status" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="active" <?php echo e(($member->membership_status ?? old('membership_status')) == 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="inactive" <?php echo e(($member->membership_status ?? old('membership_status')) == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                        <option value="transferred" <?php echo e(($member->membership_status ?? old('membership_status')) == 'transferred' ? 'selected' : ''); ?>>Transferred</option>
                        <option value="deceased" <?php echo e(($member->membership_status ?? old('membership_status')) == 'deceased' ? 'selected' : ''); ?>>Deceased</option>
                    </select>
                </div>

                <div>
                    <label for="membership_type" class="block text-sm font-medium text-gray-700 mb-2">Membership Type (PCG)</label>
                    <select name="membership_type" id="membership_type" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                        <option value="communicant" <?php echo e((old('membership_type', $member->membership_type ?? 'communicant')) == 'communicant' ? 'selected' : ''); ?>>Communicant Member (Full Member)</option>
                        <option value="baptized" <?php echo e((old('membership_type', $member->membership_type)) == 'baptized' ? 'selected' : ''); ?>>Baptized Member</option>
                        <option value="confirmed" <?php echo e((old('membership_type', $member->membership_type)) == 'confirmed' ? 'selected' : ''); ?>>Confirmed Member</option>
                        <option value="long_distance" <?php echo e((old('membership_type', $member->membership_type)) == 'long_distance' ? 'selected' : ''); ?>>Long Distance Member</option>
                        <option value="adherent" <?php echo e((old('membership_type', $member->membership_type)) == 'adherent' ? 'selected' : ''); ?>>Adherent</option>
                        <option value="catechumen" <?php echo e((old('membership_type', $member->membership_type)) == 'catechumen' ? 'selected' : ''); ?>>Catechumen (Learner / New Member)</option>
                    </select>
                    <?php $__errorArgs = ['membership_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label for="family_id" class="block text-sm font-medium text-gray-700 mb-2">Family</label>
                    <select name="family_id" id="family_id" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">No Family</option>
                        <?php $__currentLoopData = $families ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $family): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($family->id); ?>" <?php echo e(($member->family_id ?? old('family_id')) == $family->id ? 'selected' : ''); ?>>
                                <?php echo e($family->family_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div>
                    <label for="relationship_to_head" class="block text-sm font-medium text-gray-700 mb-2">Relationship to Family Head</label>
                    <select name="relationship_to_head" id="relationship_to_head" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Select Relationship</option>
                        <option value="head" <?php echo e(($member->relationship_to_head ?? old('relationship_to_head')) == 'head' ? 'selected' : ''); ?>>Head of Family</option>
                        <option value="spouse" <?php echo e(($member->relationship_to_head ?? old('relationship_to_head')) == 'spouse' ? 'selected' : ''); ?>>Spouse</option>
                        <option value="child" <?php echo e(($member->relationship_to_head ?? old('relationship_to_head')) == 'child' ? 'selected' : ''); ?>>Child</option>
                        <option value="parent" <?php echo e(($member->relationship_to_head ?? old('relationship_to_head')) == 'parent' ? 'selected' : ''); ?>>Parent</option>
                        <option value="sibling" <?php echo e(($member->relationship_to_head ?? old('relationship_to_head')) == 'sibling' ? 'selected' : ''); ?>>Sibling</option>
                        <option value="relative" <?php echo e(($member->relationship_to_head ?? old('relationship_to_head')) == 'relative' ? 'selected' : ''); ?>>Other Relative</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="flex justify-between pt-6">
            <button type="button" onclick="confirmDelete()" class="px-6 py-3 bg-red-100 text-red-700 font-medium rounded-xl hover:bg-red-200 transition-colors duration-200">
                <i class="fas fa-trash mr-2"></i>
                Delete Member
            </button>
            <div class="flex space-x-4">
                <a href="<?php echo e(route('members.show', $member->id ?? 1)); ?>" class="px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors duration-200">
                    Cancel
                </a>
                <button type="submit" id="submit-btn" class="px-6 py-3 bg-gradient-to-r from-blue-600 to-blue-700 text-white font-medium rounded-xl hover:from-blue-700 hover:to-blue-800 transition-all duration-200 shadow-lg hover:shadow-xl disabled:opacity-50 disabled:cursor-not-allowed">
                    <i class="fas fa-save mr-2" id="submit-icon"></i>
                    <span id="submit-text">Update Member</span>
                </button>
            </div>
        </div>
    </form>

    <!-- Password Management Section -->
    <div class="bg-white rounded-xl shadow-lg border border-gray-100 p-8">
        <div class="flex items-center mb-6">
            <div class="w-12 h-12 bg-gradient-to-r from-blue-600 to-red-600 rounded-2xl flex items-center justify-center shadow-lg mr-4">
                <i class="fas fa-key text-white text-lg"></i>
            </div>
            <div>
                <h2 class="text-xl font-bold text-gray-900">Password Management</h2>
                <p class="text-gray-600 text-sm">Manage member login credentials and access</p>
            </div>
        </div>

        <!-- Success Messages for Password Actions -->
        <?php if(session('generated_password')): ?>
            <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-check-circle text-green-400"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-green-800"><?php echo e(session('success')); ?></p>
                        <div class="mt-2 bg-green-100 rounded-lg p-3">
                            <p class="text-sm text-green-800"><strong>New Password:</strong> <code class="bg-white px-2 py-1 rounded text-green-900"><?php echo e(session('generated_password')); ?></code></p>
                            <p class="text-xs text-green-600 mt-1">Please share this password securely with the member.</p>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if(session('temp_password')): ?>
            <div class="mb-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-info-circle text-blue-400"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-blue-800"><?php echo e(session('success')); ?></p>
                        <div class="mt-2 bg-blue-100 rounded-lg p-3">
                            <p class="text-sm text-blue-800"><strong>Temporary Password:</strong> <code class="bg-white px-2 py-1 rounded text-blue-900"><?php echo e(session('temp_password')); ?></code></p>
                            <p class="text-xs text-blue-600 mt-1">Member should change this password after first login.</p>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Current Status -->
            <div class="bg-gray-50 rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Login Status</h3>
                <div class="space-y-3">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Login Access:</span>
                        <?php if($member->password): ?>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                                <i class="fas fa-check-circle mr-1"></i>
                                Enabled
                            </span>
                        <?php else: ?>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                                <i class="fas fa-times-circle mr-1"></i>
                                Disabled
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Member ID:</span>
                        <code class="bg-white px-2 py-1 rounded text-gray-900"><?php echo e($member->member_id); ?></code>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Email:</span>
                        <span class="text-gray-900"><?php echo e($member->email ?: 'Not set'); ?></span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="space-y-4">
                <h3 class="text-lg font-semibold text-gray-900">Quick Actions</h3>
                
                <?php if($member->password): ?>
                    <!-- Generate New Password -->
                    <form action="<?php echo e(route('members.generate-password', $member)); ?>" method="POST" class="inline-block w-full">
                        <?php echo csrf_field(); ?>
                        <button type="submit" onclick="return confirm('Generate a new random password for this member? The old password will no longer work.')" 
                                class="w-full bg-gradient-to-r from-blue-600 to-indigo-600 text-white px-4 py-3 rounded-lg font-medium hover:from-blue-700 hover:to-indigo-700 transition-all duration-200 flex items-center justify-center">
                            <i class="fas fa-random mr-2"></i>
                            Generate New Password
                        </button>
                    </form>

                    <!-- Disable Login -->
                    <form action="<?php echo e(route('members.disable-login', $member)); ?>" method="POST" class="inline-block w-full">
                        <?php echo csrf_field(); ?>
                        <button type="submit" onclick="return confirm('Disable login access for this member? They will not be able to log in until access is re-enabled.')" 
                                class="w-full bg-gradient-to-r from-red-600 to-pink-600 text-white px-4 py-3 rounded-lg font-medium hover:from-red-700 hover:to-pink-700 transition-all duration-200 flex items-center justify-center">
                            <i class="fas fa-ban mr-2"></i>
                            Disable Login Access
                        </button>
                    </form>
                <?php else: ?>
                    <!-- Enable Login -->
                    <form action="<?php echo e(route('members.enable-login', $member)); ?>" method="POST" class="inline-block w-full">
                        <?php echo csrf_field(); ?>
                        <button type="submit" onclick="return confirm('Enable login access for this member with a temporary password?')" 
                                class="w-full bg-gradient-to-r from-green-600 to-emerald-600 text-white px-4 py-3 rounded-lg font-medium hover:from-green-700 hover:to-emerald-700 transition-all duration-200 flex items-center justify-center">
                            <i class="fas fa-unlock mr-2"></i>
                            Enable Login Access
                        </button>
                    </form>
                <?php endif; ?>
            </div>
        </div>

        <!-- Custom Password Reset -->
        <?php if($member->password): ?>
            <div class="mt-8 pt-6 border-t border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Set Custom Password</h3>
                <form action="<?php echo e(route('members.reset-password', $member)); ?>" method="POST" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="new_password" class="block text-sm font-medium text-gray-700 mb-2">New Password</label>
                            <input type="password" name="new_password" id="new_password" required minlength="8"
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                            <p class="text-xs text-gray-500 mt-1">Minimum 8 characters</p>
                        </div>
                        <div>
                            <label for="new_password_confirmation" class="block text-sm font-medium text-gray-700 mb-2">Confirm Password</label>
                            <input type="password" name="new_password_confirmation" id="new_password_confirmation" required minlength="8"
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                        </div>
                    </div>
                    <button type="submit" class="bg-gradient-to-r from-purple-600 to-blue-600 text-white px-6 py-3 rounded-lg font-medium hover:from-purple-700 hover:to-blue-700 transition-all duration-200 flex items-center">
                        <i class="fas fa-key mr-2"></i>
                        Set Custom Password
                    </button>
                </form>
            </div>
        <?php endif; ?>
    </div>

    <!-- Delete Form (Hidden) -->
    <form id="delete-form" action="<?php echo e(route('members.destroy', $member->id ?? 1)); ?>" method="POST" class="hidden">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>
</div>

<script>
function confirmDelete() {
    if (confirm('Are you sure you want to delete this member? This action cannot be undone.')) {
        document.getElementById('delete-form').submit();
    }
}

document.addEventListener('DOMContentLoaded', function() {
    // Form submission enhancement
    const form = document.querySelector('form[method="POST"]');
    const submitBtn = document.getElementById('submit-btn');
    const submitIcon = document.getElementById('submit-icon');
    const submitText = document.getElementById('submit-text');

    if (form && submitBtn) {
        form.addEventListener('submit', function(e) {
            // Show loading state
            submitBtn.disabled = true;
            submitIcon.className = 'fas fa-spinner fa-spin mr-2';
            submitText.textContent = 'Updating...';
            
            // Scroll to top to show any error messages
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });
    }

    // Form validation feedback
    const requiredFields = document.querySelectorAll('[required]');
    requiredFields.forEach(field => {
        field.addEventListener('blur', function() {
            if (!this.value.trim()) {
                this.classList.add('border-red-500');
                this.classList.remove('border-gray-300');
            } else {
                this.classList.remove('border-red-500');
                this.classList.add('border-green-500');
            }
        });
    });

    // Photo preview functionality
    const photoInput = document.getElementById('photo');
    const photoPreview = document.getElementById('photo-preview');
    
    if (photoInput && photoPreview) {
        photoInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    photoPreview.src = e.target.result;
                    photoPreview.style.display = 'block';
                };
                reader.readAsDataURL(file);
            }
        });
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/members/edit.blade.php ENDPATH**/ ?>