<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Absentees Report - <?php echo e($event->title); ?></title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #2563eb; padding-bottom: 15px; }
        .event-info { margin: 20px 0; background: #f8f9fa; padding: 15px; border-radius: 5px; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 10px; text-align: left; border: 1px solid #ddd; }
        th { background: #2563eb; color: white; }
        tr:nth-child(even) { background: #f8f9fa; }
        .stats { display: flex; justify-content: space-around; margin: 20px 0; }
        .stat-box { text-align: center; padding: 15px; background: #e9ecef; border-radius: 5px; }
        @media print {
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <button onclick="window.print()" class="no-print" style="padding: 10px 20px; margin-bottom: 20px; background: #2563eb; color: white; border: none; border-radius: 5px; cursor: pointer;">Print Report</button>
    
    <div class="header">
        <h1>Absentees Report</h1>
        <h2><?php echo e($event->title); ?></h2>
    </div>
    
    <div class="event-info">
        <p><strong>Date:</strong> <?php echo e($event->start_datetime->format('F d, Y')); ?></p>
        <p><strong>Time:</strong> <?php echo e($event->start_datetime->format('h:i A')); ?></p>
        <p><strong>Location:</strong> <?php echo e($event->location ?? 'Church Premises'); ?></p>
    </div>
    
    <div class="stats">
        <div class="stat-box">
            <h3><?php echo e(\App\Models\Member::active()->count()); ?></h3>
            <p>Total Members</p>
        </div>
        <div class="stat-box">
            <h3><?php echo e(\App\Models\Attendance::where('event_id', $event->id)->verified()->count()); ?></h3>
            <p>Present</p>
        </div>
        <div class="stat-box" style="background: #fee2e2;">
            <h3><?php echo e($absentees->count()); ?></h3>
            <p>Absent</p>
        </div>
    </div>
    
    <h3>Absentees List (<?php echo e($absentees->count()); ?> members)</h3>
    
    <?php if($absentees->count() > 0): ?>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Member ID</th>
                <th>Name</th>
                <th>Phone</th>
                <th>Email</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $absentees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $absentee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($index + 1); ?></td>
                <td><?php echo e($absentee->member_id); ?></td>
                <td><?php echo e($absentee->full_name); ?></td>
                <td><?php echo e($absentee->phone ?? 'N/A'); ?></td>
                <td><?php echo e($absentee->email ?? 'N/A'); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php else: ?>
    <p style="text-align: center; color: #16a34a; font-size: 20px; padding: 40px;">🎉 Perfect Attendance! All members were present.</p>
    <?php endif; ?>
    
    <div style="margin-top: 40px; padding-top: 20px; border-top: 1px solid #ddd; text-align: center; color: #666;">
        <p>Generated on <?php echo e(now()->format('F d, Y h:i A')); ?></p>
    </div>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/attendance/print-absentees.blade.php ENDPATH**/ ?>