<?php $__env->startSection('title', 'Member Profile'); ?>
<?php $__env->startSection('subtitle', 'View member details and information'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto space-y-6">
    <!-- Header -->
    <div class="flex flex-col gap-4">
        <div class="flex items-start space-x-3 sm:space-x-4">
            <div class="w-14 h-14 sm:w-16 sm:h-16 flex-shrink-0 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-full flex items-center justify-center overflow-hidden">
                <?php if($member->photo_path ?? false): ?>
                    <img src="<?php echo e(asset('storage/' . $member->photo_path)); ?>" alt="<?php echo e($member->full_name); ?>" class="w-full h-full object-cover">
                <?php else: ?>
                    <i class="fas fa-user text-white text-xl sm:text-2xl"></i>
                <?php endif; ?>
            </div>
            <div class="flex-1 min-w-0">
                <h1 class="text-xl sm:text-2xl font-bold text-gray-900 break-words"><?php echo e($member->full_name ?? 'John Doe'); ?></h1>
                <p class="text-sm sm:text-base text-gray-600">Member ID: <?php echo e($member->member_id ?? 'M2025001'); ?></p>
                <div class="flex items-center gap-2 mt-1 flex-wrap">
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e(($member->membership_status ?? 'active') === 'active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>">
                        <?php echo e(ucfirst($member->membership_status ?? 'Active')); ?>

                    </span>
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                        <?php echo e(ucfirst($member->membership_type ?? 'Member')); ?>

                    </span>
                    <?php if($member->yearGroup): ?>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium text-white" style="background-color: <?php echo e($member->yearGroup->color); ?>;">
                            <i class="fas fa-users mr-1"></i>
                            <span class="hidden sm:inline"><?php echo e($member->yearGroup->abbreviation ?? $member->yearGroup->name); ?></span>
                            <span class="sm:hidden"><?php echo e($member->yearGroup->abbreviation ?? substr($member->yearGroup->name, 0, 10)); ?></span>
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="flex flex-col sm:flex-row gap-2 sm:gap-3">
            <a href="<?php echo e(route('members.edit', $member->id ?? 1)); ?>" class="inline-flex items-center justify-center px-4 py-2 bg-gradient-to-r from-blue-600 to-blue-700 text-white font-medium rounded-xl hover:from-blue-700 hover:to-blue-800 transition-all duration-200 text-sm sm:text-base">
                <i class="fas fa-edit mr-2"></i>
                Edit Member
            </a>
            <a href="<?php echo e(route('members.index')); ?>" class="inline-flex items-center justify-center px-4 py-2 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors duration-200 text-sm sm:text-base">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Members
            </a>
        </div>
    </div>

    <!-- Tab Navigation -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="flex border-b border-gray-200">
            <button onclick="switchTab('overview')" id="tab-overview" class="tab-button flex-1 px-3 sm:px-6 py-3 sm:py-4 text-xs sm:text-sm font-semibold text-gray-700 hover:text-blue-600 hover:bg-gray-50 transition-all duration-200 border-b-2 border-blue-600 text-blue-600">
                <i class="fas fa-user mr-1 sm:mr-2"></i>
                <span class="hidden xs:inline">Overview</span>
                <span class="xs:hidden">Info</span>
            </button>
            <button onclick="switchTab('payments')" id="tab-payments" class="tab-button flex-1 px-3 sm:px-6 py-3 sm:py-4 text-xs sm:text-sm font-semibold text-gray-700 hover:text-blue-600 hover:bg-gray-50 transition-all duration-200 border-b-2 border-transparent">
                <i class="fas fa-money-bill-wave mr-1 sm:mr-2"></i>
                <span class="hidden xs:inline">Payments</span>
                <span class="xs:hidden">Pay</span>
                <span class="ml-1 sm:ml-2 inline-flex items-center px-1.5 sm:px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                    <?php echo e($payments->count()); ?>

                </span>
            </button>
        </div>
    </div>

    <!-- Overview Tab -->
    <div id="content-overview" class="tab-content">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Left Column -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Personal Information -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center mb-6">
                    <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-xl flex items-center justify-center mr-3">
                        <i class="fas fa-user text-white"></i>
                    </div>
                    <h2 class="text-lg font-semibold text-gray-900">Personal Information</h2>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Full Name</label>
                        <p class="text-gray-900"><?php echo e($member->full_name ?? 'John Doe'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Date of Birth</label>
                        <p class="text-gray-900">
                            <?php if($member->date_of_birth ?? false): ?>
                                <?php echo e($member->date_of_birth->format('F j, Y')); ?> (<?php echo e($member->age); ?> years old)
                            <?php else: ?>
                                Not provided
                            <?php endif; ?>
                        </p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Gender</label>
                        <p class="text-gray-900"><?php echo e(ucfirst($member->gender ?? 'Not specified')); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Marital Status</label>
                        <p class="text-gray-900"><?php echo e(ucfirst($member->marital_status ?? 'Not specified')); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Occupation</label>
                        <p class="text-gray-900"><?php echo e($member->occupation ?? 'Not provided'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Employer</label>
                        <p class="text-gray-900"><?php echo e($member->employer ?? 'Not provided'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Contact Information -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center mb-6">
                    <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-emerald-600 rounded-xl flex items-center justify-center mr-3">
                        <i class="fas fa-phone text-white"></i>
                    </div>
                    <h2 class="text-lg font-semibold text-gray-900">Contact Information</h2>
                </div>

                <div class="space-y-4">
                    <div class="flex items-center">
                        <i class="fas fa-envelope w-5 mr-3 text-gray-400"></i>
                        <div>
                            <label class="block text-sm font-medium text-gray-500">Email</label>
                            <p class="text-gray-900"><?php echo e($member->email ?? 'Not provided'); ?></p>
                        </div>
                    </div>
                    <div class="flex items-center">
                        <i class="fas fa-phone w-5 mr-3 text-gray-400"></i>
                        <div>
                            <label class="block text-sm font-medium text-gray-500">Primary Phone</label>
                            <p class="text-gray-900"><?php echo e($member->phone ?? 'Not provided'); ?></p>
                        </div>
                    </div>
                    <?php if($member->alternate_phone ?? false): ?>
                        <div class="flex items-center">
                            <i class="fas fa-mobile-alt w-5 mr-3 text-gray-400"></i>
                            <div>
                                <label class="block text-sm font-medium text-gray-500">Alternate Phone</label>
                                <p class="text-gray-900"><?php echo e($member->alternate_phone); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="flex items-start">
                        <i class="fas fa-map-marker-alt w-5 mr-3 text-gray-400 mt-1"></i>
                        <div>
                            <label class="block text-sm font-medium text-gray-500">Address</label>
                            <p class="text-gray-900">
                                <?php if($member->address ?? false): ?>
                                    <?php echo e($member->address); ?><br>
                                    <?php echo e($member->city ?? ''); ?><?php echo e($member->city && $member->state ? ', ' : ''); ?><?php echo e($member->state ?? ''); ?> <?php echo e($member->postal_code ?? ''); ?><br>
                                    <?php echo e($member->country ?? ''); ?>

                                <?php else: ?>
                                    Not provided
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Family Information -->
            <?php if($member->family ?? false): ?>
                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                    <div class="flex items-center mb-6">
                        <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-600 rounded-xl flex items-center justify-center mr-3">
                            <i class="fas fa-home text-white"></i>
                        </div>
                        <h2 class="text-lg font-semibold text-gray-900">Family Information</h2>
                    </div>

                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Family Name</label>
                            <p class="text-gray-900"><?php echo e($member->family->family_name ?? 'Not assigned'); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Relationship to Head</label>
                            <p class="text-gray-900"><?php echo e(ucfirst($member->relationship_to_head ?? 'Not specified')); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Family Members</label>
                            <div class="space-y-2">
                                <?php $__currentLoopData = $member->family->members ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $familyMember): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-center justify-between p-2 bg-gray-50 rounded-lg">
                                        <div class="flex items-center space-x-3">
                                            <div class="w-8 h-8 bg-gradient-to-br from-blue-400 to-purple-500 rounded-full flex items-center justify-center">
                                                <i class="fas fa-user text-white text-xs"></i>
                                            </div>
                                            <div>
                                                <p class="font-medium text-gray-900"><?php echo e($familyMember->full_name); ?></p>
                                                <p class="text-sm text-gray-600"><?php echo e(ucfirst($familyMember->relationship_to_head ?? 'Member')); ?></p>
                                            </div>
                                        </div>
                                        <?php if($familyMember->id !== $member->id): ?>
                                            <a href="<?php echo e(route('members.show', $familyMember->id)); ?>" class="text-blue-600 hover:text-blue-800 text-sm">View</a>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Ministry Involvement -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center mb-6">
                    <div class="w-10 h-10 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-xl flex items-center justify-center mr-3">
                        <i class="fas fa-hands-praying text-white"></i>
                    </div>
                    <h2 class="text-lg font-semibold text-gray-900">Ministry Involvement</h2>
                </div>

                <?php if($member->activeMinistries ?? false): ?>
                    <div class="space-y-3">
                        <?php $__currentLoopData = $member->activeMinistries ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ministry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center justify-between p-4 bg-purple-50 rounded-xl">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-600 rounded-lg flex items-center justify-center">
                                        <i class="fas fa-hands-praying text-white"></i>
                                    </div>
                                    <div>
                                        <h3 class="font-medium text-gray-900"><?php echo e($ministry->name); ?></h3>
                                        <p class="text-sm text-gray-600"><?php echo e(ucfirst($ministry->pivot ? $ministry->pivot->role ?? 'Member' : 'Member')); ?></p>
                                    </div>
                                </div>
                                <span class="text-sm text-gray-500">
                                    Since <?php echo e(($ministry->pivot && $ministry->pivot->joined_date) ? \Carbon\Carbon::parse($ministry->pivot->joined_date)->format('M Y') : 'Unknown'); ?>

                                </span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p class="text-gray-500 text-center py-8">Not currently involved in any ministries</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Right Column -->
        <div class="space-y-6">
            <!-- Quick Stats -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick Stats</h3>
                <div class="space-y-4">
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Member Since</span>
                        <span class="font-medium text-gray-900">
                            <?php echo e($member->membership_date ? $member->membership_date->format('M Y') : 'Unknown'); ?>

                        </span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Total Donations</span>
                        <span class="font-medium text-green-600">₵<?php echo e(number_format($member->total_donations ?? 0, 2)); ?></span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">This Year</span>
                        <span class="font-medium text-green-600">₵<?php echo e(number_format($member->yearly_donations ?? 0, 2)); ?></span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600">Active Ministries</span>
                        <span class="font-medium text-purple-600"><?php echo e($member->activeMinistries ? $member->activeMinistries->count() : 0); ?></span>
                    </div>
                </div>
            </div>

            <!-- Year Group Information -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center mb-4">
                    <div class="w-8 h-8 bg-gradient-to-br from-orange-500 to-red-600 rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-users text-white text-sm"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Year Group</h3>
                </div>

                <?php if($member->yearGroup): ?>
                    <div class="p-4 rounded-xl border-2" style="background-color: <?php echo e($member->yearGroup->color); ?>15; border-color: <?php echo e($member->yearGroup->color); ?>40;">
                        <div class="flex items-center justify-between mb-3">
                            <div class="flex items-center">
                                <div class="w-4 h-4 rounded-full mr-3" style="background-color: <?php echo e($member->yearGroup->color); ?>;"></div>
                                <div>
                                    <h4 class="font-semibold text-gray-900"><?php echo e($member->yearGroup->name); ?></h4>
                                    <?php if($member->yearGroup->abbreviation): ?>
                                        <span class="inline-block px-2 py-1 text-xs font-bold rounded mt-1 text-white" style="background-color: <?php echo e($member->yearGroup->color); ?>;">
                                            <?php echo e($member->yearGroup->abbreviation); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if($member->age): ?>
                                <span class="text-sm font-medium text-gray-600">Age: <?php echo e($member->age); ?></span>
                            <?php endif; ?>
                        </div>
                        
                        <div class="space-y-2">
                            <div class="flex justify-between items-center">
                                <span class="text-sm text-gray-600">Age Range</span>
                                <span class="text-sm font-medium text-gray-900">
                                    <?php echo e($member->yearGroup->min_age); ?>-<?php echo e($member->yearGroup->max_age == 999 ? '∞' : $member->yearGroup->max_age); ?> years
                                </span>
                            </div>
                            <?php if($member->yearGroup->description): ?>
                                <div class="pt-2 border-t border-gray-200">
                                    <p class="text-xs text-gray-600"><?php echo e($member->yearGroup->description); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="p-4 bg-gray-50 rounded-xl border border-gray-200">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-triangle text-yellow-500 mr-3"></i>
                            <div>
                                <p class="text-sm font-medium text-gray-900">Not Assigned</p>
                                <p class="text-xs text-gray-600">Year group will be assigned when date of birth is provided</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Spiritual Information -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center mb-4">
                    <div class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-cross text-white text-sm"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Spiritual Journey</h3>
                </div>

                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Baptized</span>
                        <div class="flex items-center">
                            <?php if($member->is_baptized ?? false): ?>
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-green-600">Yes</span>
                            <?php else: ?>
                                <i class="fas fa-times-circle text-gray-400 mr-2"></i>
                                <span class="text-gray-500">No</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if($member->baptism_date ?? false): ?>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Baptism Date</span>
                            <span class="font-medium text-gray-900"><?php echo e($member->baptism_date->format('M j, Y')); ?></span>
                        </div>
                    <?php endif; ?>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Confirmed</span>
                        <div class="flex items-center">
                            <?php if($member->is_confirmed ?? false): ?>
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-green-600">Yes</span>
                            <?php else: ?>
                                <i class="fas fa-times-circle text-gray-400 mr-2"></i>
                                <span class="text-gray-500">No</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if($member->confirmation_date ?? false): ?>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Confirmation Date</span>
                            <span class="font-medium text-gray-900"><?php echo e($member->confirmation_date->format('M j, Y')); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Emergency Contact -->
            <?php if($member->emergency_contact_name ?? false): ?>
                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                    <div class="flex items-center mb-4">
                        <div class="w-8 h-8 bg-gradient-to-br from-red-500 to-pink-600 rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-exclamation-triangle text-white text-sm"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900">Emergency Contact</h3>
                    </div>

                    <div class="space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-500">Name</label>
                            <p class="text-gray-900"><?php echo e($member->emergency_contact_name); ?></p>
                        </div>
                        <?php if($member->emergency_contact_phone ?? false): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-500">Phone</label>
                                <p class="text-gray-900"><?php echo e($member->emergency_contact_phone); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Communication Preferences -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Communication</h3>
                <div class="space-y-3">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Email Newsletter</span>
                        <div class="flex items-center">
                            <?php if($member->receive_newsletter ?? false): ?>
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-green-600">Subscribed</span>
                            <?php else: ?>
                                <i class="fas fa-times-circle text-gray-400 mr-2"></i>
                                <span class="text-gray-500">Not subscribed</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">SMS Notifications</span>
                        <div class="flex items-center">
                            <?php if($member->receive_sms ?? false): ?>
                                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                <span class="text-green-600">Enabled</span>
                            <?php else: ?>
                                <i class="fas fa-times-circle text-gray-400 mr-2"></i>
                                <span class="text-gray-500">Disabled</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Additional Notes -->
            <?php if($member->notes ?? false): ?>
                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Notes</h3>
                    <p class="text-gray-700 whitespace-pre-line"><?php echo e($member->notes); ?></p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    </div>
    <!-- End Overview Tab -->

    <!-- Payments Tab -->
    <div id="content-payments" class="tab-content hidden">
        <!-- Payment Statistics -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6 mb-6 sm:mb-8">
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-600 mb-1">Total Payments</p>
                        <p class="text-3xl font-bold text-blue-600"><?php echo e($paymentStats['total_payments']); ?></p>
                    </div>
                    <div class="w-12 h-12 bg-blue-100 rounded-xl flex items-center justify-center">
                        <i class="fas fa-receipt text-blue-600 text-xl"></i>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-600 mb-1">Total Amount</p>
                        <p class="text-3xl font-bold text-green-600">₵<?php echo e(number_format($paymentStats['total_amount'], 2)); ?></p>
                    </div>
                    <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center">
                        <i class="fas fa-coins text-green-600 text-xl"></i>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-600 mb-1">Tithe Payments</p>
                        <p class="text-3xl font-bold text-purple-600"><?php echo e($paymentStats['tithe_payments']); ?></p>
                        <p class="text-xs text-gray-500 mt-1">₵<?php echo e(number_format($paymentStats['tithe_amount'], 2)); ?></p>
                    </div>
                    <div class="w-12 h-12 bg-purple-100 rounded-xl flex items-center justify-center">
                        <i class="fas fa-hand-holding-heart text-purple-600 text-xl"></i>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-600 mb-1">This Year</p>
                        <p class="text-3xl font-bold text-orange-600">₵<?php echo e(number_format($paymentStats['this_year_total'], 2)); ?></p>
                        <p class="text-xs text-gray-500 mt-1">This month: ₵<?php echo e(number_format($paymentStats['this_month_total'], 2)); ?></p>
                    </div>
                    <div class="w-12 h-12 bg-orange-100 rounded-xl flex items-center justify-center">
                        <i class="fas fa-chart-line text-orange-600 text-xl"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payments Table -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
            <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gradient-to-r from-blue-50 to-indigo-50">
                <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3 sm:gap-0">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-gradient-to-r from-blue-600 to-indigo-600 rounded-xl flex items-center justify-center mr-3 sm:mr-4">
                            <i class="fas fa-list text-white"></i>
                        </div>
                        <div>
                            <h2 class="text-lg sm:text-xl font-bold text-gray-900">Payment History</h2>
                            <p class="text-xs sm:text-sm text-gray-600">All payments including tithe and offerings</p>
                        </div>
                    </div>
                    <a href="<?php echo e(route('member-payments.create')); ?>?member_id=<?php echo e($member->id); ?>" class="inline-flex items-center justify-center px-4 py-2 bg-gradient-to-r from-green-600 to-emerald-600 text-white font-semibold rounded-xl hover:from-green-700 hover:to-emerald-700 transition-all duration-200 shadow-md hover:shadow-lg text-sm w-full sm:w-auto">
                        <i class="fas fa-plus mr-2"></i>
                        New Payment
                    </a>
                </div>
            </div>

            <?php if($payments->count() > 0): ?>
                <div class="overflow-x-auto -mx-4 sm:mx-0">
                    <div class="inline-block min-w-full align-middle">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">Date</th>
                                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">Type</th>
                                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden md:table-cell">Description</th>
                                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">Amount</th>
                                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden sm:table-cell">Method</th>
                                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden lg:table-cell">Status</th>
                                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">Actions</th>
                                </tr>
                            </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-3 sm:px-6 py-3 sm:py-4 whitespace-nowrap">
                                        <div class="text-xs sm:text-sm font-medium text-gray-900"><?php echo e($payment->payment_date->format('M d, Y')); ?></div>
                                        <div class="text-xs text-gray-500 hidden sm:block"><?php echo e($payment->payment_date->diffForHumans()); ?></div>
                                    </td>
                                    <td class="px-3 sm:px-6 py-3 sm:py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <?php
                                                $iconMap = [
                                                    'tithe' => ['icon' => 'fa-hand-holding-heart', 'color' => 'purple'],
                                                    'offering' => ['icon' => 'fa-gift', 'color' => 'blue'],
                                                    'welfare' => ['icon' => 'fa-heart', 'color' => 'pink'],
                                                    'building_fund' => ['icon' => 'fa-building', 'color' => 'indigo'],
                                                    'special_offering' => ['icon' => 'fa-star', 'color' => 'yellow'],
                                                    'thanksgiving' => ['icon' => 'fa-praying-hands', 'color' => 'green'],
                                                    'other' => ['icon' => 'fa-coins', 'color' => 'gray']
                                                ];
                                                $icon = $iconMap[$payment->payment_type] ?? $iconMap['other'];
                                            ?>
                                            <div class="w-6 h-6 sm:w-8 sm:h-8 bg-<?php echo e($icon['color']); ?>-100 rounded-lg flex items-center justify-center mr-2 sm:mr-3 flex-shrink-0">
                                                <i class="fas <?php echo e($icon['icon']); ?> text-<?php echo e($icon['color']); ?>-600 text-xs sm:text-sm"></i>
                                            </div>
                                            <div class="min-w-0">
                                                <div class="text-xs sm:text-sm font-medium text-gray-900 truncate"><?php echo e($payment->payment_type_display); ?></div>
                                                <div class="text-xs text-gray-500 hidden sm:block truncate"><?php echo e($payment->payment_reference); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-3 sm:px-6 py-3 sm:py-4 hidden md:table-cell">
                                        <div class="text-xs sm:text-sm text-gray-900"><?php echo e(Str::limit($payment->description ?? 'No description', 40)); ?></div>
                                    </td>
                                    <td class="px-3 sm:px-6 py-3 sm:py-4 whitespace-nowrap">
                                        <div class="text-xs sm:text-sm font-bold text-green-600">₵<?php echo e(number_format($payment->amount, 2)); ?></div>
                                    </td>
                                    <td class="px-3 sm:px-6 py-3 sm:py-4 whitespace-nowrap hidden sm:table-cell">
                                        <span class="inline-flex items-center px-2 sm:px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                            <?php echo e(ucwords(str_replace('_', ' ', $payment->payment_method))); ?>

                                        </span>
                                    </td>
                                    <td class="px-3 sm:px-6 py-3 sm:py-4 whitespace-nowrap hidden lg:table-cell">
                                        <?php echo $payment->status_badge; ?>

                                    </td>
                                    <td class="px-3 sm:px-6 py-3 sm:py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex items-center space-x-1 sm:space-x-2">
                                            <a href="<?php echo e(route('member-payments.show', $payment)); ?>" class="text-blue-600 hover:text-blue-900 p-1" title="View">
                                                <i class="fas fa-eye text-xs sm:text-sm"></i>
                                            </a>
                                            <a href="<?php echo e(route('member-payments.edit', $payment)); ?>" class="text-indigo-600 hover:text-indigo-900 p-1" title="Edit">
                                                <i class="fas fa-edit text-xs sm:text-sm"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    </div>
                </div>
            <?php else: ?>
                <div class="px-6 py-12 text-center">
                    <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-money-bill-wave text-2xl text-gray-400"></i>
                    </div>
                    <p class="text-gray-500 font-medium mb-2">No payments recorded</p>
                    <p class="text-sm text-gray-400 mb-4">This member hasn't made any payments yet.</p>
                    <a href="<?php echo e(route('member-payments.create')); ?>?member_id=<?php echo e($member->id); ?>" class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-600 to-indigo-600 text-white font-semibold rounded-xl hover:from-blue-700 hover:to-indigo-700 transition-all duration-200">
                        <i class="fas fa-plus mr-2"></i>
                        Record First Payment
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <!-- End Payments Tab -->
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function switchTab(tabName) {
    // Hide all tab contents
    document.querySelectorAll('.tab-content').forEach(content => {
        content.classList.add('hidden');
    });
    
    // Remove active styles from all tabs
    document.querySelectorAll('.tab-button').forEach(button => {
        button.classList.remove('border-blue-600', 'text-blue-600');
        button.classList.add('border-transparent');
    });
    
    // Show selected tab content
    document.getElementById('content-' + tabName).classList.remove('hidden');
    
    // Add active styles to selected tab
    const activeTab = document.getElementById('tab-' + tabName);
    activeTab.classList.add('border-blue-600', 'text-blue-600');
    activeTab.classList.remove('border-transparent');
}

// Check URL hash on page load
document.addEventListener('DOMContentLoaded', function() {
    const hash = window.location.hash.substring(1);
    if (hash === 'payments') {
        switchTab('payments');
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/members/show.blade.php ENDPATH**/ ?>