<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Member Registration</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gradient-to-br from-blue-50 via-white to-red-50">
    <div class="min-h-screen py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-4xl mx-auto">
            <!-- Church Logo and Name -->
            <div class="text-center mb-8">
                <div class="flex items-center justify-center mb-4">
                    <?php
                        $logoPath = \DB::table('settings')->where('key', 'organization_logo')->value('value');
                        $organizationName = \DB::table('settings')->where('key', 'organization_name')->value('value') ?? 'Presbyterian Church of Ghana';
                        $organizationSlogan = \DB::table('settings')->where('key', 'organization_slogan')->value('value');
                    ?>
                    
                    <?php if($logoPath && file_exists(public_path('storage/' . $logoPath))): ?>
                        <img src="<?php echo e(asset('storage/' . $logoPath)); ?>" alt="<?php echo e($organizationName); ?>" class="h-24 w-auto mr-4">
                    <?php else: ?>
                        <div class="w-24 h-24 bg-gradient-to-r from-blue-600 to-red-600 rounded-full flex items-center justify-center mr-4 shadow-xl">
                            <i class="fas fa-church text-white text-4xl"></i>
                        </div>
                    <?php endif; ?>
                    
                    <div class="text-left">
                        <h1 class="text-3xl md:text-4xl font-bold text-gray-900"><?php echo e($organizationName); ?></h1>
                        <?php if($organizationSlogan): ?>
                            <p class="text-blue-600 font-semibold  text-base mt-1"><?php echo e($organizationSlogan); ?></p>
                        <?php endif; ?>
                        <p class="text-gray-600 text-lg mt-1">Member Registration</p>
                    </div>
                </div>
                <div class="h-1 w-32 bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 mx-auto rounded-full"></div>
            </div>

            <!-- Header -->
            <div class="text-center mb-10">
                <div class="relative inline-block mb-6">
                    <div class="absolute inset-0 bg-gradient-to-r from-blue-600 to-red-600 rounded-full blur-2xl opacity-30 animate-pulse"></div>
                    <div class="relative w-24 h-24 bg-gradient-to-r from-blue-600 to-red-600 rounded-full flex items-center justify-center shadow-2xl mx-auto">
                        <i class="fas fa-user-plus text-white text-4xl"></i>
                    </div>
                </div>
                <h2 class="text-5xl font-bold bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 bg-clip-text text-transparent mb-4">Join Our Church Family</h2>
                <p class="text-gray-700 text-xl">Complete the form below to register as a member</p>
            </div>

            <!-- Registration Form -->
            <div class="bg-white rounded-3xl shadow-2xl p-8 border-2 border-gray-100">
                <?php if($errors->any()): ?>
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-xl">
                        <div class="flex">
                            <i class="fas fa-exclamation-circle text-red-500 mt-1 mr-3"></i>
                            <div>
                                <h3 class="font-bold text-red-800">Please correct the following errors:</h3>
                                <ul class="mt-2 text-sm text-red-700 list-disc list-inside">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('member.register.submit')); ?>" method="POST" enctype="multipart/form-data" class="space-y-8">
                    <?php echo csrf_field(); ?>

                    <!-- Personal Information -->
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-user text-blue-600 mr-3"></i>
                            Personal Information
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Title</label>
                                <select name="title" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                    <option value="">Select Title</option>
                                    <option value="Mr">Mr</option>
                                    <option value="Mrs">Mrs</option>
                                    <option value="Miss">Miss</option>
                                    <option value="Dr">Dr</option>
                                    <option value="Rev">Rev</option>
                                    <option value="Prof">Prof</option>
                                </select>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">First Name <span class="text-red-600">*</span></label>
                                <input type="text" name="first_name" value="<?php echo e(old('first_name')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Middle Name</label>
                                <input type="text" name="middle_name" value="<?php echo e(old('middle_name')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Last Name <span class="text-red-600">*</span></label>
                                <input type="text" name="last_name" value="<?php echo e(old('last_name')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Date of Birth <span class="text-red-600">*</span></label>
                                <input type="date" name="date_of_birth" value="<?php echo e(old('date_of_birth')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Gender <span class="text-red-600">*</span></label>
                                <select name="gender" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                    <option value="">Select Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                </select>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Marital Status <span class="text-red-600">*</span></label>
                                <select name="marital_status" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                    <option value="">Select Status</option>
                                    <option value="single">Single</option>
                                    <option value="married">Married</option>
                                    <option value="divorced">Divorced</option>
                                    <option value="widowed">Widowed</option>
                                </select>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Occupation</label>
                                <input type="text" name="occupation" value="<?php echo e(old('occupation')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="e.g., Senior Manager, Head Teacher">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Profession</label>
                                <input type="text" name="profession" value="<?php echo e(old('profession')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="e.g., Medical Doctor, Lawyer, Engineer">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Home Town</label>
                                <input type="text" name="home_town" value="<?php echo e(old('home_town')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="e.g., Kumasi, Cape Coast, Tamale">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">AKA (Also Known As)</label>
                                <input type="text" name="aka" value="<?php echo e(old('aka')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="Nickname or other names">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Highest Qualification</label>
                                <select name="highest_qualification" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                    <option value="">Select Qualification</option>
                                    <option value="none">No Formal Education</option>
                                    <option value="primary">Primary School</option>
                                    <option value="jhs">Junior High School</option>
                                    <option value="shs">Senior High School</option>
                                    <option value="tertiary">Tertiary/University</option>
                                    <option value="postgraduate">Postgraduate</option>
                                    <option value="professional">Professional Certification</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Day Born</label>
                                <select name="day_born" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                    <option value="">Select Day</option>
                                    <option value="Sunday">Sunday</option>
                                    <option value="Monday">Monday</option>
                                    <option value="Tuesday">Tuesday</option>
                                    <option value="Wednesday">Wednesday</option>
                                    <option value="Thursday">Thursday</option>
                                    <option value="Friday">Friday</option>
                                    <option value="Saturday">Saturday</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-phone text-blue-600 mr-3"></i>
                            Contact Information
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Phone Number <span class="text-red-600">*</span></label>
                                <input type="tel" name="phone" value="<?php echo e(old('phone')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="0244123456">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                                <input type="email" name="email" value="<?php echo e(old('email')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="email@example.com">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">WhatsApp Phone <span class="text-gray-500 text-xs">(if different)</span></label>
                                <input type="tel" name="whatsapp_phone" value="<?php echo e(old('whatsapp_phone')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="WhatsApp number">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Employer</label>
                                <input type="text" name="employer" value="<?php echo e(old('employer')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="Company or organization name">
                            </div>

                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Address <span class="text-red-600">*</span></label>
                                <input type="text" name="address" value="<?php echo e(old('address')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="House/Street Address">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">City <span class="text-red-600">*</span></label>
                                <input type="text" name="city" value="<?php echo e(old('city')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Region/State <span class="text-red-600">*</span></label>
                                <input type="text" name="state" value="<?php echo e(old('state')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Country <span class="text-red-600">*</span></label>
                                <input type="text" name="country" value="<?php echo e(old('country', 'Ghana')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Postal Code</label>
                                <input type="text" name="postal_code" value="<?php echo e(old('postal_code')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>
                        </div>
                    </div>

                    <!-- Membership Information -->
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-church text-blue-600 mr-3"></i>
                            Membership Information
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Membership Type <span class="text-red-600">*</span></label>
                                <select name="membership_type" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                    <option value="">Select Type</option>
                                    <option value="communicant">Communicant</option>
                                    <option value="baptized">Baptized</option>
                                    <option value="confirmed">Confirmed</option>
                                    <option value="adherent">Adherent</option>
                                    <option value="catechumen">Catechumen</option>
                                </select>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Membership Date <span class="text-red-600">*</span></label>
                                <input type="date" name="membership_date" value="<?php echo e(old('membership_date', date('Y-m-d'))); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Previous Church Affiliation</label>
                                <input type="text" name="church_affiliation" value="<?php echo e(old('church_affiliation')); ?>" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="Name of previous church (if any)">
                            </div>
                        </div>
                    </div>

                    <!-- Emergency Contact -->
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-ambulance text-blue-600 mr-3"></i>
                            Emergency Contact
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Contact Name <span class="text-red-600">*</span></label>
                                <input type="text" name="emergency_contact_name" value="<?php echo e(old('emergency_contact_name')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Contact Phone <span class="text-red-600">*</span></label>
                                <input type="tel" name="emergency_contact_phone" value="<?php echo e(old('emergency_contact_phone')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>

                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Relationship <span class="text-red-600">*</span></label>
                                <input type="text" name="emergency_contact_relationship" value="<?php echo e(old('emergency_contact_relationship')); ?>" required 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                       placeholder="e.g., Spouse, Parent, Sibling">
                            </div>
                        </div>
                    </div>

                    <!-- Spiritual Information -->
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-cross text-blue-600 mr-3"></i>
                            Spiritual Information
                        </h3>
                        
                        <!-- Baptism -->
                        <div class="mb-6">
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="is_baptized" id="is_baptized" value="1" class="h-4 w-4 text-blue-600 rounded" onchange="toggleSection('baptism-section')">
                                <label for="is_baptized" class="ml-2 text-sm font-semibold text-gray-900">Are you baptized? YES/NO. IF YES,</label>
                            </div>
                            <div id="baptism-section" class="hidden grid grid-cols-1 md:grid-cols-2 gap-4 ml-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Date of Baptism</label>
                                    <input type="date" name="baptism_date" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Place of Baptism</label>
                                    <input type="text" name="place_of_baptism" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Type of Baptism</label>
                                    <div class="space-y-2">
                                        <label class="flex items-center"><input type="radio" name="baptism_type" value="sprinkling" class="mr-2">Sprinkling</label>
                                        <label class="flex items-center"><input type="radio" name="baptism_type" value="immersion" class="mr-2">Immersion</label>
                                        <label class="flex items-center"><input type="radio" name="baptism_type" value="pouring" class="mr-2">Pouring Water</label>
                                        <label class="flex items-center"><input type="radio" name="baptism_type" value="other" class="mr-2">Other</label>
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Officiating Minister</label>
                                    <input type="text" name="baptism_officiating_minister" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                            </div>
                        </div>

                        <!-- Confirmation -->
                        <div class="mb-6">
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="is_confirmed" id="is_confirmed" value="1" class="h-4 w-4 text-blue-600 rounded" onchange="toggleSection('confirmation-section')">
                                <label for="is_confirmed" class="ml-2 text-sm font-semibold text-gray-900">Are you confirmed? YES/NO. IF YES,</label>
                            </div>
                            <div id="confirmation-section" class="hidden grid grid-cols-1 md:grid-cols-2 gap-4 ml-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Date Confirmed</label>
                                    <input type="date" name="confirmation_date" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Place Confirmed</label>
                                    <input type="text" name="place_of_confirmation" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Age Confirmed</label>
                                    <input type="number" name="age_confirmed" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Bible Verse Used</label>
                                    <input type="text" name="confirmation_bible_verse" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                                <div class="md:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Officiating Minister</label>
                                    <input type="text" name="confirmation_officiating_minister" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                            </div>
                        </div>

                        <!-- Marriage -->
                        <div>
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="is_married" id="is_married" value="1" class="h-4 w-4 text-blue-600 rounded" onchange="toggleSection('marriage-section')">
                                <label for="is_married" class="ml-2 text-sm font-semibold text-gray-900">If you are married, then</label>
                            </div>
                            <div id="marriage-section" class="hidden grid grid-cols-1 md:grid-cols-2 gap-4 ml-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Date of Marriage</label>
                                    <input type="date" name="marriage_date" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Place of Marriage</label>
                                    <input type="text" name="place_of_marriage" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Type of Marriage</label>
                                    <div class="space-y-2">
                                        <label class="flex items-center"><input type="radio" name="marriage_type" value="traditional" class="mr-2">Traditional</label>
                                        <label class="flex items-center"><input type="radio" name="marriage_type" value="customary" class="mr-2">Customary</label>
                                        <label class="flex items-center"><input type="radio" name="marriage_type" value="ordinance" class="mr-2">Ordinance</label>
                                        <label class="flex items-center"><input type="radio" name="marriage_type" value="other" class="mr-2">Other</label>
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Officiating Minister</label>
                                    <input type="text" name="marriage_officiating_minister" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Health Information & Schooling -->
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-heartbeat text-blue-600 mr-3"></i>
                            Health & Education Information
                        </h3>
                        
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Medical Conditions / Allergies</label>
                                <textarea name="medical_conditions" rows="2" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500" placeholder="List any medical conditions or allergies"></textarea>
                            </div>

                            <!-- Physically Challenged -->
                            <div>
                                <div class="flex items-center mb-3">
                                    <input type="checkbox" name="physically_challenged" id="physically_challenged" value="1" class="h-4 w-4 text-blue-600 rounded" onchange="toggleSection('disability-section')">
                                    <label for="physically_challenged" class="ml-2 text-sm font-semibold text-gray-900">PHYSICALLY CHALLENGED? YES/NO. IF YES,</label>
                                </div>
                                <div id="disability-section" class="hidden ml-6">
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Disability Type</label>
                                    <select name="disability_type" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                        <option value="">Select Disability Type</option>
                                        <option value="mobility">Mobility/Physical</option>
                                        <option value="visual">Visual Impairment</option>
                                        <option value="hearing">Hearing Impairment</option>
                                        <option value="speech">Speech Impairment</option>
                                        <option value="intellectual">Intellectual Disability</option>
                                        <option value="learning">Learning Disability</option>
                                        <option value="mental_health">Mental Health Condition</option>
                                        <option value="chronic_illness">Chronic Illness</option>
                                        <option value="multiple">Multiple Disabilities</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Currently Schooling -->
                            <div class="bg-blue-50 p-4 rounded-lg">
                                <div class="flex items-center mb-3">
                                    <input type="checkbox" name="currently_schooling" id="currently_schooling" value="1" class="h-4 w-4 text-blue-600 rounded" onchange="toggleSection('school-section')">
                                    <label for="currently_schooling" class="ml-2 text-sm font-semibold text-gray-900">ARE YOU CURRENTLY SCHOOLING? YES/NO. IF YES,</label>
                                </div>
                                <div id="school-section" class="hidden grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-1">Name of School</label>
                                        <input type="text" name="school_name" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-1">Admission Date</label>
                                        <input type="date" name="school_admission_date" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-1">Expected Completion Date</label>
                                        <input type="date" name="school_completion_date" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-1">School Telephone</label>
                                        <input type="tel" name="school_telephone" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                    </div>
                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-medium text-gray-700 mb-1">School Location/Address</label>
                                        <textarea name="school_location" rows="2" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Guardian Information -->
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-user-shield text-blue-600 mr-3"></i>
                            Guardian Information <span class="text-sm text-gray-500 font-normal ml-2">(For Minors)</span>
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Guardian Name</label>
                                <input type="text" name="guardian_name" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Guardian Relationship</label>
                                <input type="text" name="guardian_relationship" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500" placeholder="e.g., Father, Mother, Uncle">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Guardian Phone</label>
                                <input type="tel" name="guardian_phone" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Guardian Address</label>
                                <textarea name="guardian_address" rows="2" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500"></textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Photo Upload -->
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-camera text-blue-600 mr-3"></i>
                            Photo (Optional)
                        </h3>
                        <div>
                            <input type="file" name="photo" accept="image/*" 
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <p class="text-sm text-gray-500 mt-1">Maximum file size: 2MB. Accepted formats: JPG, PNG</p>
                        </div>
                    </div>

                    <!-- Hidden fields for defaults -->
                    <input type="hidden" name="has_family" value="0">
                    <input type="hidden" name="is_baptized" value="0">
                    <input type="hidden" name="is_confirmed" value="0">
                    <input type="hidden" name="is_married" value="0">
                    <input type="hidden" name="physically_challenged" value="0">
                    <input type="hidden" name="receive_newsletter" value="1">
                    <input type="hidden" name="receive_sms" value="1">

                    <!-- Submit Button -->
                    <div class="border-t pt-6">
                        <button type="submit" 
                                class="w-full px-8 py-4 bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 text-white font-bold text-lg rounded-2xl hover:from-blue-700 hover:via-purple-700 hover:to-red-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                            <i class="fas fa-paper-plane mr-2"></i>
                            Submit Registration
                        </button>
                        <p class="text-center text-sm text-gray-600 mt-4">
                            <i class="fas fa-info-circle mr-1"></i>
                            Your registration will be reviewed and approved by church administrators
                        </p>
                    </div>
                </form>
            </div>

            <!-- Back Link -->
            <div class="text-center mt-6">
                <a href="<?php echo e(url('/')); ?>" class="text-blue-600 hover:text-blue-700 font-medium">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Back to Home
                </a>
            </div>
        </div>
    </div>

    <script>
    // Toggle conditional sections
    function toggleSection(sectionId) {
        const section = document.getElementById(sectionId);
        if (section) {
            section.classList.toggle('hidden');
        }
    }
    </script>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/member-registration/create.blade.php ENDPATH**/ ?>