<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="max-w-2xl mx-auto">
        <!-- Back Navigation -->
        <div class="mb-6">
            <a href="<?php echo e(route('users.show', $user)); ?>" class="inline-flex items-center text-gray-600 hover:text-purple-600 transition-colors duration-200">
                <i class="fas fa-arrow-left mr-2"></i>
                <span class="font-medium">Back to User Profile</span>
            </a>
        </div>

        <!-- Page Header -->
        <div class="mb-8 bg-gradient-to-r from-red-600 via-orange-600 to-yellow-600 rounded-xl shadow-lg p-6 text-white">
            <div class="flex items-center">
                <div class="w-16 h-16 rounded-full bg-white bg-opacity-20 flex items-center justify-center mr-4">
                    <i class="fas fa-key text-3xl"></i>
                </div>
                <div>
                    <h1 class="text-2xl font-bold">Reset Password</h1>
                    <p class="text-orange-100 text-sm"><?php echo e($user->name); ?></p>
                </div>
            </div>
        </div>

        <!-- Messages -->
        <?php if(session('success')): ?>
        <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
            <div class="flex items-center">
                <i class="fas fa-check-circle text-green-500 mr-3"></i>
                <p class="text-green-800 font-medium"><?php echo e(session('success')); ?></p>
            </div>
        </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
        <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-lg">
            <div class="flex items-center mb-2">
                <i class="fas fa-exclamation-circle text-red-500 mr-3"></i>
                <p class="text-red-800 font-medium">Please correct the errors below</p>
            </div>
        </div>
        <?php endif; ?>

        <!-- Form Card -->
        <div class="bg-white rounded-xl shadow-lg p-8">
            <!-- Security Notice -->
            <div class="mb-6 bg-yellow-50 border-l-4 border-yellow-400 p-4 rounded">
                <div class="flex items-start">
                    <i class="fas fa-shield-alt text-yellow-600 text-xl mr-3 mt-0.5"></i>
                    <div>
                        <h4 class="font-semibold text-yellow-800 mb-1">Security Notice</h4>
                        <p class="text-sm text-yellow-700">You are about to reset the password for <strong><?php echo e($user->name); ?></strong>. The user will need to use the new password to log in.</p>
                    </div>
                </div>
            </div>

            <!-- User Info Card -->
            <div class="mb-6 p-4 bg-gradient-to-r from-blue-50 to-purple-50 rounded-lg border border-blue-200">
                <h4 class="font-semibold text-gray-800 mb-3 flex items-center">
                    <i class="fas fa-user text-blue-600 mr-2"></i>
                    User Information
                </h4>
                <div class="grid grid-cols-2 gap-4 text-sm">
                    <div>
                        <span class="text-gray-600">Name:</span>
                        <p class="font-semibold text-gray-900"><?php echo e($user->name); ?></p>
                    </div>
                    <div>
                        <span class="text-gray-600">Email:</span>
                        <p class="font-semibold text-gray-900"><?php echo e($user->email); ?></p>
                    </div>
                    <div>
                        <span class="text-gray-600">Role:</span>
                        <p class="font-semibold text-gray-900">
                            <?php if($user->role === 'admin'): ?>
                                <span class="text-red-600">Administrator</span>
                            <?php elseif($user->role === 'staff'): ?>
                                <span class="text-blue-600">Staff Member</span>
                            <?php else: ?>
                                <span class="text-purple-600">Member</span>
                            <?php endif; ?>
                        </p>
                    </div>
                    <div>
                        <span class="text-gray-600">Account Created:</span>
                        <p class="font-semibold text-gray-900"><?php echo e($user->created_at->format('M d, Y')); ?></p>
                    </div>
                </div>
            </div>

            <!-- Password Form -->
            <form action="<?php echo e(route('users.update-password', $user)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <div class="space-y-6">
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-lock text-gray-400 mr-1"></i>
                            New Password <span class="text-red-500">*</span>
                        </label>
                        <input type="password" 
                               name="password" 
                               id="password" 
                               required
                               class="w-full px-4 py-3 rounded-lg border-gray-300 focus:ring-red-500 focus:border-red-500"
                               placeholder="Enter new password">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i>
                                <?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <p class="mt-2 text-xs text-gray-500">
                            <i class="fas fa-info-circle mr-1"></i>
                            Password must be at least 8 characters long
                        </p>
                    </div>
                    
                    <div>
                        <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-2">
                            <i class="fas fa-check-double text-gray-400 mr-1"></i>
                            Confirm New Password <span class="text-red-500">*</span>
                        </label>
                        <input type="password" 
                               name="password_confirmation" 
                               id="password_confirmation" 
                               required
                               class="w-full px-4 py-3 rounded-lg border-gray-300 focus:ring-red-500 focus:border-red-500"
                               placeholder="Confirm new password">
                        <p class="mt-2 text-xs text-gray-500">
                            <i class="fas fa-sync-alt mr-1"></i>
                            Must match the password above
                        </p>
                    </div>
                </div>

                <!-- Password Strength Tips -->
                <div class="mt-6 p-4 bg-blue-50 rounded-lg border border-blue-200">
                    <h5 class="font-semibold text-blue-900 text-sm mb-2 flex items-center">
                        <i class="fas fa-lightbulb text-blue-600 mr-2"></i>
                        Password Tips
                    </h5>
                    <ul class="text-xs text-blue-800 space-y-1">
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-600 mr-2 mt-0.5"></i>
                            <span>Use at least 8 characters</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-600 mr-2 mt-0.5"></i>
                            <span>Include uppercase and lowercase letters</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-600 mr-2 mt-0.5"></i>
                            <span>Add numbers and special characters</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check text-blue-600 mr-2 mt-0.5"></i>
                            <span>Avoid common words or patterns</span>
                        </li>
                    </ul>
                </div>
                
                <!-- Actions -->
                <div class="flex items-center justify-between pt-6 mt-6 border-t border-gray-200">
                    <a href="<?php echo e(route('users.show', $user)); ?>" 
                       class="px-6 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium transition">
                        <i class="fas fa-times mr-2"></i>
                        Cancel
                    </a>
                    
                    <button type="submit" 
                            class="px-8 py-2 bg-gradient-to-r from-red-600 to-orange-600 hover:from-red-700 hover:to-orange-700 text-white rounded-lg font-semibold shadow-lg transition">
                        <i class="fas fa-key mr-2"></i>
                        Reset Password
                    </button>
                </div>
            </form>
        </div>

        <!-- Additional Info -->
        <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4">
            <!-- What Happens Next -->
            <div class="bg-gradient-to-br from-green-50 to-emerald-50 rounded-lg p-4 border border-green-200">
                <h4 class="font-semibold text-green-900 text-sm mb-2 flex items-center">
                    <i class="fas fa-info-circle text-green-600 mr-2"></i>
                    What Happens Next?
                </h4>
                <ul class="text-xs text-green-800 space-y-1">
                    <li class="flex items-start">
                        <i class="fas fa-arrow-right text-green-600 mr-2 mt-0.5"></i>
                        <span>Password will be updated immediately</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-arrow-right text-green-600 mr-2 mt-0.5"></i>
                        <span>User must use new password to log in</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-arrow-right text-green-600 mr-2 mt-0.5"></i>
                        <span>Change is logged for security</span>
                    </li>
                </ul>
            </div>

            <!-- Security Reminder -->
            <div class="bg-gradient-to-br from-purple-50 to-pink-50 rounded-lg p-4 border border-purple-200">
                <h4 class="font-semibold text-purple-900 text-sm mb-2 flex items-center">
                    <i class="fas fa-shield-alt text-purple-600 mr-2"></i>
                    Security Reminder
                </h4>
                <ul class="text-xs text-purple-800 space-y-1">
                    <li class="flex items-start">
                        <i class="fas fa-arrow-right text-purple-600 mr-2 mt-0.5"></i>
                        <span>Inform the user about password change</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-arrow-right text-purple-600 mr-2 mt-0.5"></i>
                        <span>Advise them to change it after login</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-arrow-right text-purple-600 mr-2 mt-0.5"></i>
                        <span>Never share passwords via email/SMS</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/users/reset-password.blade.php ENDPATH**/ ?>