<?php $__env->startSection('title', 'Activity Log Details'); ?>
<?php $__env->startSection('subtitle', 'Detailed view of security log entry'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Activity Log Details</h1>
            <p class="text-gray-600">Log ID: #<?php echo e($log->id); ?></p>
        </div>
        <div class="flex gap-3">
            <a href="<?php echo e(route('security.logs.index')); ?>" class="inline-flex items-center px-4 py-2 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Logs
            </a>
        </div>
    </div>

    <!-- Log Details Card -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
        <!-- Header Section -->
        <div class="px-6 py-4 border-b border-gray-100 bg-gradient-to-r from-blue-100 to-blue-50">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 rounded-xl flex items-center justify-center
                        <?php echo e($log->severity === 'critical' ? 'bg-red-100 text-red-600' : 
                           ($log->severity === 'high' ? 'bg-orange-100 text-orange-600' : 
                           ($log->severity === 'medium' ? 'bg-yellow-100 text-yellow-600' : 'bg-blue-100 text-blue-600'))); ?>">
                        <?php if($log->severity === 'critical'): ?>
                            <i class="fas fa-exclamation-triangle text-lg"></i>
                        <?php elseif($log->severity === 'high'): ?>
                            <i class="fas fa-exclamation-circle text-lg"></i>
                        <?php elseif($log->severity === 'medium'): ?>
                            <i class="fas fa-info-circle text-lg"></i>
                        <?php else: ?>
                            <i class="fas fa-info text-lg"></i>
                        <?php endif; ?>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900"><?php echo e(ucfirst(str_replace('_', ' ', $log->action))); ?></h3>
                        <p class="text-sm text-gray-600"><?php echo e($log->created_at->format('M j, Y \a\t g:i A')); ?></p>
                    </div>
                </div>
                <div class="text-right">
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                        <?php echo e($log->severity === 'critical' ? 'bg-red-100 text-red-800' : 
                           ($log->severity === 'high' ? 'bg-orange-100 text-orange-800' : 
                           ($log->severity === 'medium' ? 'bg-yellow-100 text-yellow-800' : 'bg-blue-100 text-blue-800'))); ?>">
                        <?php echo e(ucfirst($log->severity)); ?> Priority
                    </span>
                </div>
            </div>
        </div>

        <!-- Content Section -->
        <div class="p-6">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Left Column - Basic Information -->
                <div class="space-y-6">
                    <!-- User Information -->
                    <div>
                        <h4 class="text-sm font-semibold text-gray-900 mb-3 flex items-center">
                            <i class="fas fa-user mr-2 text-blue-700"></i>
                            User Information
                        </h4>
                        <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                            <?php if($log->user): ?>
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-gradient-to-br from-blue-800 to-blue-400 rounded-full flex items-center justify-center">
                                        <i class="fas fa-user text-white text-sm"></i>
                                    </div>
                                    <div>
                                        <div class="font-medium text-gray-900"><?php echo e($log->user->name); ?></div>
                                        <div class="text-sm text-gray-600"><?php echo e($log->user->email); ?></div>
                                        <div class="text-xs text-gray-500">Role: <?php echo e(ucfirst($log->user->role ?? 'User')); ?></div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="flex items-center text-gray-500">
                                    <i class="fas fa-user-slash mr-2"></i>
                                    <span>System or Anonymous User</span>
                                </div>
                                <?php if($log->user_type): ?>
                                    <div class="text-sm text-gray-600">User Type: <?php echo e($log->user_type); ?></div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Action Details -->
                    <div>
                        <h4 class="text-sm font-semibold text-gray-900 mb-3 flex items-center">
                            <i class="fas fa-cog mr-2 text-blue-500"></i>
                            Action Details
                        </h4>
                        <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                            <div class="grid grid-cols-2 gap-4 text-sm">
                                <div>
                                    <span class="font-medium text-gray-700">Action:</span>
                                    <div class="mt-1 text-gray-900"><?php echo e(ucfirst(str_replace('_', ' ', $log->action))); ?></div>
                                </div>
                                <div>
                                    <span class="font-medium text-gray-700">Severity:</span>
                                    <div class="mt-1">
                                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium
                                            <?php echo e($log->severity === 'critical' ? 'bg-red-100 text-red-800' : 
                                               ($log->severity === 'high' ? 'bg-orange-100 text-orange-800' : 
                                               ($log->severity === 'medium' ? 'bg-yellow-100 text-yellow-800' : 'bg-blue-100 text-blue-800'))); ?>">
                                            <?php echo e(ucfirst($log->severity)); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if($log->model_type && $log->model_id): ?>
                                <div class="pt-3 border-t border-gray-200">
                                    <span class="font-medium text-gray-700">Affected Resource:</span>
                                    <div class="mt-1 text-gray-900">
                                        <?php echo e(class_basename($log->model_type)); ?> #<?php echo e($log->model_id); ?>

                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Session & Network -->
                    <div>
                        <h4 class="text-sm font-semibold text-gray-900 mb-3 flex items-center">
                            <i class="fas fa-network-wired mr-2 text-blue-600"></i>
                            Session & Network
                        </h4>
                        <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                            <?php if($log->ip_address): ?>
                                <div>
                                    <span class="font-medium text-gray-700">IP Address:</span>
                                    <div class="mt-1 text-gray-900 font-mono text-sm"><?php echo e($log->ip_address); ?></div>
                                </div>
                            <?php endif; ?>
                            
                            <?php if($log->session_id): ?>
                                <div>
                                    <span class="font-medium text-gray-700">Session ID:</span>
                                    <div class="mt-1 text-gray-900 font-mono text-xs break-all"><?php echo e($log->session_id); ?></div>
                                </div>
                            <?php endif; ?>
                            
                            <?php if($log->user_agent): ?>
                                <div>
                                    <span class="font-medium text-gray-700">User Agent:</span>
                                    <div class="mt-1 text-gray-600 text-sm break-words"><?php echo e($log->user_agent); ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Description and Properties -->
                <div class="space-y-6">
                    <!-- Description -->
                    <div>
                        <h4 class="text-sm font-semibold text-gray-900 mb-3 flex items-center">
                            <i class="fas fa-file-alt mr-2 text-blue-500"></i>
                            Description
                        </h4>
                        <div class="bg-gray-50 rounded-lg p-4">
                            <p class="text-gray-900 leading-relaxed"><?php echo e($log->description); ?></p>
                        </div>
                    </div>

                    <!-- Properties -->
                    <?php if($log->properties && count($log->properties) > 0): ?>
                        <div>
                            <h4 class="text-sm font-semibold text-gray-900 mb-3 flex items-center">
                                <i class="fas fa-code mr-2 text-blue-700"></i>
                                Additional Properties
                            </h4>
                            <div class="bg-gray-900 rounded-lg p-4 overflow-x-auto">
                                <pre class="text-green-400 text-sm font-mono"><?php echo e(json_encode($log->properties, JSON_PRETTY_PRINT)); ?></pre>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Timeline -->
                    <div>
                        <h4 class="text-sm font-semibold text-gray-900 mb-3 flex items-center">
                            <i class="fas fa-clock mr-2 text-blue-500"></i>
                            Timeline
                        </h4>
                        <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                            <div class="flex items-center justify-between text-sm">
                                <span class="font-medium text-gray-700">Created:</span>
                                <span class="text-gray-900"><?php echo e($log->created_at->format('M j, Y \a\t g:i:s A')); ?></span>
                            </div>
                            <div class="flex items-center justify-between text-sm">
                                <span class="font-medium text-gray-700">Time Ago:</span>
                                <span class="text-gray-600"><?php echo e($log->created_at->diffForHumans()); ?></span>
                            </div>
                            <div class="flex items-center justify-between text-sm">
                                <span class="font-medium text-gray-700">Day of Week:</span>
                                <span class="text-gray-600"><?php echo e($log->created_at->format('l')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Actions Footer -->
        <div class="px-6 py-4 bg-gray-50 border-t border-gray-100">
            <div class="flex items-center justify-between">
                <div class="text-sm text-gray-500">
                    Log Entry #<?php echo e($log->id); ?> • Created <?php echo e($log->created_at->diffForHumans()); ?>

                </div>
                <div class="flex space-x-3">
                    <?php if($log->severity === 'critical' || $log->severity === 'high'): ?>
                        <button class="inline-flex items-center px-3 py-1.5 bg-red-100 text-red-700 text-sm font-medium rounded-lg hover:bg-red-200 transition-colors">
                            <i class="fas fa-flag mr-1"></i>
                            Flag for Review
                        </button>
                    <?php endif; ?>
                    
                    <button onclick="window.print()" class="inline-flex items-center px-3 py-1.5 bg-blue-100 text-blue-700 text-sm font-medium rounded-lg hover:bg-blue-200 transition-colors">
                        <i class="fas fa-print mr-1"></i>
                        Print
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Related Logs -->
    <?php if($log->user_id): ?>
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                <i class="fas fa-history mr-2 text-gray-600"></i>
                Recent Activity from Same User
            </h3>
            
            <?php
                $recentLogs = \App\Models\ActivityLog::where('user_id', $log->user_id)
                    ->where('id', '!=', $log->id)
                    ->orderBy('created_at', 'desc')
                    ->limit(5)
                    ->get();
            ?>
            
            <?php if($recentLogs->count() > 0): ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $recentLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recentLog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                            <div class="flex items-center space-x-3">
                                <div class="w-8 h-8 rounded-lg flex items-center justify-center text-xs
                                    <?php echo e($recentLog->severity === 'critical' ? 'bg-red-100 text-red-600' : 
                                       ($recentLog->severity === 'high' ? 'bg-orange-100 text-orange-600' : 
                                       ($recentLog->severity === 'medium' ? 'bg-yellow-100 text-yellow-600' : 'bg-blue-100 text-blue-600'))); ?>">
                                    <i class="fas fa-circle"></i>
                                </div>
                                <div>
                                    <div class="font-medium text-gray-900 text-sm"><?php echo e(ucfirst(str_replace('_', ' ', $recentLog->action))); ?></div>
                                    <div class="text-xs text-gray-500"><?php echo e($recentLog->created_at->diffForHumans()); ?></div>
                                </div>
                            </div>
                            <a href="<?php echo e(route('security.logs.show', $recentLog)); ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                View Details
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-8 text-gray-500">
                    <i class="fas fa-history text-2xl mb-2"></i>
                    <p>No other recent activity from this user</p>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<style>
@media print {
    .no-print {
        display: none !important;
    }
    
    body {
        background: white !important;
    }
    
    .bg-gradient-to-r {
        background: #f8fafc !important;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/logs/show.blade.php ENDPATH**/ ?>