<?php $__env->startSection('title', 'Church Dashboard'); ?>

<?php
    $dynamicSubtitle = 'Welcome to ' . ($organizationSettings['name'] ?? 'Presbyterian Church of Ghana') . ' Management System';
?>

<?php $__env->startSection('subtitle', $dynamicSubtitle); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    <!-- Welcome Banner -->
    <div class="relative overflow-hidden bg-gradient-to-r from-blue-600 to-red-600 rounded-3xl shadow-2xl">
        <div class="absolute inset-0 bg-black opacity-10"></div>
        <div class="absolute inset-0">
            <div class="absolute top-10 right-10 w-32 h-32 bg-white opacity-5 rounded-full"></div>
            <div class="absolute bottom-10 left-10 w-20 h-20 bg-white opacity-10 rounded-full"></div>
            <div class="absolute top-1/2 right-1/4 w-16 h-16 bg-white opacity-5 rounded-full"></div>
        </div>
        <div class="relative px-8 py-12">
            <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center">
                <div class="text-white">
                    <div class="flex items-center mb-4">
                        <?php if($organizationSettings['logo']): ?>
                            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-xl flex items-center justify-center mr-4 overflow-hidden">
                                <img src="<?php echo e(asset('storage/' . $organizationSettings['logo'])); ?>" alt="Organization Logo" class="w-full h-full object-contain">
                            </div>
                        <?php else: ?>
                            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-xl flex items-center justify-center mr-4">
                                <i class="fas fa-church text-2xl"></i>
                            </div>
                        <?php endif; ?>
                        <div>
                            <h1 class="text-4xl font-bold">Welcome to <?php echo e($organizationSettings['name']); ?></h1>
                            <p class="text-lg opacity-90"><?php echo e($organizationSettings['slogan']); ?></p>
                        </div>
                    </div>
                    <p class="text-xl opacity-90 mb-8 max-w-2xl">Empowering our congregation through digital ministry management and community connection</p>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div class="glass-effect bg-gradient-to-br from-blue-500/50 to-cyan-600/50 border border-blue-300/50 rounded-xl px-4 py-3 text-center hover:from-blue-500/70 hover:to-cyan-600/70 transition-all duration-300">
                            <div class="text-2xl font-bold text-white"><?php echo e($churchStats['total_members'] ?? 0); ?></div>
                            <div class="text-sm opacity-90">Members</div>
                        </div>
                        <div class="glass-effect bg-gradient-to-br from-green-500/50 to-emerald-600/50 border border-green-300/50 rounded-xl px-4 py-3 text-center hover:from-green-500/70 hover:to-emerald-600/70 transition-all duration-300">
                            <div class="text-2xl font-bold text-white"><?php echo e($churchStats['total_families'] ?? 0); ?></div>
                            <div class="text-sm opacity-90">Families</div>
                        </div>
                        <div class="glass-effect bg-gradient-to-br from-purple-500/50 to-pink-600/50 border border-purple-300/50 rounded-xl px-4 py-3 text-center hover:from-purple-500/70 hover:to-pink-600/70 transition-all duration-300">
                            <div class="text-2xl font-bold text-white"><?php echo e($churchStats['total_events'] ?? 0); ?></div>
                            <div class="text-sm opacity-90">Total Events</div>
                        </div>
                        <div class="glass-effect bg-gradient-to-br from-yellow-500/50 to-orange-600/50 border border-yellow-300/50 rounded-xl px-4 py-3 text-center hover:from-yellow-500/70 hover:to-orange-600/70 transition-all duration-300 relative group">
                            <div class="text-2xl font-bold text-white" id="sms-balance"><?php echo e(number_format($churchStats['sms_credits'] ?? 0, 2)); ?></div>
                            <div class="text-sm opacity-90">SMS Credits</div>
                            <?php if(($churchStats['sms_credits'] ?? 0) == 0): ?>
                                <div class="text-xs opacity-75 mt-1">
                                    <i class="fas fa-exclamation-triangle mr-1"></i>Check API Config
                                </div>
                            <?php endif; ?>
                            <button onclick="refreshSmsBalance()" class="absolute top-2 right-2 w-6 h-6 bg-white/20 rounded-full flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-200 hover:bg-white/30" title="Refresh SMS Balance">
                                <i class="fas fa-sync-alt text-white text-xs" id="refresh-icon"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="hidden lg:block mt-8 lg:mt-0 animate-fade-in-up">
                    <div class="relative w-40 h-40 glass-effect rounded-full flex items-center justify-center animate-float group hover:scale-110 transition-transform duration-500">
                        <!-- Glow effect -->
                        <div class="absolute inset-0 rounded-full bg-gradient-to-r from-blue-400 via-purple-400 to-pink-400 opacity-30 blur-xl animate-pulse"></div>
                        
                        <!-- Inner glow ring -->
                        <div class="absolute inset-2 rounded-full border-2 border-white/20 animate-spin-slow"></div>
                        
                        <!-- Icon -->
                        <i class="fas fa-hands-praying text-6xl text-white opacity-90 relative z-10 animate-pulse-subtle group-hover:scale-110 transition-all duration-300"></i>
                    </div>
                </div>
                
                <style>
                    @keyframes float {
                        0%, 100% { transform: translateY(0px); }
                        50% { transform: translateY(-10px); }
                    }
                    
                    @keyframes fadeInUp {
                        from {
                            opacity: 0;
                            transform: translateY(20px);
                        }
                        to {
                            opacity: 1;
                            transform: translateY(0);
                        }
                    }
                    
                    @keyframes spinSlow {
                        from { transform: rotate(0deg); }
                        to { transform: rotate(360deg); }
                    }
                    
                    @keyframes pulseSubtle {
                        0%, 100% { opacity: 0.9; }
                        50% { opacity: 0.7; }
                    }
                    
                    .animate-float {
                        animation: float 3s ease-in-out infinite;
                    }
                    
                    .animate-fade-in-up {
                        animation: fadeInUp 1s ease-out;
                    }
                    
                    .animate-spin-slow {
                        animation: spinSlow 20s linear infinite;
                    }
                    
                    .animate-pulse-subtle {
                        animation: pulseSubtle 2s ease-in-out infinite;
                    }
                </style>
            </div>
        </div>
    </div>

    <!-- Church Statistics Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Active Members -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Active Members</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e($churchStats['active_members'] ?? 9); ?></p>
                    <div class="flex items-center mt-2 space-x-3">
                        <span class="text-xs text-blue-600 font-medium"><?php echo e($churchStats['active_members'] ?? 9); ?> active</span>
                        <span class="text-xs text-gray-500"><?php echo e(($churchStats['total_members'] ?? 9) - ($churchStats['active_members'] ?? 9)); ?> inactive</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-users text-white text-lg"></i>
                </div>
            </div>
        </div>

        <!-- Total Families -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Church Families</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e($churchStats['total_families'] ?? 0); ?></p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs text-green-600 font-medium">Growing community</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-emerald-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-home text-white text-lg"></i>
                </div>
            </div>
        </div>

        <!-- Active Ministries -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Active Ministries</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e($churchStats['total_ministries'] ?? 0); ?></p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs text-purple-600 font-medium">Serving together</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-hands-praying text-white text-lg"></i>
                </div>
            </div>
        </div>

        <!-- This Year's Donations -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Donations <?php echo e(date('Y')); ?></p>
                    <p class="text-3xl font-bold text-gray-900">GHS <?php echo e(number_format($churchStats['total_donations_this_year'] ?? 0)); ?></p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs text-yellow-600 font-medium">Faithful giving</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-yellow-500 to-orange-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-hand-holding-heart text-white text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Member Statistics -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- New Members This Month -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">New Members</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e($memberStats['new_members_this_month'] ?? 0); ?></p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs text-blue-600 font-medium">This month</span>
                        <span class="text-xs text-gray-400 mx-2">•</span>
                        <span class="text-xs text-gray-500"><?php echo e($memberStats['new_members_this_year'] ?? 0); ?> this year</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-user-plus text-white text-lg"></i>
                </div>
            </div>
        </div>

        <!-- Baptized Members -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Baptized Members</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e($memberStats['baptized_members'] ?? 0); ?></p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs text-blue-600 font-medium"><?php echo e(round((($memberStats['baptized_members'] ?? 0) / max($churchStats['total_members'], 1)) * 100)); ?>% of total</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-indigo-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-water text-white text-lg"></i>
                </div>
            </div>
        </div>

        <!-- Ministry Engagement -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Ministry Members</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e($ministryStats['total_ministry_members'] ?? 0); ?></p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs text-purple-600 font-medium"><?php echo e(round((($ministryStats['total_ministry_members'] ?? 0) / max($churchStats['total_members'], 1)) * 100)); ?>% engaged</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-hands-helping text-white text-lg"></i>
                </div>
            </div>
        </div>

        <!-- Communication Reach -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">Reachable Members</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e($memberStats['members_with_email'] + $memberStats['members_with_phone'] ?? 0); ?></p>
                    <div class="flex items-center mt-2 space-x-3">
                        <span class="text-xs text-green-600 font-medium"><?php echo e($memberStats['members_with_email'] ?? 0); ?> email</span>
                        <span class="text-xs text-blue-600 font-medium"><?php echo e($memberStats['members_with_phone'] ?? 0); ?> phone</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-emerald-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-broadcast-tower text-white text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Birthday and Payment Statistics -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Birthday Statistics -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">No. of Birthdays This Month</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e($churchStats['birthdays_this_month'] ?? 2); ?></p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs text-pink-600 font-medium"><?php echo e($churchStats['birthdays_this_week'] ?? 0); ?> this week</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-pink-500 to-rose-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-birthday-cake text-white text-lg"></i>
                </div>
            </div>
        </div>

        <!-- Payment Statistics -->
        <div class="card-hover bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-1">No. of Payments</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e($churchStats['total_payments'] ?? 0); ?></p>
                    <div class="flex items-center mt-2">
                        <span class="text-xs text-indigo-600 font-medium"><?php echo e($churchStats['payments_this_month'] ?? 0); ?> this month</span>
                    </div>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-indigo-500 to-blue-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-credit-card text-white text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Recent Church Activities -->
        <div class="lg:col-span-2 bg-white rounded-2xl shadow-lg border border-gray-100">
            <div class="px-6 py-5 border-b border-gray-100">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-clock text-white text-sm"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900">Recent Church Activities</h3>
                    </div>
                    <span class="text-sm text-gray-500">Latest updates</span>
                </div>
            </div>
            <div class="p-6">
                <div class="space-y-4 max-h-80 overflow-y-auto">
                    <?php if(isset($recentMembers) && $recentMembers->count() > 0): ?>
                        <?php $__currentLoopData = $recentMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-start space-x-4 p-4 rounded-xl hover:bg-blue-50 transition-colors border border-transparent hover:border-blue-200">
                                <div class="flex-shrink-0">
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-blue-500 to-cyan-600 flex items-center justify-center">
                                        <i class="fas fa-user-plus text-white"></i>
                                    </div>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm font-medium text-gray-900">New member joined</p>
                                    <p class="text-sm text-gray-600"><?php echo e($member->full_name); ?> from <?php echo e($member->family->family_name ?? 'Unknown'); ?> family</p>
                                    <div class="flex items-center mt-1 space-x-2">
                                        <span class="text-xs text-blue-600 font-medium">Member ID: <?php echo e($member->member_id); ?></span>
                                        <span class="text-xs text-gray-400">•</span>
                                        <span class="text-xs text-gray-500"><?php echo e($member->created_at->diffForHumans()); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    
                    <?php if(isset($recentDonations) && $recentDonations->count() > 0): ?>
                        <?php $__currentLoopData = $recentDonations->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $donation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-start space-x-4 p-4 rounded-xl hover:bg-green-50 transition-colors border border-transparent hover:border-green-200">
                                <div class="flex-shrink-0">
                                    <div class="w-12 h-12 rounded-full bg-gradient-to-br from-green-500 to-emerald-600 flex items-center justify-center">
                                        <i class="fas fa-hand-holding-heart text-white"></i>
                                    </div>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm font-medium text-gray-900">New donation received</p>
                                    <p class="text-sm text-gray-600">GHS <?php echo e(number_format($donation->amount, 2)); ?> - <?php echo e(ucfirst($donation->type)); ?></p>
                                    <div class="flex items-center mt-1 space-x-2">
                                        <span class="text-xs text-green-600 font-medium"><?php echo e($donation->member->full_name ?? 'Anonymous'); ?></span>
                                        <span class="text-xs text-gray-400">•</span>
                                        <span class="text-xs text-gray-500"><?php echo e($donation->created_at->diffForHumans()); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    
                    <?php if((!isset($recentMembers) || $recentMembers->count() == 0) && (!isset($recentDonations) || $recentDonations->count() == 0)): ?>
                        <div class="text-center py-12">
                            <div class="w-16 h-16 bg-gradient-to-br from-gray-100 to-gray-200 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-church text-2xl text-gray-400"></i>
                            </div>
                            <p class="text-gray-500 font-medium">No recent church activities</p>
                            <p class="text-sm text-gray-400 mt-1">Activities will appear here as they happen</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Church Quick Actions & Upcoming Events -->
        <div class="space-y-6">
            <!-- Quick Church Actions -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100">
                <div class="px-6 py-5 border-b border-gray-100">
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-emerald-600 rounded-lg flex items-center justify-center">
                            <i class="fas fa-plus text-white text-sm"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900">Quick Actions</h3>
                    </div>
                </div>
                <div class="p-6 space-y-3">
                    <a href="<?php echo e(route('members.create')); ?>" class="flex items-center p-4 rounded-xl hover:bg-blue-50 transition-all duration-200 group border border-transparent hover:border-blue-200">
                        <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                            <i class="fas fa-user-plus text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-900">Add New Member</p>
                            <p class="text-xs text-gray-500">Register new church member</p>
                        </div>
                    </a>
                    <a href="<?php echo e(route('events.create')); ?>" class="flex items-center p-4 rounded-xl hover:bg-orange-50 transition-all duration-200 group border border-transparent hover:border-orange-200">
                        <div class="w-10 h-10 bg-gradient-to-br from-orange-500 to-red-600 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                            <i class="fas fa-calendar-plus text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-900">Create Event</p>
                            <p class="text-xs text-gray-500">Schedule church activities</p>
                        </div>
                    </a>
                    <a href="<?php echo e(route('donations.create')); ?>" class="flex items-center p-4 rounded-xl hover:bg-green-50 transition-all duration-200 group border border-transparent hover:border-green-200">
                        <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-emerald-600 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                            <i class="fas fa-hand-holding-heart text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-900">Record Donation</p>
                            <p class="text-xs text-gray-500">Track tithes and offerings</p>
                        </div>
                    </a>
                    <a href="<?php echo e(route('announcements.create')); ?>" class="flex items-center p-4 rounded-xl hover:bg-purple-50 transition-all duration-200 group border border-transparent hover:border-purple-200">
                        <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-600 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                            <i class="fas fa-bullhorn text-white"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-900">New Announcement</p>
                            <p class="text-xs text-gray-500">Share church updates</p>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Upcoming Events -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100">
                <div class="px-6 py-5 border-b border-gray-100">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-gradient-to-br from-orange-500 to-red-600 rounded-lg flex items-center justify-center">
                                <i class="fas fa-calendar-alt text-white text-sm"></i>
                            </div>
                            <h3 class="text-lg font-semibold text-gray-900">Upcoming Events</h3>
                        </div>
                        <a href="<?php echo e(route('events.index')); ?>" class="text-sm text-orange-600 hover:text-orange-700 font-medium">View all</a>
                    </div>
                </div>
                <div class="p-6">
                    <?php if(isset($upcomingEvents) && $upcomingEvents->count() > 0): ?>
                        <div class="space-y-4">
                            <?php $__currentLoopData = $upcomingEvents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-start space-x-4 p-4 rounded-xl hover:bg-orange-50 transition-colors border border-transparent hover:border-orange-200">
                                    <div class="flex-shrink-0">
                                        <div class="w-12 h-12 bg-gradient-to-br from-orange-500 to-red-600 rounded-xl flex items-center justify-center">
                                            <i class="fas fa-calendar text-white"></i>
                                        </div>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-medium text-gray-900 truncate"><?php echo e($event->title); ?></p>
                                        <p class="text-xs text-gray-600 mt-1"><?php echo e($event->ministry->name ?? 'General'); ?></p>
                                        <div class="flex items-center mt-2 space-x-2">
                                            <span class="text-xs text-orange-600 font-medium"><?php echo e($event->start_datetime->format('M j, Y')); ?></span>
                                            <span class="text-xs text-gray-400">•</span>
                                            <span class="text-xs text-gray-500"><?php echo e($event->start_datetime->format('g:i A')); ?></span>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-8">
                            <div class="w-16 h-16 bg-gradient-to-br from-orange-100 to-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-calendar-alt text-2xl text-orange-400"></i>
                            </div>
                            <p class="text-gray-500 font-medium">No upcoming events</p>
                            <p class="text-sm text-gray-400 mt-1">Schedule your next church event</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Church Analytics Dashboard -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Membership Growth Chart -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-xl flex items-center justify-center">
                        <i class="fas fa-chart-line text-white"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Membership Growth</h3>
                        <p class="text-sm text-gray-500"><?php echo e(date('Y')); ?> Overview</p>
                    </div>
                </div>
                <div class="flex items-center space-x-2">
                    <button onclick="toggleMembershipChart('monthly')" id="monthly-btn" class="px-3 py-1 text-xs font-medium bg-blue-100 text-blue-700 rounded-full">Monthly</button>
                    <button onclick="toggleMembershipChart('cumulative')" id="cumulative-btn" class="px-3 py-1 text-xs font-medium bg-gray-100 text-gray-600 rounded-full">Cumulative</button>
                </div>
            </div>
            <div class="h-64">
                <canvas id="membershipChart"></canvas>
            </div>
        </div>

        <!-- Donation Trends -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-emerald-600 rounded-xl flex items-center justify-center">
                        <i class="fas fa-chart-bar text-white"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Donation Trends</h3>
                        <p class="text-sm text-gray-500"><?php echo e(date('Y')); ?> Monthly Overview</p>
                    </div>
                </div>
                <div class="text-right">
                    <div class="text-sm font-medium text-gray-900">GHS <?php echo e(number_format(array_sum($monthlyDonations))); ?></div>
                    <div class="text-xs text-gray-500">Total <?php echo e(date('Y')); ?></div>
                </div>
            </div>
            <div class="h-64">
                <canvas id="donationChart"></canvas>
            </div>
        </div>
    </div>

    <!-- PCG Year Group Demographics -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
        <div class="flex items-center justify-between mb-6">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-600 rounded-xl flex items-center justify-center">
                    <i class="fas fa-users text-white"></i>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-gray-900">PCG Year Groups</h3>
                    <p class="text-sm text-gray-500">Presbyterian Church of Ghana age classifications</p>
                </div>
            </div>
            <?php if($memberStats['unassigned_year_group'] > 0): ?>
                <div class="flex items-center text-amber-600 bg-amber-50 px-3 py-1 rounded-full">
                    <i class="fas fa-exclamation-triangle mr-2 text-sm"></i>
                    <span class="text-sm font-medium"><?php echo e($memberStats['unassigned_year_group']); ?> unassigned</span>
                </div>
            <?php endif; ?>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <?php $__currentLoopData = $yearGroupStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $yearGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="text-center p-6 rounded-xl border-2 hover:shadow-lg transition-all duration-200" 
                     style="background: linear-gradient(135deg, <?php echo e($yearGroup->color); ?>15, <?php echo e($yearGroup->color); ?>25); border-color: <?php echo e($yearGroup->color); ?>40;">
                    <div class="w-12 h-12 rounded-full flex items-center justify-center mx-auto mb-3" 
                         style="background: linear-gradient(135deg, <?php echo e($yearGroup->color); ?>, <?php echo e($yearGroup->color); ?>dd);">
                        <?php if($yearGroup->name == "Children's Service"): ?>
                            <i class="fas fa-child text-white"></i>
                        <?php elseif($yearGroup->name == "Junior Youth"): ?>
                            <i class="fas fa-running text-white"></i>
                        <?php elseif($yearGroup->name == "Young People's Guild"): ?>
                            <i class="fas fa-users text-white"></i>
                        <?php elseif($yearGroup->name == "Young Adults' Fellowship"): ?>
                            <i class="fas fa-user-friends text-white"></i>
                        <?php else: ?>
                            <i class="fas fa-user-tie text-white"></i>
                        <?php endif; ?>
                    </div>
                    <div class="text-2xl font-bold mb-1" style="color: <?php echo e($yearGroup->color); ?>;">
                        <?php echo e($yearGroup->members_count); ?>

                    </div>
                    <div class="text-sm font-medium mb-1" style="color: <?php echo e($yearGroup->color); ?>;">
                        <?php echo e($yearGroup->abbreviation); ?>

                    </div>
                    <div class="text-xs text-gray-600 mb-2"><?php echo e($yearGroup->name); ?></div>
                    <div class="text-xs text-gray-500">
                        <?php echo e($yearGroup->min_age); ?>-<?php echo e($yearGroup->max_age == 999 ? '∞' : $yearGroup->max_age); ?> years
                    </div>
                    <?php if($yearGroup->active_members_count != $yearGroup->members_count): ?>
                        <div class="text-xs text-gray-500 mt-1">
                            <?php echo e($yearGroup->active_members_count); ?> active
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <?php if($yearGroupStats->isEmpty()): ?>
            <div class="text-center py-12">
                <div class="w-16 h-16 bg-gradient-to-br from-gray-100 to-gray-200 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-users text-2xl text-gray-400"></i>
                </div>
                <p class="text-gray-500 font-medium">No year groups configured</p>
                <p class="text-sm text-gray-400 mt-1">Set up PCG year groups to see member distribution</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
async function refreshSmsBalance() {
    const button = event.target.closest('button');
    const icon = document.getElementById('refresh-icon');
    const balanceElement = document.getElementById('sms-balance');
    
    // Show loading state
    icon.classList.add('fa-spin');
    button.disabled = true;
    
    try {
        const response = await fetch('/api/sms-balance', {
            method: 'GET',
            headers: {
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        });
        
        const data = await response.json();
        
        if (data.success) {
            balanceElement.textContent = parseFloat(data.balance).toLocaleString('en-US', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });
            
            // Show success feedback
            button.classList.add('bg-green-500/30');
            setTimeout(() => {
                button.classList.remove('bg-green-500/30');
            }, 1000);
            
            // Hide error message if balance is now > 0
            const errorMsg = button.closest('.glass-effect').querySelector('.text-xs');
            if (data.balance > 0 && errorMsg) {
                errorMsg.style.display = 'none';
            }
        } else {
            // Show error feedback
            button.classList.add('bg-red-500/30');
            setTimeout(() => {
                button.classList.remove('bg-red-500/30');
            }, 1000);
            
            console.error('Failed to refresh SMS balance:', data.error);
            
            // Show error message in console for debugging
            if (data.error) {
                console.log('MNotify API Error Details:', data.error);
            }
        }
    } catch (error) {
        console.error('Error refreshing SMS balance:', error);
        
        // Show error feedback
        button.classList.add('bg-red-500/30');
        setTimeout(() => {
            button.classList.remove('bg-red-500/30');
        }, 1000);
    } finally {
        // Remove loading state
        icon.classList.remove('fa-spin');
        button.disabled = false;
    }
}

// Chart Data
const membershipData = {
    monthly: <?php echo json_encode(array_values($membershipGrowth), 15, 512) ?>,
    cumulative: <?php echo json_encode(array_values($cumulativeMembership), 15, 512) ?>
};

const donationData = <?php echo json_encode(array_values($monthlyDonations), 15, 512) ?>;
const monthLabels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

// Chart configurations
let membershipChart;
let donationChart;

// Initialize charts when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    initializeMembershipChart();
    initializeDonationChart();
});

function initializeMembershipChart() {
    const ctx = document.getElementById('membershipChart').getContext('2d');
    
    membershipChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: monthLabels,
            datasets: [{
                label: 'New Members',
                data: membershipData.monthly,
                borderColor: 'rgb(59, 130, 246)',
                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4,
                pointBackgroundColor: 'rgb(59, 130, 246)',
                pointBorderColor: '#fff',
                pointBorderWidth: 2,
                pointRadius: 5,
                pointHoverRadius: 7
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: 'rgb(59, 130, 246)',
                    borderWidth: 1,
                    cornerRadius: 8,
                    displayColors: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    },
                    ticks: {
                        color: '#6B7280',
                        font: {
                            size: 12
                        }
                    }
                },
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        color: '#6B7280',
                        font: {
                            size: 12
                        }
                    }
                }
            },
            interaction: {
                intersect: false,
                mode: 'index'
            }
        }
    });
}

function initializeDonationChart() {
    const ctx = document.getElementById('donationChart').getContext('2d');
    
    donationChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: monthLabels,
            datasets: [{
                label: 'Donations (GHS)',
                data: donationData,
                backgroundColor: 'rgba(34, 197, 94, 0.8)',
                borderColor: 'rgb(34, 197, 94)',
                borderWidth: 1,
                borderRadius: 6,
                borderSkipped: false
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: 'rgb(34, 197, 94)',
                    borderWidth: 1,
                    cornerRadius: 8,
                    displayColors: false,
                    callbacks: {
                        label: function(context) {
                            return 'GHS ' + context.parsed.y.toLocaleString();
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    },
                    ticks: {
                        color: '#6B7280',
                        font: {
                            size: 12
                        },
                        callback: function(value) {
                            return 'GHS ' + value.toLocaleString();
                        }
                    }
                },
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        color: '#6B7280',
                        font: {
                            size: 12
                        }
                    }
                }
            }
        }
    });
}

function toggleMembershipChart(type) {
    const monthlyBtn = document.getElementById('monthly-btn');
    const cumulativeBtn = document.getElementById('cumulative-btn');
    
    if (type === 'monthly') {
        monthlyBtn.className = 'px-3 py-1 text-xs font-medium bg-blue-100 text-blue-700 rounded-full';
        cumulativeBtn.className = 'px-3 py-1 text-xs font-medium bg-gray-100 text-gray-600 rounded-full';
        
        membershipChart.data.datasets[0].label = 'New Members';
        membershipChart.data.datasets[0].data = membershipData.monthly;
        membershipChart.data.datasets[0].backgroundColor = 'rgba(59, 130, 246, 0.1)';
        membershipChart.data.datasets[0].borderColor = 'rgb(59, 130, 246)';
        membershipChart.data.datasets[0].pointBackgroundColor = 'rgb(59, 130, 246)';
    } else {
        monthlyBtn.className = 'px-3 py-1 text-xs font-medium bg-gray-100 text-gray-600 rounded-full';
        cumulativeBtn.className = 'px-3 py-1 text-xs font-medium bg-purple-100 text-purple-700 rounded-full';
        
        membershipChart.data.datasets[0].label = 'Total Members';
        membershipChart.data.datasets[0].data = membershipData.cumulative;
        membershipChart.data.datasets[0].backgroundColor = 'rgba(147, 51, 234, 0.1)';
        membershipChart.data.datasets[0].borderColor = 'rgb(147, 51, 234)';
        membershipChart.data.datasets[0].pointBackgroundColor = 'rgb(147, 51, 234)';
    }
    
    membershipChart.update('active');
}
</script>
<?php $__env->stopSection(); ?>



 
<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/dashboard.blade.php ENDPATH**/ ?>