<?php $__env->startSection('title', 'Add New Member'); ?>
<?php $__env->startSection('subtitle', 'Register a new church member'); ?>

<?php $__env->startSection('content'); ?>

<!-- Success/Error Messages -->
<?php if(session('success')): ?>
    <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-check-circle text-green-400"></i>
            </div>
            <div class="ml-3">
                <p class="text-sm font-medium text-green-800"><?php echo e(session('success')); ?></p>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="mb-6 bg-red-50 border border-red-200 rounded-lg p-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-exclamation-circle text-red-400"></i>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-red-800">Please correct the following errors:</h3>
                <div class="mt-2 text-sm text-red-700">
                    <ul class="list-disc pl-5 space-y-1">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 py-8">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-8">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div class="space-y-2">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-gradient-to-r from-blue-600 to-indigo-600 rounded-xl flex items-center justify-center shadow-lg">
                            <i class="fas fa-user-plus text-white"></i>
                        </div>
                        <h1 class="text-3xl font-bold bg-gradient-to-r from-gray-900 to-gray-700 bg-clip-text text-transparent">Add New Member</h1>
                     </div>
                    <p class="text-gray-600 text-lg">Complete the form below to register a new church member</p>
                </div>
                <a href="<?php echo e(route('members.index')); ?>" class="inline-flex items-center px-6 py-3 bg-white/80 backdrop-blur-sm text-gray-700 font-semibold rounded-2xl hover:bg-white hover:shadow-lg transition-all duration-300 border border-gray-200/50">
                    <i class="fas fa-arrow-left mr-2 text-gray-500"></i>
                    Back to Members
                </a>
            </div>
        </div>

    <form action="<?php echo e(route('members.store')); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
        <?php echo csrf_field(); ?>
        
        <!-- Personal Information -->
        <div class="group bg-white/70 backdrop-blur-xl rounded-3xl shadow-xl border border-white/20 p-8 hover:shadow-2xl transition-all duration-500 hover:bg-white/80">
            <div class="flex items-center mb-8">
                <div class="relative">
                    <div class="w-12 h-12 bg-gradient-to-r from-blue-500 via-blue-600 to-indigo-600 rounded-2xl flex items-center justify-center shadow-lg group-hover:shadow-xl transition-all duration-300">
                        <i class="fas fa-user text-white text-lg"></i>
                    </div>
                    <div class="absolute -top-1 -right-1 w-4 h-4 bg-gradient-to-r from-emerald-400 to-emerald-500 rounded-full animate-pulse"></div>
                </div>
                <div class="ml-4">
                    <h2 class="text-xl font-bold bg-gradient-to-r from-gray-900 to-gray-700 bg-clip-text text-transparent">Personal Information</h2>
                    <p class="text-gray-500 text-sm mt-1">Basic member details and identification</p>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Photo Upload -->
                <div class="md:col-span-1">
                    <label class="block text-sm font-semibold text-gray-800 mb-4">Profile Photo</label>
                    <div class="flex flex-col items-center">
                        <div class="relative group">
                            <div class="w-36 h-36 bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50 rounded-3xl flex items-center justify-center mb-6 overflow-hidden border-4 border-white shadow-xl group-hover:shadow-2xl transition-all duration-300">
                                <img id="photo-preview" src="" alt="Preview" class="w-full h-full object-cover hidden rounded-2xl">
                                <div id="photo-icon" class="flex flex-col items-center space-y-2">
                                    <div class="w-12 h-12 bg-gradient-to-r from-blue-500 to-indigo-500 rounded-2xl flex items-center justify-center">
                                        <i class="fas fa-camera text-white text-xl"></i>
                                    </div>
                                    <span class="text-xs text-gray-500 font-medium">Add Photo</span>
                                </div>
                            </div>
                            <div class="absolute -bottom-2 -right-2 w-8 h-8 bg-gradient-to-r from-emerald-400 to-emerald-500 rounded-full flex items-center justify-center shadow-lg cursor-pointer hover:scale-110 transition-transform duration-200" onclick="document.getElementById('photo').click()">
                                <i class="fas fa-plus text-white text-sm"></i>
                            </div>
                        </div>
                        <input type="file" name="photo" id="photo" accept="image/*" class="hidden">
                        <button type="button" onclick="document.getElementById('photo').click()" class="px-6 py-3 bg-gradient-to-r from-blue-500 to-indigo-500 text-white font-semibold rounded-2xl hover:from-blue-600 hover:to-indigo-600 transition-all duration-300 shadow-lg hover:shadow-xl text-sm">
                            <i class="fas fa-upload mr-2"></i>Choose Photo
                        </button>
                    </div>
                </div>

                <!-- Name Fields -->
                <div class="md:col-span-2 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <label for="title" class="block text-sm font-semibold text-gray-800">Title</label>
                        <div class="relative">
                            <select name="title" id="title" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                                <option value="">Select Title</option>
                                <option value="Mr.">Mr.</option>
                                <option value="Mrs.">Mrs.</option>
                                <option value="Ms.">Ms.</option>
                                <option value="Dr.">Dr.</option>
                                <option value="Rev.">Rev.</option>
                                <option value="Pastor">Pastor</option>
                                <option value="Prof.">Prof.</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-chevron-down text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="first_name" class="block text-sm font-semibold text-gray-800">
                            First Name 
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800 ml-1">Required</span>
                        </label>
                        <div class="relative">
                            <input type="text" name="first_name" id="first_name" required class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md placeholder-gray-400" value="<?php echo e(old('first_name')); ?>" placeholder="Enter first name">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3">
                                <i class="fas fa-user text-gray-400"></i>
                            </div>
                        </div>
                        <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i>
                                <?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="space-y-2">
                        <label for="middle_name" class="block text-sm font-semibold text-gray-800">Middle Name</label>
                        <div class="relative">
                            <input type="text" name="middle_name" id="middle_name" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md placeholder-gray-400" value="<?php echo e(old('middle_name')); ?>" placeholder="Enter middle name">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3">
                                <i class="fas fa-user text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="last_name" class="block text-sm font-semibold text-gray-800">
                            Last Name 
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800 ml-1">Required</span>
                        </label>
                        <div class="relative">
                            <input type="text" name="last_name" id="last_name" required class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md placeholder-gray-400" value="<?php echo e(old('last_name')); ?>" placeholder="Enter last name">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3">
                                <i class="fas fa-user text-gray-400"></i>
                            </div>
                        </div>
                        <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i>
                                <?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="space-y-2">
                        <label for="date_of_birth" class="block text-sm font-semibold text-gray-800">Date of Birth</label>
                        <div class="relative">
                            <input type="date" name="date_of_birth" id="date_of_birth" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('date_of_birth')); ?>">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-calendar-alt text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="gender" class="block text-sm font-semibold text-gray-800">Gender</label>
                        <div class="relative">
                            <select name="gender" id="gender" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                                <option value="">Select Gender</option>
                                <option value="male" <?php echo e(old('gender') == 'male' ? 'selected' : ''); ?>>Male</option>
                                <option value="female" <?php echo e(old('gender') == 'female' ? 'selected' : ''); ?>>Female</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-chevron-down text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="marital_status" class="block text-sm font-semibold text-gray-800">Marital Status</label>
                        <div class="relative">
                            <select name="marital_status" id="marital_status" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                                <option value="">Select Status</option>
                                <option value="single" <?php echo e(old('marital_status') == 'single' ? 'selected' : ''); ?>>Single</option>
                                <option value="married" <?php echo e(old('marital_status') == 'married' ? 'selected' : ''); ?>>Married</option>
                                <option value="divorced" <?php echo e(old('marital_status') == 'divorced' ? 'selected' : ''); ?>>Divorced</option>
                                <option value="widowed" <?php echo e(old('marital_status') == 'widowed' ? 'selected' : ''); ?>>Widowed</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-chevron-down text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="home_town" class="block text-sm font-semibold text-gray-800">Home Town</label>
                        <div class="relative">
                            <input type="text" name="home_town" id="home_town" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('home_town')); ?>" placeholder="e.g., Kumasi, Cape Coast, Tamale">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-map-marker-alt text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="aka" class="block text-sm font-semibold text-gray-800">AKA (Also Known As)</label>
                        <div class="relative">
                            <input type="text" name="aka" id="aka" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('aka')); ?>" placeholder="e.g., Nickname, Other names">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-user-tag text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="profession" class="block text-sm font-semibold text-gray-800">Profession</label>
                        <div class="relative">
                            <input type="text" name="profession" id="profession" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('profession')); ?>" placeholder="e.g., Medical Doctor, Lawyer, Engineer">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-user-tie text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="occupation" class="block text-sm font-semibold text-gray-800">Occupation</label>
                        <div class="relative">
                            <input type="text" name="occupation" id="occupation" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('occupation')); ?>" placeholder="e.g., Senior Manager, Head Teacher">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-briefcase text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="highest_qualification" class="block text-sm font-semibold text-gray-800">Highest Qualification</label>
                        <div class="relative">
                            <select name="highest_qualification" id="highest_qualification" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                                <option value="">Select Qualification</option>
                                <option value="none" <?php echo e(old('highest_qualification') == 'none' ? 'selected' : ''); ?>>No Formal Education</option>
                                <option value="primary" <?php echo e(old('highest_qualification') == 'primary' ? 'selected' : ''); ?>>Primary School</option>
                                <option value="jhs" <?php echo e(old('highest_qualification') == 'jhs' ? 'selected' : ''); ?>>Junior High School</option>
                                <option value="shs" <?php echo e(old('highest_qualification') == 'shs' ? 'selected' : ''); ?>>Senior High School</option>
                                <option value="tertiary" <?php echo e(old('highest_qualification') == 'tertiary' ? 'selected' : ''); ?>>Tertiary/University</option>
                                <option value="postgraduate" <?php echo e(old('highest_qualification') == 'postgraduate' ? 'selected' : ''); ?>>Postgraduate</option>
                                <option value="professional" <?php echo e(old('highest_qualification') == 'professional' ? 'selected' : ''); ?>>Professional Certification</option>
                                <option value="other" <?php echo e(old('highest_qualification') == 'other' ? 'selected' : ''); ?>>Other</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-graduation-cap text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label for="day_born" class="block text-sm font-semibold text-gray-800">Day Born</label>
                        <div class="relative">
                            <select name="day_born" id="day_born" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                                <option value="">Select Day</option>
                                <option value="Sunday" <?php echo e(old('day_born') == 'Sunday' ? 'selected' : ''); ?>>Sunday</option>
                                <option value="Monday" <?php echo e(old('day_born') == 'Monday' ? 'selected' : ''); ?>>Monday</option>
                                <option value="Tuesday" <?php echo e(old('day_born') == 'Tuesday' ? 'selected' : ''); ?>>Tuesday</option>
                                <option value="Wednesday" <?php echo e(old('day_born') == 'Wednesday' ? 'selected' : ''); ?>>Wednesday</option>
                                <option value="Thursday" <?php echo e(old('day_born') == 'Thursday' ? 'selected' : ''); ?>>Thursday</option>
                                <option value="Friday" <?php echo e(old('day_born') == 'Friday' ? 'selected' : ''); ?>>Friday</option>
                                <option value="Saturday" <?php echo e(old('day_born') == 'Saturday' ? 'selected' : ''); ?>>Saturday</option>
                            </select>
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-calendar-day text-gray-400"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact Information -->
        <div class="group bg-white/70 backdrop-blur-xl rounded-3xl shadow-xl border border-white/20 p-8 hover:shadow-2xl transition-all duration-500 hover:bg-white/80">
            <div class="flex items-center mb-8">
                <div class="relative">
                    <div class="w-12 h-12 bg-gradient-to-r from-green-500 via-emerald-500 to-teal-500 rounded-2xl flex items-center justify-center shadow-lg group-hover:shadow-xl transition-all duration-300">
                        <i class="fas fa-phone text-white text-lg"></i>
                    </div>
                    <div class="absolute -top-1 -right-1 w-4 h-4 bg-gradient-to-r from-blue-400 to-blue-500 rounded-full animate-pulse"></div>
                </div>
                <div class="ml-4">
                    <h2 class="text-xl font-bold bg-gradient-to-r from-gray-900 to-gray-700 bg-clip-text text-transparent">Contact Information</h2>
                    <p class="text-gray-500 text-sm mt-1">Communication and address details</p>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label for="email" class="block text-sm font-semibold text-gray-800">Email Address</label>
                    <div class="relative">
                        <input type="email" name="email" id="email" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('email')); ?>" placeholder="e.g., member@example.com">
                        <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                            <i class="fas fa-envelope text-gray-400"></i>
                        </div>
                    </div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="space-y-2">
                    <label for="phone" class="block text-sm font-semibold text-gray-800">Primary Phone</label>
                    <div class="relative">
                        <input type="tel" name="phone" id="phone" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('phone')); ?>" placeholder="e.g., (123) 456-7890">
                        <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                            <i class="fas fa-phone text-gray-400"></i>
                        </div>
                    </div>
                </div>

                <div class="space-y-2">
                    <label for="whatsapp_phone" class="block text-sm font-semibold text-gray-800">WhatsApp Phone <span class="text-gray-500 font-normal">(if different)</span></label>
                    <div class="relative">
                        <input type="tel" name="whatsapp_phone" id="whatsapp_phone" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('whatsapp_phone')); ?>" placeholder="Enter WhatsApp number">
                        <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                            <i class="fab fa-whatsapp text-gray-400"></i>
                        </div>
                    </div>
                </div>

                <div class="space-y-2">
                    <label for="employer" class="block text-sm font-semibold text-gray-800">Employer</label>
                    <div class="relative">
                        <input type="text" name="employer" id="employer" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('employer')); ?>" placeholder="e.g., Acme Corporation">
                        <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                            <i class="fas fa-building text-gray-400"></i>
                        </div>
                    </div>
                </div>

                <div class="md:col-span-2 space-y-2">
                    <label for="address" class="block text-sm font-semibold text-gray-800">GPS Address/Location</label>
                    <textarea name="address" id="address" rows="3" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" placeholder="Enter street address"><?php echo e(old('address')); ?></textarea>
                </div>

                <div class="space-y-2">
                    <label for="city" class="block text-sm font-semibold text-gray-800">City</label>
                    <input type="text" name="city" id="city" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('city')); ?>" placeholder="Enter city">
                </div>

                <div class="space-y-2">
                    <label for="state" class="block text-sm font-semibold text-gray-800">Region/State/Province</label>
                    <input type="text" name="state" id="state" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('state')); ?>" placeholder="Enter state">
                </div>

                <div class="space-y-2">
                    <label for="postal_code" class="block text-sm font-semibold text-gray-800">Postal Code</label>
                    <input type="text" name="postal_code" id="postal_code" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md" value="<?php echo e(old('postal_code')); ?>" placeholder="Enter postal code">
                </div>

                <div class="space-y-2">
                    <label for="country" class="block text-sm font-semibold text-gray-800">Country</label>
                    <div class="relative">
                        <select name="country" id="country" class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md">
                            <option value="Ghana" <?php echo e(old('country', 'Ghana') == 'Ghana' ? 'selected' : ''); ?>>Ghana</option>
                            <option value="Nigeria" <?php echo e(old('country') == 'Nigeria' ? 'selected' : ''); ?>>Nigeria</option>
                            <option value="Togo" <?php echo e(old('country') == 'Togo' ? 'selected' : ''); ?>>Togo</option>
                            <option value="Burkina Faso" <?php echo e(old('country') == 'Burkina Faso' ? 'selected' : ''); ?>>Burkina Faso</option>
                            <option value="Ivory Coast" <?php echo e(old('country') == 'Ivory Coast' ? 'selected' : ''); ?>>Ivory Coast</option>
                            <option value="Benin" <?php echo e(old('country') == 'Benin' ? 'selected' : ''); ?>>Benin</option>
                            <option value="United States" <?php echo e(old('country') == 'United States' ? 'selected' : ''); ?>>United States</option>
                            <option value="United Kingdom" <?php echo e(old('country') == 'United Kingdom' ? 'selected' : ''); ?>>United Kingdom</option>
                            <option value="Canada" <?php echo e(old('country') == 'Canada' ? 'selected' : ''); ?>>Canada</option>
                            <option value="Germany" <?php echo e(old('country') == 'Germany' ? 'selected' : ''); ?>>Germany</option>
                            <option value="Netherlands" <?php echo e(old('country') == 'Netherlands' ? 'selected' : ''); ?>>Netherlands</option>
                            <option value="Australia" <?php echo e(old('country') == 'Australia' ? 'selected' : ''); ?>>Australia</option>
                            <option value="South Africa" <?php echo e(old('country') == 'South Africa' ? 'selected' : ''); ?>>South Africa</option>
                            <option value="Other" <?php echo e(old('country') == 'Other' ? 'selected' : ''); ?>>Other</option>
                        </select>
                        <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                            <i class="fas fa-chevron-down text-gray-400"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Family Information -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center mb-6">
                <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-600 rounded-xl flex items-center justify-center mr-3">
                    <i class="fas fa-home text-white"></i>
                </div>
                <h2 class="text-lg font-semibold text-gray-900">Family Information</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="family_id" class="block text-sm font-medium text-gray-700 mb-2">Family</label>
                    <select name="family_id" id="family_id" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Select Family or Create New</option>
                        <?php $__currentLoopData = $families ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $family): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($family->id); ?>" <?php echo e(old('family_id') == $family->id ? 'selected' : ''); ?>>
                                <?php echo e($family->family_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div>
                    <label for="relationship_to_head" class="block text-sm font-medium text-gray-700 mb-2">Relationship to Family Head</label>
                    <select name="relationship_to_head" id="relationship_to_head" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Select Relationship</option>
                        <option value="head" <?php echo e(old('relationship_to_head') == 'head' ? 'selected' : ''); ?>>Head of Family</option>
                        <option value="spouse" <?php echo e(old('relationship_to_head') == 'spouse' ? 'selected' : ''); ?>>Spouse</option>
                        <option value="child" <?php echo e(old('relationship_to_head') == 'child' ? 'selected' : ''); ?>>Child</option>
                        <option value="parent" <?php echo e(old('relationship_to_head') == 'parent' ? 'selected' : ''); ?>>Parent</option>
                        <option value="sibling" <?php echo e(old('relationship_to_head') == 'sibling' ? 'selected' : ''); ?>>Sibling</option>
                        <option value="relative" <?php echo e(old('relationship_to_head') == 'relative' ? 'selected' : ''); ?>>Other Relative</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Membership Information -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center mb-6">
                <div class="w-10 h-10 bg-gradient-to-br from-orange-500 to-red-600 rounded-xl flex items-center justify-center mr-3">
                    <i class="fas fa-id-card text-white"></i>
                </div>
                <h2 class="text-lg font-semibold text-gray-900">Membership Information</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <div>
                    <label for="membership_date" class="block text-sm font-medium text-gray-700 mb-2">Membership Date</label>
                    <input type="date" name="membership_date" id="membership_date" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('membership_date', date('Y-m-d'))); ?>">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Year Group</label>
                    <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                        <div class="flex items-center">
                            <i class="fas fa-info-circle text-blue-500 mr-2"></i>
                            <span class="text-sm text-blue-700">
                                <strong>Auto-assigned based on age</strong><br>
                                Year group will be automatically determined from the date of birth.
                            </span>
                        </div>
                    </div>
                </div>

                <div>
                    <label for="membership_status" class="block text-sm font-medium text-gray-700 mb-2">Membership Status</label>
                    <select name="membership_status" id="membership_status" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="active" <?php echo e(old('membership_status', 'active') == 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="inactive" <?php echo e(old('membership_status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                        <option value="transferred" <?php echo e(old('membership_status') == 'transferred' ? 'selected' : ''); ?>>Transferred</option>
                        <option value="deceased" <?php echo e(old('membership_status') == 'deceased' ? 'selected' : ''); ?>>Deceased</option>
                    </select>
                </div>

                <div>
                    <label for="membership_type" class="block text-sm font-medium text-gray-700 mb-2">Membership Type (PCG)</label>
                    <select name="membership_type" id="membership_type" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="communicant" <?php echo e(old('membership_type', 'communicant') == 'communicant' ? 'selected' : ''); ?>>Communicant Member (Full Member)</option>
                        <option value="baptized" <?php echo e(old('membership_type') == 'baptized' ? 'selected' : ''); ?>>Baptized Member</option>
                        <option value="confirmed" <?php echo e(old('membership_type') == 'confirmed' ? 'selected' : ''); ?>>Confirmed Member</option>
                        <option value="long_distance" <?php echo e(old('membership_type') == 'long_distance' ? 'selected' : ''); ?>>Long Distance Member</option>
                        <option value="adherent" <?php echo e(old('membership_type') == 'adherent' ? 'selected' : ''); ?>>Adherent</option>
                        <option value="catechumen" <?php echo e(old('membership_type') == 'catechumen' ? 'selected' : ''); ?>>Catechumen (Learner / New Member)</option>
                    </select>
                </div>

            </div>
        </div>

        <!-- Spiritual Information -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center mb-6">
                <div class="w-10 h-10 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-xl flex items-center justify-center mr-3">
                    <i class="fas fa-cross text-white"></i>
                </div>
                <h2 class="text-lg font-semibold text-gray-900">Spiritual Information</h2>
            </div>

            <!-- Baptism Section -->
            <div class="mb-8">
                <div class="flex items-center mb-4">
                    <input type="checkbox" name="is_baptized" id="is_baptized" value="1" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e(old('is_baptized') ? 'checked' : ''); ?>>
                    <label for="is_baptized" class="ml-2 block text-sm font-semibold text-gray-900">Are you baptized? YES/NO. IF YES,</label>
                </div>

                <div id="baptism-details" class="grid grid-cols-1 md:grid-cols-2 gap-4 <?php echo e(old('is_baptized') ? '' : 'hidden'); ?>">
                    <div>
                        <label for="baptism_date" class="block text-sm font-medium text-gray-700 mb-2">Date of Baptism</label>
                        <input type="date" name="baptism_date" id="baptism_date" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('baptism_date')); ?>">
                    </div>
                    <div>
                        <label for="place_of_baptism" class="block text-sm font-medium text-gray-700 mb-2">Place of Baptism</label>
                        <input type="text" name="place_of_baptism" id="place_of_baptism" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('place_of_baptism')); ?>">
                    </div>
                    <div>
                        <label for="baptism_type" class="block text-sm font-medium text-gray-700 mb-2">Type of Baptism</label>
                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="radio" name="baptism_type" value="sprinkling" class="mr-2" <?php echo e(old('baptism_type') == 'sprinkling' ? 'checked' : ''); ?>>
                                Sprinkling
                            </label>
                            <label class="flex items-center">
                                <input type="radio" name="baptism_type" value="immersion" class="mr-2" <?php echo e(old('baptism_type') == 'immersion' ? 'checked' : ''); ?>>
                                Immersion
                            </label>
                            <label class="flex items-center">
                                <input type="radio" name="baptism_type" value="pouring" class="mr-2" <?php echo e(old('baptism_type') == 'pouring' ? 'checked' : ''); ?>>
                                Pouring Water
                            </label>
                            <label class="flex items-center">
                                <input type="radio" name="baptism_type" value="other" class="mr-2" <?php echo e(old('baptism_type') == 'other' ? 'checked' : ''); ?>>
                                Other
                            </label>
                        </div>
                    </div>
                    <div>
                        <label for="baptism_officiating_minister" class="block text-sm font-medium text-gray-700 mb-2">Officiating Minister</label>
                        <input type="text" name="baptism_officiating_minister" id="baptism_officiating_minister" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('baptism_officiating_minister')); ?>">
                    </div>
                </div>
            </div>

            <!-- Confirmation Section -->
            <div class="mb-8">
                <div class="flex items-center mb-4">
                    <input type="checkbox" name="is_confirmed" id="is_confirmed" value="1" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e(old('is_confirmed') ? 'checked' : ''); ?>>
                    <label for="is_confirmed" class="ml-2 block text-sm font-semibold text-gray-900">Are you confirmed? YES/NO. IF YES,</label>
                </div>

                <div id="confirmation-details" class="grid grid-cols-1 md:grid-cols-2 gap-4 <?php echo e(old('is_confirmed') ? '' : 'hidden'); ?>">
                    <div>
                        <label for="confirmation_date" class="block text-sm font-medium text-gray-700 mb-2">Date Confirmed</label>
                        <input type="date" name="confirmation_date" id="confirmation_date" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('confirmation_date')); ?>">
                    </div>
                    <div>
                        <label for="place_of_confirmation" class="block text-sm font-medium text-gray-700 mb-2">Place Confirmed</label>
                        <input type="text" name="place_of_confirmation" id="place_of_confirmation" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('place_of_confirmation')); ?>">
                    </div>
                    <div>
                        <label for="age_confirmed" class="block text-sm font-medium text-gray-700 mb-2">Age Confirmed</label>
                        <input type="number" name="age_confirmed" id="age_confirmed" min="1" max="100" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('age_confirmed')); ?>">
                    </div>
                    <div>
                        <label for="confirmation_bible_verse" class="block text-sm font-medium text-gray-700 mb-2">Bible Verse Used</label>
                        <input type="text" name="confirmation_bible_verse" id="confirmation_bible_verse" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('confirmation_bible_verse')); ?>">
                    </div>
                    <div class="md:col-span-2">
                        <label for="confirmation_officiating_minister" class="block text-sm font-medium text-gray-700 mb-2">Officiating Minister</label>
                        <input type="text" name="confirmation_officiating_minister" id="confirmation_officiating_minister" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('confirmation_officiating_minister')); ?>">
                    </div>
                </div>
            </div>

            <!-- Marriage Section -->
            <div class="mb-8">
                <div class="flex items-center mb-4">
                    <input type="checkbox" name="is_married" id="is_married" value="1" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e(old('is_married') ? 'checked' : ''); ?>>
                    <label for="is_married" class="ml-2 block text-sm font-semibold text-gray-900">If you are married, then</label>
                </div>

                <div id="marriage-details" class="grid grid-cols-1 md:grid-cols-2 gap-4 <?php echo e(old('is_married') ? '' : 'hidden'); ?>">
                    <div>
                        <label for="marriage_date" class="block text-sm font-medium text-gray-700 mb-2">Date of Marriage</label>
                        <input type="date" name="marriage_date" id="marriage_date" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('marriage_date')); ?>">
                    </div>
                    <div>
                        <label for="place_of_marriage" class="block text-sm font-medium text-gray-700 mb-2">Place of Marriage</label>
                        <input type="text" name="place_of_marriage" id="place_of_marriage" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('place_of_marriage')); ?>">
                    </div>
                    <div>
                        <label for="marriage_type" class="block text-sm font-medium text-gray-700 mb-2">Type of Marriage</label>
                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="radio" name="marriage_type" value="traditional" class="mr-2" <?php echo e(old('marriage_type') == 'traditional' ? 'checked' : ''); ?>>
                                Traditional
                            </label>
                            <label class="flex items-center">
                                <input type="radio" name="marriage_type" value="customary" class="mr-2" <?php echo e(old('marriage_type') == 'customary' ? 'checked' : ''); ?>>
                                Customary
                            </label>
                            <label class="flex items-center">
                                <input type="radio" name="marriage_type" value="ordinance" class="mr-2" <?php echo e(old('marriage_type') == 'ordinance' ? 'checked' : ''); ?>>
                                Ordinance
                            </label>
                            <label class="flex items-center">
                                <input type="radio" name="marriage_type" value="other" class="mr-2" <?php echo e(old('marriage_type') == 'other' ? 'checked' : ''); ?>>
                                Other
                            </label>
                        </div>
                    </div>
                    <div>
                        <label for="marriage_officiating_minister" class="block text-sm font-medium text-gray-700 mb-2">Officiating Minister</label>
                        <input type="text" name="marriage_officiating_minister" id="marriage_officiating_minister" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('marriage_officiating_minister')); ?>">
                    </div>
                </div>
            </div>

            <!-- Family Section -->
            <div>
                <div class="flex items-center mb-4">
                    <input type="checkbox" name="has_family" id="has_family" value="1" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e(old('has_family') ? 'checked' : ''); ?>>
                    <label for="has_family" class="ml-2 block text-sm font-semibold text-gray-900">Do you have a family? MAN/WOMAN? YES/NO</label>
                </div>
            </div>
        </div>

        <!-- Emergency Contact -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center mb-6">
                <div class="w-10 h-10 bg-gradient-to-br from-red-500 to-pink-600 rounded-xl flex items-center justify-center mr-3">
                    <i class="fas fa-exclamation-triangle text-white"></i>
                </div>
                <h2 class="text-lg font-semibold text-gray-900">Emergency Contact</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="emergency_contact_name" class="block text-sm font-medium text-gray-700 mb-2">Emergency Contact Name</label>
                    <input type="text" name="emergency_contact_name" id="emergency_contact_name" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('emergency_contact_name')); ?>">
                </div>

                <div>
                    <label for="emergency_contact_phone" class="block text-sm font-medium text-gray-700 mb-2">Emergency Contact Phone</label>
                    <input type="tel" name="emergency_contact_phone" id="emergency_contact_phone" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('emergency_contact_phone')); ?>">
                </div>

                <div>
                    <label for="emergency_contact_relationship" class="block text-sm font-medium text-gray-700 mb-2">Relationship</label>
                    <select name="emergency_contact_relationship" id="emergency_contact_relationship" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Select Relationship</option>
                        <option value="brother" <?php echo e(old('emergency_contact_relationship') == 'brother' ? 'selected' : ''); ?>>Brother</option>
                        <option value="sister" <?php echo e(old('emergency_contact_relationship') == 'sister' ? 'selected' : ''); ?>>Sister</option>
                        <option value="mother" <?php echo e(old('emergency_contact_relationship') == 'mother' ? 'selected' : ''); ?>>Mother</option>
                        <option value="father" <?php echo e(old('emergency_contact_relationship') == 'father' ? 'selected' : ''); ?>>Father</option>
                        <option value="spouse" <?php echo e(old('emergency_contact_relationship') == 'spouse' ? 'selected' : ''); ?>>Spouse</option>
                        <option value="friend" <?php echo e(old('emergency_contact_relationship') == 'friend' ? 'selected' : ''); ?>>Friend</option>
                        <option value="other" <?php echo e(old('emergency_contact_relationship') == 'other' ? 'selected' : ''); ?>>Other</option>
                    </select>
                </div>

                <div class="md:col-span-2">
                    <label for="medical_conditions" class="block text-sm font-medium text-gray-700 mb-2">Medical Conditions / Allergies</label>
                    <textarea name="medical_conditions" id="medical_conditions" rows="3" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="List any medical conditions, allergies, or special needs..."><?php echo e(old('medical_conditions')); ?></textarea>
                </div>

                <div class="md:col-span-2">
                    <div class="mb-4">
                        <div class="flex items-center mb-4">
                            <input type="checkbox" name="physically_challenged" id="physically_challenged" value="1" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e(old('physically_challenged') ? 'checked' : ''); ?>>
                            <label for="physically_challenged" class="ml-2 block text-sm font-semibold text-gray-900">PHYSICALLY CHALLENGED? YES/NO. IF YES,</label>
                        </div>
                        
                        <div id="disability-type-section" class="mt-4 <?php echo e(old('physically_challenged') ? '' : 'hidden'); ?>">
                            <label for="disability_type" class="block text-sm font-medium text-gray-700 mb-2">Disability Type</label>
                            <div class="relative">
                                <select name="disability_type" id="disability_type" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    <option value="">Select Disability Type</option>
                                    <option value="mobility" <?php echo e(old('disability_type') == 'mobility' ? 'selected' : ''); ?>>Mobility/Physical</option>
                                    <option value="visual" <?php echo e(old('disability_type') == 'visual' ? 'selected' : ''); ?>>Visual Impairment</option>
                                    <option value="hearing" <?php echo e(old('disability_type') == 'hearing' ? 'selected' : ''); ?>>Hearing Impairment</option>
                                    <option value="speech" <?php echo e(old('disability_type') == 'speech' ? 'selected' : ''); ?>>Speech Impairment</option>
                                    <option value="intellectual" <?php echo e(old('disability_type') == 'intellectual' ? 'selected' : ''); ?>>Intellectual Disability</option>
                                    <option value="learning" <?php echo e(old('disability_type') == 'learning' ? 'selected' : ''); ?>>Learning Disability</option>
                                    <option value="mental_health" <?php echo e(old('disability_type') == 'mental_health' ? 'selected' : ''); ?>>Mental Health Condition</option>
                                    <option value="chronic_illness" <?php echo e(old('disability_type') == 'chronic_illness' ? 'selected' : ''); ?>>Chronic Illness</option>
                                    <option value="multiple" <?php echo e(old('disability_type') == 'multiple' ? 'selected' : ''); ?>>Multiple Disabilities</option>
                                    <option value="other" <?php echo e(old('disability_type') == 'other' ? 'selected' : ''); ?>>Other</option>
                                </select>
                                <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                    <i class="fas fa-chevron-down text-gray-400"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Schooling Information Section -->
                <div class="md:col-span-2 mt-6 p-4 bg-blue-50 rounded-lg">
                    <div class="mb-4">
                        <div class="flex items-center mb-4">
                            <input type="checkbox" name="currently_schooling" id="currently_schooling" value="1" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e(old('currently_schooling') ? 'checked' : ''); ?>>
                            <label for="currently_schooling" class="ml-2 block text-sm font-semibold text-gray-900">ARE YOU CURRENTLY SCHOOLING? YES/NO. IF YES,</label>
                        </div>
                        
                        <div id="school-details-section" class="mt-4 <?php echo e(old('currently_schooling') ? '' : 'hidden'); ?>">
                            <h4 class="text-md font-semibold text-gray-800 mb-3">4.5 SCHOOL DETAILS</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="school_name" class="block text-sm font-medium text-gray-700 mb-2">Name of School</label>
                                    <input type="text" name="school_name" id="school_name" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('school_name')); ?>" placeholder="Enter school name">
                                </div>
                                <div>
                                    <label for="school_admission_date" class="block text-sm font-medium text-gray-700 mb-2">Admission Date (DD/MM/YYYY)</label>
                                    <input type="date" name="school_admission_date" id="school_admission_date" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('school_admission_date')); ?>">
                                </div>
                                <div>
                                    <label for="school_completion_date" class="block text-sm font-medium text-gray-700 mb-2">Completion Date</label>
                                    <input type="date" name="school_completion_date" id="school_completion_date" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('school_completion_date')); ?>">
                                </div>
                                <div>
                                    <label for="school_telephone" class="block text-sm font-medium text-gray-700 mb-2">School Telephone</label>
                                    <input type="tel" name="school_telephone" id="school_telephone" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('school_telephone')); ?>" placeholder="School phone number">
                                </div>
                                <div class="md:col-span-2">
                                    <label for="school_location" class="block text-sm font-medium text-gray-700 mb-2">School Location</label>
                                    <textarea name="school_location" id="school_location" rows="2" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="Enter school address/location"><?php echo e(old('school_location')); ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Guardian Information Section -->
            <div class="mt-6 p-4 bg-gray-50 rounded-lg">
                <h3 class="text-lg font-medium text-gray-800 mb-3">Guardian Information (For Minors)</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="guardian_name" class="block text-sm font-medium text-gray-700 mb-2">Guardian Name</label>
                        <input type="text" name="guardian_name" id="guardian_name" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('guardian_name')); ?>">
                    </div>
                    <div>
                        <label for="guardian_relationship" class="block text-sm font-medium text-gray-700 mb-2">Guardian Relationship</label>
                        <input type="text" name="guardian_relationship" id="guardian_relationship" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('guardian_relationship')); ?>">
                    </div>
                    <div>
                        <label for="guardian_phone" class="block text-sm font-medium text-gray-700 mb-2">Guardian Phone</label>
                        <input type="tel" name="guardian_phone" id="guardian_phone" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" value="<?php echo e(old('guardian_phone')); ?>">
                    </div>
                    <div>
                        <label for="guardian_address" class="block text-sm font-medium text-gray-700 mb-2">Guardian Address</label>
                        <textarea name="guardian_address" id="guardian_address" rows="2" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"><?php echo e(old('guardian_address')); ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Information -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center mb-6">
                <div class="w-10 h-10 bg-gradient-to-br from-teal-500 to-cyan-600 rounded-xl flex items-center justify-center mr-3">
                    <i class="fas fa-info-circle text-white"></i>
                </div>
                <h2 class="text-lg font-semibold text-gray-900">Additional Information</h2>
            </div>

            <div class="space-y-6">
                <div>
                    <label for="skills_talents" class="block text-sm font-medium text-gray-700 mb-2">Skills & Talents</label>
                    <textarea name="skills_talents" id="skills_talents" rows="3" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="List skills, talents, or areas of expertise..."><?php echo e(old('skills_talents')); ?></textarea>
                </div>

                <div>
                    <label for="interests" class="block text-sm font-medium text-gray-700 mb-2">Interests & Hobbies</label>
                    <textarea name="interests" id="interests" rows="3" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="List interests, hobbies, or ministry preferences..."><?php echo e(old('interests')); ?></textarea>
                </div>

                <div>
                    <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Additional Notes</label>
                    <textarea name="notes" id="notes" rows="4" class="block w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="Any additional notes or comments..."><?php echo e(old('notes')); ?></textarea>
                </div>

                <!-- Interest Group Details (Ministries) -->
                <div>
                    <h3 class="text-sm font-medium text-gray-700 mb-3">4.6 INTEREST GROUP DETAILS (underline your groups)</h3>
                    <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
                        <?php if(isset($ministries) && $ministries->count() > 0): ?>
                            <?php $__currentLoopData = $ministries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ministry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-center">
                                    <input type="checkbox" name="ministries[]" id="ministry_<?php echo e($ministry->id); ?>" value="<?php echo e($ministry->id); ?>" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e(in_array($ministry->id, old('ministries', [])) ? 'checked' : ''); ?>>
                                    <label for="ministry_<?php echo e($ministry->id); ?>" class="ml-2 block text-sm text-gray-900"><?php echo e($ministry->name); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="col-span-full">
                                <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
                                    <div class="flex items-center">
                                        <input type="checkbox" name="ministries[]" value="choir" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 block text-sm text-gray-900">Choir</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="ministries[]" value="youth" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 block text-sm text-gray-900">Youth Ministry</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="ministries[]" value="womens_fellowship" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 block text-sm text-gray-900">Women's Fellowship</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="ministries[]" value="mens_fellowship" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 block text-sm text-gray-900">Men's Fellowship</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="ministries[]" value="sunday_school" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 block text-sm text-gray-900">Sunday School</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="ministries[]" value="ushering" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 block text-sm text-gray-900">Ushering</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="ministries[]" value="evangelism" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 block text-sm text-gray-900">Evangelism</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="ministries[]" value="prayer_ministry" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 block text-sm text-gray-900">Prayer Ministry</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="ministries[]" value="media_ministry" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 block text-sm text-gray-900">Media Ministry</label>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Communication Preferences -->
                <div>
                    <h3 class="text-sm font-medium text-gray-700 mb-3">Communication Preferences</h3>
                    <div class="space-y-2">
                        <div class="flex items-center">
                            <input type="checkbox" name="receive_newsletter" id="receive_newsletter" value="1" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e(old('receive_newsletter', true) ? 'checked' : ''); ?>>
                            <label for="receive_newsletter" class="ml-2 block text-sm text-gray-900">Receive email newsletters and announcements</label>
                        </div>
                        <div class="flex items-center">
                            <input type="checkbox" name="receive_sms" id="receive_sms" value="1" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e(old('receive_sms') ? 'checked' : ''); ?>>
                            <label for="receive_sms" class="ml-2 block text-sm text-gray-900">Receive SMS notifications for urgent announcements</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="flex flex-col sm:flex-row justify-end space-y-3 sm:space-y-0 sm:space-x-6 pt-8">
            <a href="<?php echo e(route('members.index')); ?>" class="inline-flex items-center justify-center px-8 py-4 bg-white/80 backdrop-blur-sm text-gray-700 font-semibold rounded-2xl hover:bg-white hover:shadow-lg transition-all duration-300 border border-gray-200/50">
                <i class="fas fa-times mr-2 text-gray-500"></i>
                Cancel
            </a>
            <button type="submit" id="submit-btn" class="inline-flex items-center justify-center px-8 py-4 bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 text-white font-bold rounded-2xl hover:from-blue-700 hover:via-indigo-700 hover:to-purple-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105 disabled:opacity-50 disabled:cursor-not-allowed">
                <i class="fas fa-user-plus mr-3" id="submit-icon"></i>
                <span id="submit-text">Add Member</span>
                <div class="ml-2 w-2 h-2 bg-white/30 rounded-full animate-pulse"></div>
            </button>
        </div>
    </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Photo preview functionality
    const photoInput = document.getElementById('photo');
    const photoPreview = document.getElementById('photo-preview');
    const photoIcon = document.getElementById('photo-icon');

    photoInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                photoPreview.src = e.target.result;
                photoPreview.classList.remove('hidden');
                photoIcon.classList.add('hidden');
            };
            reader.readAsDataURL(file);
        }
    });

    // Toggle sections based on checkboxes
    const baptizedCheckbox = document.getElementById('is_baptized');
    const baptismDetails = document.getElementById('baptism-details');
    
    const confirmedCheckbox = document.getElementById('is_confirmed');
    const confirmationDetails = document.getElementById('confirmation-details');
    
    const marriedCheckbox = document.getElementById('is_married');
    const marriageDetails = document.getElementById('marriage-details');
    
    baptizedCheckbox.addEventListener('change', function() {
        baptismDetails.classList.toggle('hidden', !this.checked);
    });
    
    confirmedCheckbox.addEventListener('change', function() {
        confirmationDetails.classList.toggle('hidden', !this.checked);
    });
    
    marriedCheckbox.addEventListener('change', function() {
        marriageDetails.classList.toggle('hidden', !this.checked);
    });

    // Toggle disability type section
    const physicallyChallengeddCheckbox = document.getElementById('physically_challenged');
    const disabilityTypeSection = document.getElementById('disability-type-section');
    
    physicallyChallengeddCheckbox.addEventListener('change', function() {
        disabilityTypeSection.classList.toggle('hidden', !this.checked);
    });

    // Toggle school details section
    const currentlySchoolingCheckbox = document.getElementById('currently_schooling');
    const schoolDetailsSection = document.getElementById('school-details-section');
    
    currentlySchoolingCheckbox.addEventListener('change', function() {
        schoolDetailsSection.classList.toggle('hidden', !this.checked);
    });

    // Form submission enhancement
    const form = document.querySelector('form');
    const submitBtn = document.getElementById('submit-btn');
    const submitIcon = document.getElementById('submit-icon');
    const submitText = document.getElementById('submit-text');

    form.addEventListener('submit', function(e) {
        // Show loading state
        submitBtn.disabled = true;
        submitIcon.className = 'fas fa-spinner fa-spin mr-3';
        submitText.textContent = 'Creating Member...';
        
        // Scroll to top to show any error messages
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });

    // Form validation feedback
    const requiredFields = document.querySelectorAll('[required]');
    requiredFields.forEach(field => {
        field.addEventListener('blur', function() {
            if (!this.value.trim()) {
                this.classList.add('border-red-500');
                this.classList.remove('border-gray-200');
            } else {
                this.classList.remove('border-red-500');
                this.classList.add('border-green-500');
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/presby_app/resources/views/members/create.blade.php ENDPATH**/ ?>