<x-app-layout>
<div class="space-y-6">
    <!-- Hero Section -->
    <div class="relative overflow-hidden bg-gradient-to-br from-blue-600 via-blue-700 to-red-600 rounded-3xl shadow-2xl">
        <div class="absolute inset-0 bg-black/10"></div>
        <div class="absolute inset-0" style="background-image: radial-gradient(circle at 20% 50%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
            radial-gradient(circle at 80% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%);"></div>
        <div class="relative p-8 md:p-12">
            <div class="flex flex-col md:flex-row items-start md:items-center justify-between gap-6">
                <div class="flex items-center space-x-6">
                    <div class="w-20 h-20 bg-white/20 backdrop-blur-sm rounded-2xl flex items-center justify-center border-2 border-white/30 shadow-lg">
                        <i class="fas fa-layer-group text-white text-3xl"></i>
                    </div>
                    <div>
                        <h1 class="text-4xl md:text-5xl font-bold text-white mb-2">
                            Age Groups
                        </h1>
                        <p class="text-blue-100 text-lg">Organize and manage members by age categories</p>
                    </div>
                </div>
                <div class="flex items-center space-x-3">
                    <a href="{{ route('members.index') }}" class="px-6 py-3 bg-white/20 backdrop-blur-sm hover:bg-white/30 text-white rounded-xl transition-all duration-200 border border-white/30 shadow-lg hover:shadow-xl">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Back to Members
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Total Members -->
        <div class="group bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 overflow-hidden border border-gray-100">
            <div class="h-2 bg-gradient-to-r from-blue-600 to-blue-700"></div>
            <div class="p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-medium mb-1">Total Members</p>
                        <h3 class="text-4xl font-bold text-gray-900 mb-1">{{ number_format($totalMembers) }}</h3>
                        <p class="text-blue-600 text-xs font-medium">With assigned age groups</p>
                    </div>
                    <div class="w-16 h-16 bg-gradient-to-br from-blue-100 to-blue-200 rounded-2xl flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-users text-blue-600 text-3xl"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Groups -->
        <div class="group bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 overflow-hidden border border-gray-100">
            <div class="h-2 bg-gradient-to-r from-red-600 to-red-700"></div>
            <div class="p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-medium mb-1">Active Age Groups</p>
                        <h3 class="text-4xl font-bold text-gray-900 mb-1">{{ $yearGroups->count() }}</h3>
                        <p class="text-red-600 text-xs font-medium">Currently configured</p>
                    </div>
                    <div class="w-16 h-16 bg-gradient-to-br from-red-100 to-red-200 rounded-2xl flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-layer-group text-red-600 text-3xl"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Unassigned -->
        <div class="group bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 overflow-hidden border border-gray-100">
            <div class="h-2 bg-gradient-to-r from-orange-500 to-orange-600"></div>
            <div class="p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-medium mb-1">Unassigned</p>
                        <h3 class="text-4xl font-bold text-gray-900 mb-1">{{ number_format($unassignedMembers) }}</h3>
                        <p class="text-orange-600 text-xs font-medium">Members without age group</p>
                    </div>
                    <div class="w-16 h-16 bg-gradient-to-br from-orange-100 to-orange-200 rounded-2xl flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                        <i class="fas fa-exclamation-triangle text-orange-600 text-3xl"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if($unassignedMembers > 0)
    <!-- Unassigned Alert -->
    <div class="bg-orange-50 border-l-4 border-orange-500 p-4 rounded-lg">
        <div class="flex items-center">
            <i class="fas fa-exclamation-circle text-orange-500 text-xl mr-3"></i>
            <div class="flex-1">
                <p class="text-orange-800 font-medium">{{ $unassignedMembers }} member(s) without age group assignment</p>
                <p class="text-orange-600 text-sm mt-1">Run: <code class="bg-orange-100 px-2 py-1 rounded">php artisan members:assign-year-groups</code> to auto-assign them.</p>
            </div>
        </div>
    </div>
    @endif

    <!-- Age Groups Grid -->
    <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
        <div class="p-6 bg-gradient-to-r from-blue-600 to-red-600 text-white">
            <h2 class="text-xl font-semibold">Age Groups Overview</h2>
            <p class="text-blue-100 mt-1">Click on any age group to view and filter members</p>
        </div>

        @if($yearGroups->isEmpty())
            <div class="p-12 text-center">
                <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-users-slash text-gray-400 text-3xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-600 mb-2">No Age Groups Found</h3>
                <p class="text-gray-500 mb-4">Create age groups to organize your members by age ranges.</p>
                <a href="{{ route('settings.index') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                    <i class="fas fa-plus mr-2"></i>
                    Create Age Group
                </a>
            </div>
        @else
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 p-6">
                @foreach($yearGroups as $group)
                <a href="{{ route('age-groups.show', $group) }}" 
                   class="group block bg-white border-2 border-gray-200 rounded-2xl overflow-hidden hover:border-transparent hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300">
                    <!-- Color Stripe -->
                    <div class="h-2 transition-all duration-300" 
                         style="background: linear-gradient(90deg, {{ $group->color ?? '#3b82f6' }} 0%, {{ $group->color ?? '#3b82f6' }}dd 100%);"></div>
                    
                    <div class="p-6">
                        <div class="flex items-start justify-between mb-4">
                            <div class="flex items-center space-x-4">
                                <div class="w-14 h-14 rounded-xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform duration-300" 
                                     style="background: linear-gradient(135deg, {{ $group->color ?? '#3b82f6' }} 0%, {{ $group->color ?? '#3b82f6' }}dd 100%);">
                                    <i class="fas fa-users text-white text-xl"></i>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900 text-xl group-hover:text-blue-600 transition-colors leading-tight">
                                        {{ $group->name }}
                                    </h3>
                                    <p class="text-sm text-gray-500 font-medium mt-1">{{ $group->abbreviation }}</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Member Count Badge -->
                        <div class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-50 to-cyan-50 border-2 border-blue-200 rounded-xl mb-4 group-hover:border-blue-400 transition-colors">
                            <i class="fas fa-user-friends text-blue-600 mr-2"></i>
                            <span class="text-blue-700 font-bold text-lg">{{ $group->members_count }}</span>
                            <span class="text-blue-600 text-sm ml-1">members</span>
                        </div>
                        
                        <div class="space-y-3 mb-4">
                            <div class="flex items-center text-sm text-gray-600 bg-gray-50 px-3 py-2 rounded-lg">
                                <i class="fas fa-birthday-cake w-5 text-blue-500 mr-2"></i>
                                <span class="font-medium">Ages: {{ $group->min_age }}-{{ $group->max_age }} years</span>
                            </div>
                            @if($group->description)
                            <p class="text-sm text-gray-600 leading-relaxed line-clamp-2">{{ $group->description }}</p>
                            @endif
                        </div>
                        
                        <div class="flex items-center justify-between pt-4 border-t-2 border-gray-100 group-hover:border-blue-200 transition-colors">
                            <span class="text-sm font-semibold text-gray-600 group-hover:text-blue-600 transition-colors">
                                <i class="fas fa-eye mr-2"></i>View Members
                            </span>
                            <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center group-hover:bg-blue-600 transition-colors">
                                <i class="fas fa-arrow-right text-blue-600 group-hover:text-white group-hover:translate-x-1 transition-all text-sm"></i>
                            </div>
                        </div>
                    </div>
                </a>
                @endforeach
            </div>
        @endif
    </div>
</div>
</x-app-layout>
