<x-app-layout>
    <!-- Page Header with Gradient -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 rounded-2xl shadow-xl p-8 text-white">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl font-bold mb-2 flex items-center">
                        <i class="fas fa-users-cog mr-3"></i>
                        User Management
                    </h1>
                    <p class="text-blue-100 text-sm">Manage system users, roles, and permissions</p>
                </div>
                @if(auth()->user()->role === 'admin')
                <a href="{{ route('users.create') }}" class="bg-white text-purple-600 hover:bg-blue-50 px-6 py-3 rounded-lg font-semibold shadow-lg hover:shadow-xl transition-all duration-200 flex items-center">
                    <i class="fas fa-user-plus mr-2"></i>
                    Add New User
                </a>
                @endif
            </div>
        </div>
    </div>

    <!-- Success/Error Messages -->
    @if(session('success'))
    <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
        <div class="flex items-center">
            <i class="fas fa-check-circle text-green-500 mr-3"></i>
            <p class="text-green-800 font-medium">{{ session('success') }}</p>
        </div>
    </div>
    @endif

    @if(session('error'))
    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-lg">
        <div class="flex items-center">
            <i class="fas fa-exclamation-circle text-red-500 mr-3"></i>
            <p class="text-red-800 font-medium">{{ session('error') }}</p>
        </div>
    </div>
    @endif

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- Total Users -->
        <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl shadow-lg p-6 text-white transform hover:scale-105 transition-all duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-blue-100 text-sm font-medium mb-1">Total Users</p>
                    <h3 class="text-3xl font-bold">{{ $stats['total_users'] }}</h3>
                </div>
                <div class="bg-white bg-opacity-20 rounded-full p-4">
                    <i class="fas fa-users text-2xl"></i>
                </div>
            </div>
            <div class="mt-4 text-blue-100 text-xs">
                <i class="fas fa-chart-line mr-1"></i>
                All system users
            </div>
        </div>

        <!-- Administrators -->
        <div class="bg-gradient-to-br from-red-500 to-red-600 rounded-xl shadow-lg p-6 text-white transform hover:scale-105 transition-all duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-red-100 text-sm font-medium mb-1">Administrators</p>
                    <h3 class="text-3xl font-bold">{{ $stats['admin_users'] }}</h3>
                </div>
                <div class="bg-white bg-opacity-20 rounded-full p-4">
                    <i class="fas fa-user-shield text-2xl"></i>
                </div>
            </div>
            <div class="mt-4 text-red-100 text-xs">
                <i class="fas fa-key mr-1"></i>
                Full system access
            </div>
        </div>

        <!-- Staff Members -->
        <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl shadow-lg p-6 text-white transform hover:scale-105 transition-all duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-purple-100 text-sm font-medium mb-1">Staff Members</p>
                    <h3 class="text-3xl font-bold">{{ $stats['staff_users'] }}</h3>
                </div>
                <div class="bg-white bg-opacity-20 rounded-full p-4">
                    <i class="fas fa-user-tie text-2xl"></i>
                </div>
            </div>
            <div class="mt-4 text-purple-100 text-xs">
                <i class="fas fa-briefcase mr-1"></i>
                Standard access
            </div>
        </div>

        <!-- With Assigned Roles -->
        <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-xl shadow-lg p-6 text-white transform hover:scale-105 transition-all duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-green-100 text-sm font-medium mb-1">Assigned Roles</p>
                    <h3 class="text-3xl font-bold">{{ $stats['users_with_roles'] }}</h3>
                </div>
                <div class="bg-white bg-opacity-20 rounded-full p-4">
                    <i class="fas fa-shield-alt text-2xl"></i>
                </div>
            </div>
            <div class="mt-4 text-green-100 text-xs">
                <i class="fas fa-check-circle mr-1"></i>
                Using new role system
            </div>
        </div>
    </div>

    <!-- Search and Filter -->
    <div class="bg-white rounded-xl shadow-lg p-6 mb-8 border border-gray-100">
        <div class="flex items-center mb-4">
            <i class="fas fa-filter text-purple-600 mr-2"></i>
            <h3 class="text-lg font-semibold text-gray-800">Search & Filter</h3>
        </div>
        <form action="{{ route('users.index') }}" method="GET">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Search -->
                <div class="md:col-span-2">
                    <label for="search" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-search text-gray-400 mr-1"></i>
                        Search Users
                    </label>
                    <div class="relative">
                        <input type="text" name="search" id="search" value="{{ request('search') }}" 
                               placeholder="Search by name or email..." 
                               class="w-full rounded-lg border-gray-300 focus:border-purple-500 focus:ring focus:ring-purple-200 pl-10">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3">
                            <i class="fas fa-search text-gray-400"></i>
                        </div>
                    </div>
                </div>

                <!-- System Access Level Filter -->
                <div>
                    <label for="role" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-key text-gray-400 mr-1"></i>
                        Access Level
                    </label>
                    <select name="role" id="role" class="w-full rounded-lg border-gray-300 focus:border-purple-500 focus:ring focus:ring-purple-200">
                        <option value="">All Levels</option>
                        <option value="admin" {{ request('role') === 'admin' ? 'selected' : '' }}>🔑 Administrator</option>
                        <option value="staff" {{ request('role') === 'staff' ? 'selected' : '' }}>👤 Staff Member</option>
                        <option value="student" {{ request('role') === 'student' ? 'selected' : '' }}>📖 Member</option>
                    </select>
                </div>

                <!-- Primary Role Filter -->
                <div>
                    <label for="role_id" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-shield-alt text-gray-400 mr-1"></i>
                        Primary Role
                    </label>
                    <select name="role_id" id="role_id" class="w-full rounded-lg border-gray-300 focus:border-purple-500 focus:ring focus:ring-purple-200">
                        <option value="">All Roles</option>
                        @foreach($roles as $role)
                            <option value="{{ $role->id }}" {{ request('role_id') == $role->id ? 'selected' : '' }}>
                                {{ $role->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="flex items-center gap-3 mt-4">
                <button type="submit" class="bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700 text-white px-6 py-2 rounded-lg font-medium shadow-md hover:shadow-lg transition-all duration-200 flex items-center">
                    <i class="fas fa-search mr-2"></i>
                    Apply Filters
                </button>
                @if(request()->hasAny(['search', 'role', 'role_id']))
                <a href="{{ route('users.index') }}" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-6 py-2 rounded-lg font-medium transition-all duration-200 flex items-center">
                    <i class="fas fa-times mr-2"></i>
                    Clear Filters
                </a>
                @endif
                <div class="ml-auto text-sm text-gray-600">
                    <i class="fas fa-info-circle mr-1"></i>
                    Showing {{ $users->count() }} of {{ $users->total() }} users
                </div>
            </div>
        </form>
    </div>

    <!-- Users Table -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden border border-gray-100">
        <div class="px-6 py-4 bg-gradient-to-r from-gray-50 to-gray-100 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-800 flex items-center">
                <i class="fas fa-table text-purple-600 mr-2"></i>
                Users List
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="bg-gradient-to-r from-purple-50 to-blue-50 border-b-2 border-purple-200">
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase tracking-wider">
                            <i class="fas fa-user mr-1"></i> User
                        </th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase tracking-wider">
                            <i class="fas fa-envelope mr-1"></i> Contact
                        </th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase tracking-wider">
                            <i class="fas fa-shield-alt mr-1"></i> Primary Role
                        </th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase tracking-wider">
                            <i class="fas fa-key mr-1"></i> Access Level
                        </th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase tracking-wider">
                            <i class="fas fa-calendar mr-1"></i> Joined
                        </th>
                        <th class="px-6 py-4 text-left text-xs font-bold text-gray-700 uppercase tracking-wider">
                            <i class="fas fa-cog mr-1"></i> Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($users as $user)
                    <tr class="hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 transition-all duration-200">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                @if($user->profile_photo)
                                <div class="flex-shrink-0 h-12 w-12">
                                    <img class="h-12 w-12 rounded-full object-cover ring-2 ring-purple-200" 
                                         src="{{ asset('storage/' . $user->profile_photo) }}" 
                                         alt="{{ $user->name }}">
                                </div>
                                @else
                                <div class="flex-shrink-0 h-12 w-12 rounded-full bg-gradient-to-br from-purple-500 to-blue-500 flex items-center justify-center ring-2 ring-purple-200">
                                    <span class="text-white font-bold text-lg">{{ substr($user->name, 0, 1) }}</span>
                                </div>
                                @endif
                                <div class="ml-4">
                                    <div class="text-sm font-semibold text-gray-900">{{ $user->name }}</div>
                                    @if($user->id === auth()->id())
                                    <span class="text-xs text-purple-600 font-medium">
                                        <i class="fas fa-star mr-1"></i>You
                                    </span>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm text-gray-900 flex items-center">
                                <i class="fas fa-envelope text-gray-400 mr-2"></i>
                                {{ $user->email }}
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            @if($user->role_id && $user->role)
                            <div class="flex items-center">
                                <span class="px-3 py-1 text-xs font-semibold rounded-full bg-gradient-to-r from-green-100 to-green-200 text-green-800 border border-green-300">
                                    <i class="fas fa-shield-alt mr-1"></i>
                                    {{ $user->role->name }}
                                </span>
                            </div>
                            @else
                            <span class="text-xs text-gray-400 italic">
                                <i class="fas fa-minus-circle mr-1"></i>
                                Not assigned
                            </span>
                            @endif
                        </td>
                        <td class="px-6 py-4">
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full
                                {{ $user->role === 'admin' ? 'bg-gradient-to-r from-red-100 to-red-200 text-red-800 border border-red-300' : 
                                   ($user->role === 'staff' ? 'bg-gradient-to-r from-blue-100 to-blue-200 text-blue-800 border border-blue-300' : 
                                   'bg-gradient-to-r from-purple-100 to-purple-200 text-purple-800 border border-purple-300') }}">
                                @if($user->role === 'admin')
                                    <i class="fas fa-user-shield mr-1"></i> Administrator
                                @elseif($user->role === 'staff')
                                    <i class="fas fa-user-tie mr-1"></i> Staff
                                @else
                                    <i class="fas fa-user mr-1"></i> Member
                                @endif
                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">
                            <div class="flex items-center">
                                <i class="fas fa-calendar-alt text-gray-400 mr-2"></i>
                                {{ $user->created_at->format('M d, Y') }}
                            </div>
                            <div class="text-xs text-gray-400 mt-1">
                                {{ $user->created_at->diffForHumans() }}
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex space-x-2">
                                <a href="{{ route('users.show', $user->id) }}" 
                                   class="text-blue-600 hover:text-blue-800 hover:bg-blue-50 p-2 rounded-lg transition-all duration-200"
                                   title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                @if(auth()->user()->role === 'admin' || auth()->id() === $user->id)
                                <a href="{{ route('users.edit', $user->id) }}" 
                                   class="text-purple-600 hover:text-purple-800 hover:bg-purple-50 p-2 rounded-lg transition-all duration-200"
                                   title="Edit User">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @endif
                                
                                @if(auth()->user()->role === 'admin' && auth()->id() !== $user->id)
                                <form action="{{ route('users.destroy', $user->id) }}" method="POST" class="inline" 
                                      onsubmit="return confirm('Are you sure you want to delete {{ $user->name }}? This action cannot be undone.');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="text-red-600 hover:text-red-800 hover:bg-red-50 p-2 rounded-lg transition-all duration-200"
                                            title="Delete User">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center">
                            <div class="flex flex-col items-center justify-center">
                                <i class="fas fa-users text-gray-300 text-5xl mb-4"></i>
                                <p class="text-gray-500 font-medium">No users found</p>
                                <p class="text-gray-400 text-sm mt-1">Try adjusting your search or filters</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        <!-- Enhanced Pagination -->
        @if($users->hasPages())
        <div class="px-6 py-4 bg-gradient-to-r from-gray-50 to-gray-100 border-t border-gray-200">
            <div class="flex flex-col md:flex-row justify-between items-center gap-4">
                <div class="flex items-center gap-2">
                    @if($users->onFirstPage())
                    <span class="px-4 py-2 bg-gray-200 border border-gray-300 rounded-lg text-sm font-medium text-gray-400 cursor-not-allowed flex items-center">
                        <i class="fas fa-chevron-left mr-2"></i>
                        Previous
                    </span>
                    @else
                    <a href="{{ $users->previousPageUrl() }}" class="px-4 py-2 bg-white border border-gray-300 rounded-lg text-sm font-medium text-gray-700 hover:bg-gradient-to-r hover:from-purple-50 hover:to-blue-50 hover:border-purple-300 transition-all duration-200 flex items-center shadow-sm">
                        <i class="fas fa-chevron-left mr-2"></i>
                        Previous
                    </a>
                    @endif
                </div>
                
                <div class="flex items-center gap-4">
                    <div class="text-sm text-gray-700 font-medium bg-white px-4 py-2 rounded-lg border border-gray-200 shadow-sm">
                        <i class="fas fa-file-alt text-purple-600 mr-2"></i>
                        Page <span class="font-bold text-purple-600">{{ $users->currentPage() }}</span> of <span class="font-bold">{{ $users->lastPage() }}</span>
                    </div>
                    <div class="text-xs text-gray-500">
                        ({{ $users->total() }} total users)
                    </div>
                </div>
                
                <div class="flex items-center gap-2">
                    @if($users->hasMorePages())
                    <a href="{{ $users->nextPageUrl() }}" class="px-4 py-2 bg-white border border-gray-300 rounded-lg text-sm font-medium text-gray-700 hover:bg-gradient-to-r hover:from-purple-50 hover:to-blue-50 hover:border-purple-300 transition-all duration-200 flex items-center shadow-sm">
                        Next
                        <i class="fas fa-chevron-right ml-2"></i>
                    </a>
                    @else
                    <span class="px-4 py-2 bg-gray-200 border border-gray-300 rounded-lg text-sm font-medium text-gray-400 cursor-not-allowed flex items-center">
                        Next
                        <i class="fas fa-chevron-right ml-2"></i>
                    </span>
                    @endif
                </div>
            </div>
        </div>
        @endif
    </div>

    <!-- Quick Actions Panel -->
    @if(auth()->user()->role === 'admin')
    <div class="mt-8 bg-gradient-to-r from-blue-50 via-purple-50 to-red-50 rounded-xl shadow-lg p-6 border border-purple-200">
        <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
            <i class="fas fa-bolt text-purple-600 mr-2"></i>
            Quick Actions
        </h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <a href="{{ route('users.create') }}" class="bg-white hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 p-4 rounded-lg border border-gray-200 hover:border-purple-300 transition-all duration-200 shadow-sm hover:shadow-md group">
                <div class="flex items-center">
                    <div class="bg-gradient-to-br from-blue-500 to-purple-500 text-white p-3 rounded-lg group-hover:scale-110 transition-transform duration-200">
                        <i class="fas fa-user-plus text-xl"></i>
                    </div>
                    <div class="ml-4">
                        <h4 class="font-semibold text-gray-800">Add New User</h4>
                        <p class="text-sm text-gray-600">Create a new system user</p>
                    </div>
                </div>
            </a>

            <a href="{{ route('roles.index') }}" class="bg-white hover:bg-gradient-to-r hover:from-purple-50 hover:to-red-50 p-4 rounded-lg border border-gray-200 hover:border-purple-300 transition-all duration-200 shadow-sm hover:shadow-md group">
                <div class="flex items-center">
                    <div class="bg-gradient-to-br from-purple-500 to-red-500 text-white p-3 rounded-lg group-hover:scale-110 transition-transform duration-200">
                        <i class="fas fa-user-shield text-xl"></i>
                    </div>
                    <div class="ml-4">
                        <h4 class="font-semibold text-gray-800">Manage Roles</h4>
                        <p class="text-sm text-gray-600">Configure roles & permissions</p>
                    </div>
                </div>
            </a>

            <a href="{{ route('permissions.index') }}" class="bg-white hover:bg-gradient-to-r hover:from-red-50 hover:to-blue-50 p-4 rounded-lg border border-gray-200 hover:border-purple-300 transition-all duration-200 shadow-sm hover:shadow-md group">
                <div class="flex items-center">
                    <div class="bg-gradient-to-br from-red-500 to-blue-500 text-white p-3 rounded-lg group-hover:scale-110 transition-transform duration-200">
                        <i class="fas fa-shield-alt text-xl"></i>
                    </div>
                    <div class="ml-4">
                        <h4 class="font-semibold text-gray-800">Permissions</h4>
                        <p class="text-sm text-gray-600">View all system permissions</p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    @endif
</x-app-layout>
