<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Create New User') }}
            </h2>
            <x-button href="{{ route('users.index') }}" variant="secondary" icon="fas fa-arrow-left">
                {{ __('Back to Users') }}
            </x-button>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    @if ($errors->any())
                        <div class="mb-4">
                            <div class="font-medium text-red-600">{{ __('Whoops! Something went wrong.') }}</div>

                            <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('users.store') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Name -->
                            <div>
                                <x-label for="name" :value="__('Name')" />
                                <x-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name')" required autofocus />
                            </div>

                            <!-- Email -->
                            <div>
                                <x-label for="email" :value="__('Email')" />
                                <x-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required />
                            </div>

                            <!-- Password -->
                            <div>
                                <x-label for="password" :value="__('Password')" />
                                <x-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="new-password" />
                            </div>

                            <!-- Confirm Password -->
                            <div>
                                <x-label for="password_confirmation" :value="__('Confirm Password')" />
                                <x-input id="password_confirmation" class="block mt-1 w-full" type="password" name="password_confirmation" required />
                            </div>

                            <!-- Profile Photo -->
                            <div class="md:col-span-2">
                                <x-label for="profile_photo" :value="__('Profile Photo (Optional)')" />
                                <input id="profile_photo" type="file" name="profile_photo" class="block mt-1 w-full border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 rounded-md shadow-sm" />
                            </div>
                        </div>

                        <!-- Role & Permissions Section -->
                        <div class="mt-6 p-4 bg-gradient-to-r from-blue-50 via-purple-50 to-red-50 rounded-lg border border-purple-200">
                            <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                                <i class="fas fa-user-shield text-purple-600 mr-2"></i>
                                Role & Permissions Assignment
                            </h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- Primary Role Assignment (New System) -->
                                <div>
                                    <label for="role_id" class="block text-sm font-medium text-gray-700 mb-1">
                                        <i class="fas fa-shield-alt text-blue-600 mr-1"></i>
                                        Primary Role
                                        <span class="text-xs text-green-600 ml-2 px-2 py-0.5 bg-green-100 rounded-full">Recommended</span>
                                    </label>
                                    <select name="role_id" id="role_id" class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500 sm:text-sm">
                                        <option value="">-- Select a Role --</option>
                                        @foreach($roles as $role)
                                            <option value="{{ $role->id }}" {{ old('role_id') == $role->id ? 'selected' : '' }}>
                                                {{ $role->name }} ({{ $role->permissions_count ?? $role->permissions->count() }} permissions)
                                            </option>
                                        @endforeach
                                    </select>
                                    <p class="mt-1 text-xs text-gray-500">
                                        <i class="fas fa-info-circle"></i>
                                        Assign a role with specific permissions for granular access control
                                    </p>
                                    @error('role_id')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <!-- System Access Level (Fallback) -->
                                <div>
                                    <label for="role" class="block text-sm font-medium text-gray-700 mb-1">
                                        <i class="fas fa-key text-gray-600 mr-1"></i>
                                        System Access Level
                                        <span class="text-xs text-red-600 ml-2">*Required</span>
                                    </label>
                                    <select id="role" name="role" required class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                        <option value="">-- Select Access Level --</option>
                                        <option value="admin" {{ old('role') === 'admin' ? 'selected' : '' }}>
                                            🔑 Administrator - Full system access
                                        </option>
                                        <option value="staff" {{ old('role') === 'staff' ? 'selected' : '' }}>
                                            👤 Staff Member - Standard access
                                        </option>
                                        <option value="student" {{ old('role') === 'student' ? 'selected' : '' }}>
                                            📖 Member - Limited access
                                        </option>
                                    </select>
                                    <p class="mt-1 text-xs text-gray-500">
                                        <i class="fas fa-info-circle"></i>
                                        Basic access level (fallback if no primary role assigned)
                                    </p>
                                    @error('role')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>

                            <!-- Helpful Information -->
                            <div class="mt-4 p-3 bg-blue-50 border border-blue-200 rounded">
                                <p class="text-sm text-blue-800">
                                    <i class="fas fa-lightbulb text-blue-600"></i>
                                    <strong>Best Practice:</strong> Assign a Primary Role for better security and granular permission control. 
                                    The System Access Level serves as a fallback and provides basic permissions.
                                </p>
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-6">
                            <x-button type="submit" variant="primary" icon="fas fa-save">
                                {{ __('Create User') }}
                            </x-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
