@extends('components.app-layout')

@section('title', 'Purchase SMS Credits')
@section('subtitle', 'Login or create an account to purchase SMS credits')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-blue-50 via-white to-red-50 py-16 flex items-center justify-center">
    <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <!-- Icon and Header -->
        <div class="mb-10">
            <div class="relative inline-block mb-6">
                <div class="absolute inset-0 bg-gradient-to-r from-blue-600 to-red-600 rounded-full blur-2xl opacity-30 animate-pulse"></div>
                <div class="relative w-32 h-32 bg-gradient-to-r from-blue-600 to-red-600 rounded-full flex items-center justify-center shadow-2xl">
                    <i class="fas fa-sms text-white text-5xl"></i>
                </div>
            </div>
            <h1 class="text-5xl font-bold bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 bg-clip-text text-transparent mb-4">Purchase SMS Credits</h1>
        </div>

        <!-- Redirect Card -->
        <div class="bg-white rounded-3xl shadow-2xl p-10 border-2 border-gray-100">
            <div class="mb-8">
                <div class="w-20 h-20 bg-gradient-to-r from-blue-100 to-red-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-external-link-alt text-4xl bg-gradient-to-r from-blue-600 to-red-600 bg-clip-text text-transparent"></i>
                </div>
                <h2 class="text-3xl font-bold text-gray-900 mb-4">Visit Our SMS Platform</h2>
                <p class="text-gray-600 text-lg mb-8">To purchase SMS credits, please visit our partner platform where you can login or create an account.</p>
            </div>

            <!-- Platform Link Button -->
            <a href="https://sms.pastechsolutions.com/" target="_blank" 
               class="inline-flex items-center justify-center px-10 py-5 bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 text-white font-bold text-xl rounded-2xl hover:from-blue-700 hover:via-purple-700 hover:to-red-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105 hover:-translate-y-1 relative overflow-hidden group">
                <span class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 transition-opacity"></span>
                <span class="relative z-10 flex items-center">
                    <i class="fas fa-globe mr-3"></i>
                    Visit SMS Platform
                    <i class="fas fa-arrow-right ml-3"></i>
                </span>
            </a>

            <!-- URL Display -->
            <div class="mt-6 p-4 bg-gradient-to-r from-blue-50 to-red-50 rounded-2xl border border-blue-200">
                <p class="text-sm text-gray-600 mb-2 font-semibold">Platform URL:</p>
                <div class="flex items-center justify-center">
                    <code class="text-blue-600 font-mono text-lg">https://sms.pastechsolutions.com/</code>
                    <button onclick="copyUrl()" class="ml-3 px-3 py-1 bg-blue-600 text-white text-sm rounded-lg hover:bg-blue-700 transition">
                        <i class="fas fa-copy mr-1"></i>
                        Copy
                    </button>
                </div>
            </div>

            <!-- Features List -->
            <div class="mt-8 grid grid-cols-1 md:grid-cols-2 gap-4 text-left">
                <div class="flex items-start space-x-3">
                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-check text-green-600"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-gray-900">Easy Registration</h4>
                        <p class="text-sm text-gray-600">Quick account setup process</p>
                    </div>
                </div>
                <div class="flex items-start space-x-3">
                    <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-shield-alt text-blue-600"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-gray-900">Secure Payment</h4>
                        <p class="text-sm text-gray-600">SSL encrypted transactions</p>
                    </div>
                </div>
                <div class="flex items-start space-x-3">
                    <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-bolt text-purple-600"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-gray-900">Instant Delivery</h4>
                        <p class="text-sm text-gray-600">Credits added immediately</p>
                    </div>
                </div>
                <div class="flex items-start space-x-3">
                    <div class="w-8 h-8 bg-orange-100 rounded-lg flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-headset text-orange-600"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-gray-900">24/7 Support</h4>
                        <p class="text-sm text-gray-600">Always here to help</p>
                    </div>
                </div>
            </div>

            <!-- Help Text -->
            <div class="mt-8 p-4 bg-yellow-50 border-l-4 border-yellow-400 rounded-r-xl">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-info-circle text-yellow-600"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-yellow-800">
                            <strong>Note:</strong> After purchasing credits on the platform, they will be automatically synced with your church management system.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyUrl() {
    const url = 'https://sms.pastechsolutions.com/';
    navigator.clipboard.writeText(url).then(function() {
        const btn = event.target.closest('button');
        const originalHtml = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check mr-1"></i>Copied!';
        btn.classList.remove('bg-blue-600', 'hover:bg-blue-700');
        btn.classList.add('bg-green-600');
        
        setTimeout(() => {
            btn.innerHTML = originalHtml;
            btn.classList.remove('bg-green-600');
            btn.classList.add('bg-blue-600', 'hover:bg-blue-700');
        }, 2000);
    }).catch(function(err) {
        alert('Failed to copy URL. Please copy manually.');
    });
}
</script>
@endsection
