<x-app-layout>
    <div class="min-h-screen bg-gradient-to-br from-gray-50 via-blue-50 to-red-50 py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="mb-8">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="flex items-center space-x-4">
                            <a href="{{ route('roles.index') }}" class="text-gray-600 hover:text-gray-900">
                                <i class="fas fa-arrow-left text-xl"></i>
                            </a>
                            <div>
                                <h1 class="text-3xl font-bold bg-gradient-to-r from-blue-600 via-purple-600 to-red-600 bg-clip-text text-transparent">
                                    {{ $role->name }}
                                </h1>
                                <p class="mt-1 text-sm text-gray-600">Role Details & Permissions</p>
                            </div>
                        </div>
                    </div>
                    <div class="flex items-center space-x-3">
                        <a href="{{ route('roles.edit', $role) }}" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 text-white font-semibold rounded-xl hover:shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
                            <i class="fas fa-edit mr-2"></i>
                            Edit Role
                        </a>
                        @if($role->users->count() == 0)
                            <form action="{{ route('roles.destroy', $role) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this role?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-red-600 to-red-700 text-white font-semibold rounded-xl hover:shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
                                    <i class="fas fa-trash mr-2"></i>
                                    Delete Role
                                </button>
                            </form>
                        @endif
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Left Column - Role Details -->
                <div class="lg:col-span-1 space-y-6">
                    <!-- Role Information Card -->
                    <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
                        <h2 class="text-lg font-semibold text-gray-900 mb-4">
                            <i class="fas fa-info-circle text-blue-600 mr-2"></i>
                            Role Information
                        </h2>
                        
                        <div class="space-y-4">
                            <div>
                                <label class="text-sm font-medium text-gray-600">Role Name</label>
                                <p class="text-gray-900 font-semibold mt-1">{{ $role->name }}</p>
                            </div>

                            <div>
                                <label class="text-sm font-medium text-gray-600">Slug</label>
                                <p class="text-gray-700 mt-1">
                                    <code class="px-2 py-1 bg-gray-100 rounded text-sm">{{ $role->slug }}</code>
                                </p>
                            </div>

                            <div>
                                <label class="text-sm font-medium text-gray-600">Description</label>
                                <p class="text-gray-700 mt-1">{{ $role->description ?? 'No description provided' }}</p>
                            </div>

                            <div>
                                <label class="text-sm font-medium text-gray-600">Status</label>
                                <div class="mt-1">
                                    @if($role->is_active)
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                                            <i class="fas fa-check-circle mr-1"></i>
                                            Active
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-100 text-gray-800">
                                            <i class="fas fa-times-circle mr-1"></i>
                                            Inactive
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div>
                                <label class="text-sm font-medium text-gray-600">Created</label>
                                <p class="text-gray-700 mt-1">{{ $role->created_at->format('M d, Y') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Statistics Card -->
                    <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
                        <h2 class="text-lg font-semibold text-gray-900 mb-4">
                            <i class="fas fa-chart-bar text-purple-600 mr-2"></i>
                            Statistics
                        </h2>
                        
                        <div class="space-y-4">
                            <div class="flex items-center justify-between p-3 bg-purple-50 rounded-lg">
                                <div class="flex items-center">
                                    <i class="fas fa-key text-purple-600 mr-3"></i>
                                    <span class="text-sm font-medium text-gray-700">Permissions</span>
                                </div>
                                <span class="text-lg font-bold text-purple-600">{{ $role->permissions->count() }}</span>
                            </div>

                            <div class="flex items-center justify-between p-3 bg-blue-50 rounded-lg">
                                <div class="flex items-center">
                                    <i class="fas fa-users text-blue-600 mr-3"></i>
                                    <span class="text-sm font-medium text-gray-700">Assigned Users</span>
                                </div>
                                <span class="text-lg font-bold text-blue-600">{{ $role->users->count() }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Permissions & Users -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Permissions Card -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                        <div class="px-6 py-4 bg-gradient-to-r from-purple-50 to-purple-100 border-b border-purple-200">
                            <h2 class="text-lg font-semibold text-gray-900">
                                <i class="fas fa-key text-purple-600 mr-2"></i>
                                Assigned Permissions ({{ $role->permissions->count() }})
                            </h2>
                        </div>

                        <div class="p-6">
                            @if($permissionsByModule->count() > 0)
                                <div class="space-y-6">
                                    @foreach($permissionsByModule as $module => $permissions)
                                        <div>
                                            <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider mb-3 flex items-center">
                                                <span class="w-2 h-2 bg-purple-600 rounded-full mr-2"></span>
                                                {{ ucwords(str_replace('_', ' ', $module)) }}
                                            </h3>
                                            <div class="grid grid-cols-1 md:grid-cols-2 gap-2">
                                                @foreach($permissions as $permission)
                                                    <div class="flex items-center p-3 bg-gray-50 rounded-lg border border-gray-200">
                                                        <i class="fas fa-check-circle text-green-500 mr-3"></i>
                                                        <div>
                                                            <div class="text-sm font-medium text-gray-900">{{ $permission->name }}</div>
                                                            <div class="text-xs text-gray-500">{{ $permission->slug }}</div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-12">
                                    <i class="fas fa-key text-gray-300 text-5xl mb-4"></i>
                                    <p class="text-gray-500 text-lg font-medium">No permissions assigned</p>
                                    <p class="text-gray-400 text-sm mt-2">Edit this role to assign permissions</p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Assigned Users Card -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                        <div class="px-6 py-4 bg-gradient-to-r from-blue-50 to-blue-100 border-b border-blue-200">
                            <h2 class="text-lg font-semibold text-gray-900">
                                <i class="fas fa-users text-blue-600 mr-2"></i>
                                Assigned Users ({{ $role->users->count() }})
                            </h2>
                        </div>

                        <div class="p-6">
                            @if($role->users->count() > 0)
                                <div class="overflow-x-auto">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            @foreach($role->users as $user)
                                                <tr class="hover:bg-gray-50">
                                                    <td class="px-4 py-3 whitespace-nowrap">
                                                        <div class="flex items-center">
                                                            <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center mr-3">
                                                                <span class="text-white text-xs font-semibold">{{ substr($user->name, 0, 1) }}</span>
                                                            </div>
                                                            <div class="text-sm font-medium text-gray-900">{{ $user->name }}</div>
                                                        </div>
                                                    </td>
                                                    <td class="px-4 py-3 whitespace-nowrap">
                                                        <div class="text-sm text-gray-700">{{ $user->email }}</div>
                                                    </td>
                                                    <td class="px-4 py-3 whitespace-nowrap">
                                                        @if($user->is_active)
                                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                                Active
                                                            </span>
                                                        @else
                                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                                Inactive
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td class="px-4 py-3 whitespace-nowrap text-sm">
                                                        <a href="{{ route('users.show', $user) }}" class="text-blue-600 hover:text-blue-900">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="text-center py-12">
                                    <i class="fas fa-users text-gray-300 text-5xl mb-4"></i>
                                    <p class="text-gray-500 text-lg font-medium">No users assigned</p>
                                    <p class="text-gray-400 text-sm mt-2">Assign users to this role from the user management page</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
