@extends('components.public-layout')

@section('title', $organizationSettings['name'] . ' - Programs & Events')

@section('content')
<!-- Modern Hero Section with Dynamic Branding -->
<div class="relative min-h-screen bg-gradient-to-br from-slate-900 via-blue-900 to-indigo-900 overflow-hidden">
    <!-- Animated Background Elements -->
    <div class="absolute inset-0">
        <div class="absolute top-0 left-0 w-full h-full bg-gradient-to-br from-blue-600/10 via-purple-600/5 to-transparent"></div>
        <div class="absolute top-20 right-20 w-72 h-72 bg-blue-500/10 rounded-full blur-3xl animate-pulse"></div>
        <div class="absolute bottom-20 left-20 w-96 h-96 bg-purple-500/10 rounded-full blur-3xl animate-pulse delay-1000"></div>
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-gradient-to-r from-blue-500/5 to-purple-500/5 rounded-full blur-3xl"></div>
    </div>

    <!-- Navigation Header -->
    <nav class="relative z-10 px-6 py-4 bg-white/5 backdrop-blur-md border-b border-white/10">
        <div class="max-w-7xl mx-auto flex items-center justify-between">
            <!-- Dynamic Organization Logo and Name -->
            <div class="flex items-center space-x-4">
                <div class="relative">
                    @if($organizationSettings['logo'])
                        <div class="w-14 h-14 rounded-2xl overflow-hidden bg-white/10 backdrop-blur-sm border border-white/20 p-1">
                            <img src="{{ asset('storage/' . $organizationSettings['logo']) }}" alt="{{ $organizationSettings['name'] }}" class="w-full h-full object-cover rounded-xl">
                        </div>
                    @else
                        <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-purple-600 rounded-2xl flex items-center justify-center shadow-lg">
                            <i class="fas fa-church text-white text-xl"></i>
                        </div>
                    @endif
                    <div class="absolute -top-1 -right-1 w-4 h-4 bg-green-400 rounded-full border-2 border-white animate-pulse"></div>
                </div>
                <div>
                    <h1 class="text-xl font-bold text-white">{{ $organizationSettings['name'] }}</h1>
                    <p class="text-blue-200 text-sm">{{ $organizationSettings['slogan'] }}</p>
                </div>
            </div>
            
            <!-- Navigation Links -->
            <div class="hidden lg:flex items-center space-x-8">
                <a href="#programs" class="text-white/80 hover:text-white transition-all duration-300 font-medium hover:scale-105">Programs</a>
                <a href="#events" class="text-white/80 hover:text-white transition-all duration-300 font-medium hover:scale-105">Events</a>
                <a href="#announcements" class="text-white/80 hover:text-white transition-all duration-300 font-medium hover:scale-105">News</a>
                <a href="#contact" class="text-white/80 hover:text-white transition-all duration-300 font-medium hover:scale-105">Contact</a>
                <button class="bg-gradient-to-r from-blue-500 to-purple-600 text-white px-6 py-2 rounded-full font-medium hover:shadow-lg hover:scale-105 transition-all duration-300">
                    Join Us
                </button>
            </div>

            <!-- Mobile Menu Button -->
            <button class="lg:hidden text-white p-2">
                <i class="fas fa-bars text-xl"></i>
            </button>
        </div>
    </nav>

    <!-- Hero Content -->
    <div class="relative z-10 px-6 py-20">
        <div class="max-w-6xl mx-auto text-center">
            <!-- Floating Icon -->
            <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-blue-500/20 to-purple-600/20 backdrop-blur-sm rounded-3xl mb-8 border border-white/20 shadow-2xl animate-bounce">
                <i class="fas fa-calendar-alt text-3xl text-white"></i>
            </div>
            
            <!-- Main Title -->
            <h2 class="text-5xl md:text-7xl font-bold text-white mb-6 leading-tight">
                <span class="bg-gradient-to-r from-blue-400 via-purple-400 to-pink-400 bg-clip-text text-transparent">Programs</span>
                <span class="text-white">&</span>
                <span class="bg-gradient-to-r from-pink-400 via-red-400 to-orange-400 bg-clip-text text-transparent">Events</span>
            </h2>
            
            <!-- Subtitle -->
            <p class="text-xl md:text-2xl text-white/80 mb-12 max-w-4xl mx-auto leading-relaxed">
                Discover transformative spiritual programs, community events, and fellowship opportunities that strengthen faith and build lasting connections. 
                        Open to all members and visitors of the Presbyterian Church of Ghana.
                    </p>
                    
                    <!-- Enhanced PCG Stats -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 max-w-4xl mx-auto">
                        <div class="bg-white bg-opacity-15 backdrop-blur-md rounded-2xl px-6 py-6 border border-white border-opacity-20 hover:bg-opacity-20 transition-all duration-300">
                            <div class="text-4xl font-bold text-white mb-2">{{ $programs->count() }}</div>
                            <div class="text-sm text-white opacity-80">Active Programs</div>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-md rounded-2xl px-6 py-6 border border-white border-opacity-20 hover:bg-opacity-20 transition-all duration-300">
                            <div class="text-4xl font-bold text-white mb-2">{{ \App\Models\Family::count() }}</div>
                            <div class="text-sm text-white opacity-80">Families</div>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-md rounded-2xl px-6 py-6 border border-white border-opacity-20 hover:bg-opacity-20 transition-all duration-300">
                            <div class="text-4xl font-bold text-white mb-2">{{ \App\Models\Member::count() }}</div>
                            <div class="text-sm text-white opacity-80">Church Members</div>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-md rounded-2xl px-6 py-6 border border-white border-opacity-20 hover:bg-opacity-20 transition-all duration-300">
                            <div class="text-4xl font-bold text-white mb-2">{{ \App\Models\Event::where('start_datetime', '>=', now())->count() }}</div>
                            <div class="text-sm text-white opacity-80">Upcoming Events</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-6 py-16">
        
        <!-- Announcements Section -->
        <section id="announcements" class="mb-20">
            <div class="text-center mb-16">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-blue-500 via-purple-500 to-pink-500 rounded-3xl mb-8 shadow-2xl animate-pulse">
                    <i class="fas fa-bullhorn text-white text-3xl"></i>
                </div>
                <h2 class="text-5xl md:text-6xl font-bold mb-6">
                    <span class="bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 bg-clip-text text-transparent">Church Announcements</span>
                </h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto leading-relaxed">Stay informed with the latest news, updates, and important announcements from our church community</p>
                <div class="w-24 h-1 bg-gradient-to-r from-blue-500 to-purple-500 mx-auto mt-6 rounded-full"></div>
            </div>

            @php
                $featuredAnnouncements = \App\Models\Announcement::where('status', 'published')
                    ->where('publish_date', '<=', now())
                    ->where(function($query) {
                        $query->whereNull('expire_date')
                              ->orWhere('expire_date', '>', now());
                    })
                    ->where('display_on_website', true)
                    ->orderBy('priority', 'desc')
                    ->orderBy('publish_date', 'desc')
                    ->take(6)
                    ->get();
            @endphp

            @if($featuredAnnouncements->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    @foreach($featuredAnnouncements as $announcement)
                        <div class="group bg-white rounded-3xl shadow-xl overflow-hidden hover:shadow-2xl transition-all duration-500 transform hover:-translate-y-2 hover:rotate-1 border border-gray-100">
                            
                            <!-- Announcement Image/Flyer -->
                            @if($announcement->image_path)
                                <div class="relative h-56 overflow-hidden">
                                    <img src="{{ asset('storage/' . $announcement->image_path) }}" alt="{{ $announcement->title }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                                    <div class="absolute top-4 right-4 bg-white/90 backdrop-blur-sm rounded-full p-2 opacity-0 group-hover:opacity-100 transition-all duration-300 transform translate-x-4 group-hover:translate-x-0">
                                        <i class="fas fa-eye text-blue-600"></i>
                                    </div>
                                    
                                    <!-- Priority Badge -->
                                    @if($announcement->priority === 'urgent')
                                        <div class="absolute top-4 left-4 bg-red-500 text-white px-3 py-1 rounded-full text-xs font-bold animate-pulse">
                                            <i class="fas fa-exclamation-triangle mr-1"></i>URGENT
                                        </div>
                                    @elseif($announcement->priority === 'high')
                                        <div class="absolute top-4 left-4 bg-orange-500 text-white px-3 py-1 rounded-full text-xs font-bold">
                                            <i class="fas fa-flag mr-1"></i>HIGH
                                        </div>
                                    @endif
                                </div>
                            @else
                                <div class="relative h-56 bg-gradient-to-br from-blue-500 via-purple-500 to-pink-500 flex items-center justify-center">
                                    <i class="fas fa-bullhorn text-6xl text-white/80"></i>
                                    <div class="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent"></div>
                                    
                                    <!-- Priority Badge -->
                                    @if($announcement->priority === 'urgent')
                                        <div class="absolute top-4 left-4 bg-red-500 text-white px-3 py-1 rounded-full text-xs font-bold animate-pulse">
                                            <i class="fas fa-exclamation-triangle mr-1"></i>URGENT
                                        </div>
                                    @elseif($announcement->priority === 'high')
                                        <div class="absolute top-4 left-4 bg-orange-500 text-white px-3 py-1 rounded-full text-xs font-bold">
                                            <i class="fas fa-flag mr-1"></i>HIGH
                                        </div>
                                    @endif
                                </div>
                            @endif
                            
                            <!-- Announcement Header -->
                            @php
                                $headerColors = [
                                    'urgent' => 'from-red-800 via-red-600 to-red-400',
                                    'event' => 'from-blue-700 via-blue-500 to-blue-300',
                                    'prayer_request' => 'from-purple-800 via-purple-600 to-purple-400',
                                    'celebration' => 'from-pink-700 via-pink-500 to-pink-300',
                                    'ministry' => 'from-indigo-800 via-indigo-600 to-indigo-400',
                                    'general' => 'from-blue-600 via-blue-500 to-blue-400'
                                ];
                                $headerColor = $headerColors[$announcement->type] ?? $headerColors['general'];
                            @endphp
                            <div class="relative bg-gradient-to-r {{ $headerColor }} px-6 py-6">
                                <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full transform translate-x-16 -translate-y-16"></div>
                                <div class="relative">
                                    <div class="flex justify-between items-start mb-3">
                                        <span class="inline-flex px-4 py-2 rounded-2xl text-sm font-bold bg-white/20 backdrop-blur-sm text-white border border-white/30">
                                            {{ ucfirst(str_replace('_', ' ', $announcement->type)) }}
                                        </span>
                                        <div class="text-right bg-white/20 backdrop-blur-sm rounded-2xl px-3 py-1 border border-white/30">
                                            <div class="text-xs text-white/80">{{ $announcement->publish_date->format('M j') }}</div>
                                        </div>
                                    </div>
                                    <h3 class="text-2xl font-bold text-white leading-tight">{{ $announcement->title }}</h3>
                                </div>
                            </div>
                            
                            <div class="p-8">
                                <p class="text-gray-600 mb-6 leading-relaxed text-lg">{{ Str::limit($announcement->content, 150) }}</p>
                                
                                <!-- Announcement Details -->
                                <div class="space-y-4 mb-8">
                                    <div class="flex items-center text-gray-700 group">
                                        <div class="w-10 h-10 rounded-2xl bg-gradient-to-br from-blue-500 to-purple-500 flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                            <i class="fas fa-calendar-alt text-white"></i>
                                        </div>
                                        <span class="ml-4 font-medium">Published {{ $announcement->publish_date->format('M j, Y') }}</span>
                                    </div>
                                    
                                    @if($announcement->expire_date)
                                        <div class="flex items-center text-gray-700 group">
                                            <div class="w-10 h-10 rounded-2xl bg-gradient-to-br from-orange-500 to-red-500 flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                                <i class="fas fa-clock text-white"></i>
                                            </div>
                                            <span class="ml-4 font-medium">Expires {{ $announcement->expire_date->format('M j, Y') }}</span>
                                        </div>
                                    @endif
                                    
                                    @if($announcement->target_audience && count($announcement->target_audience) > 0)
                                        <div class="flex items-center text-gray-700 group">
                                            <div class="w-10 h-10 rounded-2xl bg-gradient-to-br from-purple-500 to-pink-500 flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                                <i class="fas fa-users text-white"></i>
                                            </div>
                                            <span class="ml-4 font-medium">For {{ implode(', ', array_map('ucfirst', array_slice($announcement->target_audience, 0, 2))) }}{{ count($announcement->target_audience) > 2 ? ' +' . (count($announcement->target_audience) - 2) . ' more' : '' }}</span>
                                        </div>
                                    @endif
                                </div>

                                <!-- Attachment indicator -->
                                @if($announcement->attachment_path)
                                    <div class="mb-6">
                                        <div class="bg-gradient-to-r from-gray-50 to-blue-50 rounded-2xl p-4 border border-gray-100">
                                            <div class="flex items-center text-blue-600">
                                                <i class="fas fa-paperclip mr-2"></i>
                                                <span class="text-sm font-medium">Attachment Available</span>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                
                                <!-- Action Buttons -->
                                <div class="flex flex-col sm:flex-row gap-4">
                                    <a href="{{ route('announcements.show', $announcement) }}" 
                                       class="group flex-1 bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 text-white px-6 py-4 rounded-2xl font-bold hover:shadow-2xl transition-all duration-300 text-center transform hover:scale-105 flex items-center justify-center space-x-2">
                                        <i class="fas fa-info-circle group-hover:animate-pulse"></i>
                                        <span>Read Full Announcement</span>
                                        <i class="fas fa-arrow-right group-hover:translate-x-1 transition-transform"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- View All Announcements Button -->
                <div class="text-center mt-12">
                    <a href="{{ route('announcements.index') }}" 
                       class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 text-white font-bold rounded-2xl hover:shadow-2xl transition-all duration-300 transform hover:scale-105 space-x-3">
                        <i class="fas fa-list"></i>
                        <span>View All Announcements</span>
                        <i class="fas fa-external-link-alt"></i>
                    </a>
                </div>
            @else
                <div class="bg-white rounded-3xl shadow-lg border border-gray-100 p-16 text-center">
                    <div class="max-w-md mx-auto">
                        <div class="w-24 h-24 bg-gradient-to-r from-blue-600 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="fas fa-bullhorn text-white text-3xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-gray-900 mb-4">No Announcements Available</h3>
                        <p class="text-gray-600 leading-relaxed mb-8">
                            We currently don't have any active announcements to display. 
                            Check back soon for the latest updates and news from our church community.
                        </p>
                        <div class="space-y-4">
                            <a href="{{ route('announcements.index') }}" 
                               class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-blue-600 to-purple-600 text-white font-medium rounded-xl hover:from-blue-700 hover:to-purple-700 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:-translate-y-1">
                                <i class="fas fa-bullhorn mr-3"></i>
                                View All Announcements
                            </a>
                        </div>
                    </div>
                </div>
            @endif
        </section>
        
        <!-- Upcoming Events Section -->
        <section id="events" class="mb-20">
            <div class="text-center mb-16">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-purple-500 via-pink-500 to-red-500 rounded-3xl mb-8 shadow-2xl animate-pulse">
                    <i class="fas fa-calendar-day text-white text-3xl"></i>
                </div>
                <h2 class="text-5xl md:text-6xl font-bold mb-6">
                    <span class="bg-gradient-to-r from-purple-600 via-pink-600 to-red-600 bg-clip-text text-transparent">Upcoming Events</span>
                </h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto leading-relaxed">Stay connected with our vibrant church community through exciting events, fellowship activities, and spiritual gatherings</p>
                <div class="w-24 h-1 bg-gradient-to-r from-purple-500 to-pink-500 mx-auto mt-6 rounded-full"></div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @php
                    $upcomingEvents = \App\Models\Event::where('start_datetime', '>=', now())->orderBy('start_datetime')->take(6)->get();
                @endphp
                
                @forelse($upcomingEvents as $event)
                    <div class="group bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-500 overflow-hidden border border-gray-100 transform hover:-translate-y-2 hover:rotate-1">
                        <div class="relative bg-gradient-to-r from-purple-600 via-pink-600 to-red-600 px-6 py-6">
                            <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full transform translate-x-16 -translate-y-16"></div>
                            <div class="relative">
                                <h3 class="text-xl font-bold text-white mb-2 leading-tight">{{ $event->title }}</h3>
                                <p class="text-white/80 text-sm flex items-center">
                                    <i class="fas fa-calendar mr-2"></i>
                                    {{ $event->start_datetime->format('M j, Y') }} at {{ $event->start_datetime->format('g:i A') }}
                                </p>
                            </div>
                        </div>
                        <div class="p-6">
                            <p class="text-gray-600 mb-4 leading-relaxed">{{ Str::limit($event->description, 120) }}</p>
                            <div class="flex items-center text-gray-500 text-sm mb-4">
                                <div class="w-8 h-8 rounded-lg bg-gradient-to-br from-purple-500 to-pink-500 flex items-center justify-center mr-3">
                                    <i class="fas fa-map-marker-alt text-white text-xs"></i>
                                </div>
                                <span class="font-medium">{{ $event->location ?? 'Church Premises' }}</span>
                            </div>
                            <button class="w-full bg-gradient-to-r from-purple-500 to-pink-500 text-white py-3 rounded-2xl font-bold hover:shadow-lg transition-all duration-300 transform hover:scale-105">
                                Learn More
                            </button>
                        </div>
                    </div>
                @empty
                    <div class="col-span-full bg-white rounded-2xl shadow-lg p-12 text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-blue-600 to-blue-400 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-calendar-plus text-white text-xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-2">No Upcoming Events</h3>
                        <p class="text-gray-600">Check back soon for exciting church events and activities.</p>
                    </div>
                @endforelse
            </div>
        </section>

   
        
        <!-- Members Showcase Section -->
        <section id="members" class="mb-16">
            <div class="text-center mb-12">
                <div class="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-br from-blue-900 to-blue-700 rounded-2xl mb-6">
                    <i class="fas fa-users text-white text-2xl"></i>
                </div>
                <h2 class="text-4xl font-bold text-gray-900 mb-4">Our Church Family</h2>
                <p class="text-xl text-gray-600 max-w-2xl mx-auto">Meet some of our dedicated church members and leaders</p>
            </div>

            <!-- Search and Filter Section -->
            <div class="max-w-4xl mx-auto mb-8">
                <form method="GET" action="{{ route('programs.index') }}" id="memberSearchForm" class="bg-white rounded-3xl shadow-xl p-6 border border-gray-100">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <!-- Search Input -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-bold text-gray-700 mb-2">
                                <i class="fas fa-search text-blue-600 mr-2"></i>
                                Search by Name
                            </label>
                            <input type="text" 
                                   name="search" 
                                   id="searchInput"
                                   value="{{ request('search') }}"
                                   placeholder="Enter member name..."
                                   class="w-full px-4 py-3 rounded-2xl border-2 border-gray-200 focus:border-blue-500 focus:ring-2 focus:ring-blue-200 transition-all duration-300">
                        </div>

                        <!-- PCG Year Group Filter -->
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">
                                <i class="fas fa-users text-purple-600 mr-2"></i>
                                Year Group
                            </label>
                            <select name="age_group" 
                                    id="ageGroupSelect"
                                    class="w-full px-4 py-3 rounded-2xl border-2 border-gray-200 focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition-all duration-300">
                                <option value="">All Year Groups</option>
                                @foreach($yearGroups as $group)
                                    <option value="{{ $group->id }}" {{ request('age_group') == $group->id ? 'selected' : '' }}>
                                        {{ $group->name }} ({{ $group->abbreviation }}) - {{ $group->min_age }}-{{ $group->max_age == 999 ? '∞' : $group->max_age }} yrs
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="flex flex-wrap gap-3 mt-4">
                        <button type="submit" 
                                class="flex-1 md:flex-none bg-gradient-to-r from-blue-600 to-purple-600 text-white px-8 py-3 rounded-2xl font-bold hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                            <i class="fas fa-filter mr-2"></i>
                            Apply Filters
                        </button>
                        
                        @if(request('search') || request('age_group'))
                            <button type="button" 
                                    onclick="clearFilters()"
                                    class="flex-1 md:flex-none bg-gradient-to-r from-red-500 to-pink-500 text-white px-8 py-3 rounded-2xl font-bold hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                                <i class="fas fa-times mr-2"></i>
                                Clear Filters
                            </button>
                        @endif
                    </div>

                    @if($isFiltered)
                        <div class="mt-4 p-4 bg-blue-50 rounded-2xl border-2 border-blue-200">
                            <p class="text-blue-800 font-medium">
                                <i class="fas fa-info-circle mr-2"></i>
                                Showing {{ $featuredMembers->total() }} member(s) matching your search criteria
                            </p>
                        </div>
                    @endif
                </form>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                @forelse($featuredMembers as $member)
                    <div class="bg-white rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden border border-gray-100 group">
                        <div class="relative">
                            @if($member->photo_path)
                                <img src="{{ asset('storage/' . $member->photo_path) }}" alt="{{ $member->first_name }}" class="w-full h-48 object-cover">
                            @else
                                <div class="w-full h-48 bg-gradient-to-br from-blue-600 to-blue-400 flex items-center justify-center">
                                    <i class="fas fa-user text-white text-4xl"></i>
                                </div>
                            @endif
                            <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        </div>
                        <div class="p-6">
                            <h3 class="text-lg font-bold text-gray-900 mb-3">{{ $member->full_name }}</h3>
                            <div class="space-y-2">
                                <p class="text-gray-700 text-sm flex items-center">
                                    <i class="fas fa-user-tag text-blue-600 mr-2 w-4"></i>
                                    {{ ucfirst($member->membership_type) }} Member
                                </p>
                                @if($member->occupation)
                                    <p class="text-gray-600 text-sm flex items-center">
                                        <i class="fas fa-briefcase text-purple-600 mr-2 w-4"></i>
                                        {{ Str::limit($member->occupation, 30) }}
                                    </p>
                                @endif
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-span-full bg-white rounded-2xl shadow-lg p-12 text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-blue-600 to-blue-400 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-user-plus text-white text-xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-2">
                            @if($isFiltered)
                                No Members Found
                            @else
                                Growing Church Family
                            @endif
                        </h3>
                        <p class="text-gray-600">
                            @if($isFiltered)
                                No members match your search criteria. Try adjusting your filters.
                            @else
                                Our church community is growing. Join us in fellowship and worship.
                            @endif
                        </p>
                    </div>
                @endforelse
            </div>

            <!-- Pagination -->
            @if($isFiltered && $featuredMembers->hasPages())
                <div class="mt-8 flex justify-center">
                    <div class="bg-white rounded-2xl shadow-lg px-6 py-4 border border-gray-100">
                        {{ $featuredMembers->links() }}
                    </div>
                </div>
            @endif
        </section>
    </div>

    <!-- Modern Footer with Dynamic Branding -->
    <footer class="relative bg-gradient-to-br from-slate-900 via-blue-900 to-indigo-900 text-white overflow-hidden">
        <!-- Animated Background Elements -->
        <div class="absolute inset-0">
            <div class="absolute top-0 left-0 w-full h-full bg-gradient-to-br from-blue-600/10 via-purple-600/5 to-transparent"></div>
            <div class="absolute top-20 right-20 w-96 h-96 bg-blue-500/10 rounded-full blur-3xl animate-pulse"></div>
            <div class="absolute bottom-20 left-20 w-72 h-72 bg-purple-500/10 rounded-full blur-3xl animate-pulse delay-1000"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-[800px] h-[800px] bg-gradient-to-r from-blue-500/5 to-purple-500/5 rounded-full blur-3xl"></div>
        </div>
        
        <div class="relative max-w-7xl mx-auto px-6 py-20">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-16">
                <!-- Dynamic Church Information -->
                <div class="lg:col-span-1">
                    <div class="flex items-center space-x-4 mb-8">
                        <div class="relative">
                            @if($organizationSettings['logo'])
                                <div class="w-16 h-16 rounded-2xl overflow-hidden bg-white/10 backdrop-blur-sm border border-white/20 p-1">
                                    <img src="{{ asset('storage/' . $organizationSettings['logo']) }}" alt="{{ $organizationSettings['name'] }}" class="w-full h-full object-cover rounded-xl">
                                </div>
                            @else
                                <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-purple-600 rounded-2xl flex items-center justify-center shadow-2xl">
                                    <i class="fas fa-church text-white text-2xl"></i>
                                </div>
                            @endif
                            <div class="absolute -top-1 -right-1 w-5 h-5 bg-green-400 rounded-full border-2 border-white animate-pulse"></div>
                        </div>
                        <div>
                            <h3 class="text-2xl font-bold text-white">{{ $organizationSettings['name'] }}</h3>
                            <p class="text-blue-200">{{ $organizationSettings['slogan'] }}</p>
                        </div>
                    </div>
                    <p class="text-white/80 leading-relaxed mb-8 text-lg">
                        {{ $organizationSettings['name'] }} is committed to spreading the Gospel of Jesus Christ, 
                        nurturing spiritual growth, and serving our community with love and dedication.
                    </p>
                    
                    <!-- Social Media Links -->
                    <div class="flex space-x-4 mb-8">
                        <a href="#" class="group w-12 h-12 bg-white/10 backdrop-blur-sm rounded-2xl flex items-center justify-center hover:bg-white/20 transition-all duration-300 border border-white/20 hover:scale-110">
                            <i class="fab fa-facebook text-white group-hover:text-blue-300"></i>
                        </a>
                        <a href="#" class="group w-12 h-12 bg-white/10 backdrop-blur-sm rounded-2xl flex items-center justify-center hover:bg-white/20 transition-all duration-300 border border-white/20 hover:scale-110">
                            <i class="fab fa-twitter text-white group-hover:text-blue-300"></i>
                        </a>
                        <a href="#" class="group w-12 h-12 bg-white/10 backdrop-blur-sm rounded-2xl flex items-center justify-center hover:bg-white/20 transition-all duration-300 border border-white/20 hover:scale-110">
                            <i class="fab fa-instagram text-white group-hover:text-pink-300"></i>
                        </a>
                        <a href="#" class="group w-12 h-12 bg-white/10 backdrop-blur-sm rounded-2xl flex items-center justify-center hover:bg-white/20 transition-all duration-300 border border-white/20 hover:scale-110">
                            <i class="fab fa-youtube text-white group-hover:text-red-300"></i>
                        </a>
                    </div>
                </div>

                <!-- Quick Links -->
                <div>
                    <h4 class="text-lg font-bold mb-4">Quick Links</h4>
                    <ul class="space-y-2">
                        <li><a href="#programs" class="text-blue-200 hover:text-white transition-colors">Programs</a></li>
                        <li><a href="#events" class="text-blue-200 hover:text-white transition-colors">Events</a></li>
                        <li><a href="#announcements" class="text-blue-200 hover:text-white transition-colors">Announcements</a></li>
                        <li><a href="#members" class="text-blue-200 hover:text-white transition-colors">Members</a></li>
                        <li><a href="/ministries" class="text-blue-200 hover:text-white transition-colors">Ministries</a></li>
                        <li><a href="/donations" class="text-blue-200 hover:text-white transition-colors">Donations</a></li>
                    </ul>
                </div>

                <!-- Contact Info -->
                <div>
                    <h4 class="text-lg font-bold mb-4">Contact Us</h4>
                    <div class="space-y-3">
                        <div class="flex items-center space-x-3">
                            <i class="fas fa-map-marker-alt text-blue-300"></i>
                            <span class="text-blue-200">Church Address, Accra, Ghana</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <i class="fas fa-phone text-blue-300"></i>
                            <span class="text-blue-200">+233 XX XXX XXXX</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <i class="fas fa-envelope text-blue-300"></i>
                            <span class="text-blue-200">info@presbyterianchurch.org</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <i class="fas fa-clock text-blue-300"></i>
                            <span class="text-blue-200">Sunday Service: 8:00 AM</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bottom Footer -->
            <div class="border-t border-white border-opacity-20 mt-12 pt-8 text-center">
                <p class="text-blue-200">
                    &copy; {{ date('Y') }} Presbyterian Church of Ghana. All rights reserved. 
                    <span class="mx-2">|</span>
                    Built with faith and dedication.
                </p>
            </div>
        </div>
    </footer>
</div>

@push('scripts')
<script>
    // Clear filters function
    function clearFilters() {
        document.getElementById('searchInput').value = '';
        document.getElementById('ageGroupSelect').value = '';
        document.getElementById('memberSearchForm').submit();
    }

    // Scroll to members section if filters are active
    @if($isFiltered)
        document.addEventListener('DOMContentLoaded', function() {
            const membersSection = document.getElementById('members');
            if (membersSection) {
                membersSection.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }
        });
    @endif
</script>
@endpush
@endsection
