@extends('components.app-layout')

@section('title', 'Permission Details')
@section('subtitle', 'View permission information and assignments')

@section('content')
<div class="max-w-6xl mx-auto">
    <!-- Header -->
    <div class="mb-8">
        <a href="{{ route('permissions.index') }}" class="inline-flex items-center text-blue-600 hover:text-blue-800 mb-4">
            <i class="fas fa-arrow-left mr-2"></i>
            Back to Permissions
        </a>
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">{{ $permission->name }}</h1>
                <p class="text-gray-600 mt-2">Permission details and role assignments</p>
            </div>
            <div class="flex items-center space-x-3">
                <a href="{{ route('permissions.edit', $permission) }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <form action="{{ route('permissions.destroy', $permission) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this permission? This will remove it from all roles.');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition-colors">
                        <i class="fas fa-trash mr-2"></i>Delete
                    </button>
                </form>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Main Information -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Permission Details Card -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-6">
                <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                    <i class="fas fa-info-circle text-blue-600 mr-3"></i>
                    Permission Information
                </h2>

                <div class="space-y-4">
                    <!-- Name -->
                    <div class="flex items-start">
                        <div class="w-32 flex-shrink-0">
                            <span class="text-sm font-semibold text-gray-600">Name:</span>
                        </div>
                        <div class="flex-1">
                            <span class="text-gray-900 font-medium">{{ $permission->name }}</span>
                        </div>
                    </div>

                    <!-- Slug -->
                    <div class="flex items-start">
                        <div class="w-32 flex-shrink-0">
                            <span class="text-sm font-semibold text-gray-600">Slug:</span>
                        </div>
                        <div class="flex-1">
                            <code class="px-3 py-1 bg-gray-100 text-gray-900 rounded-lg font-mono text-sm">{{ $permission->slug }}</code>
                        </div>
                    </div>

                    <!-- Module -->
                    <div class="flex items-start">
                        <div class="w-32 flex-shrink-0">
                            <span class="text-sm font-semibold text-gray-600">Module:</span>
                        </div>
                        <div class="flex-1">
                            <span class="inline-flex items-center px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm font-medium">
                                <i class="fas fa-layer-group mr-2"></i>
                                {{ ucwords(str_replace('_', ' ', $permission->module)) }}
                            </span>
                        </div>
                    </div>

                    <!-- Description -->
                    @if($permission->description)
                    <div class="flex items-start">
                        <div class="w-32 flex-shrink-0">
                            <span class="text-sm font-semibold text-gray-600">Description:</span>
                        </div>
                        <div class="flex-1">
                            <p class="text-gray-700">{{ $permission->description }}</p>
                        </div>
                    </div>
                    @endif

                    <!-- Created At -->
                    <div class="flex items-start">
                        <div class="w-32 flex-shrink-0">
                            <span class="text-sm font-semibold text-gray-600">Created:</span>
                        </div>
                        <div class="flex-1">
                            <span class="text-gray-700">{{ $permission->created_at->format('M d, Y g:i A') }}</span>
                            <span class="text-gray-500 text-sm ml-2">({{ $permission->created_at->diffForHumans() }})</span>
                        </div>
                    </div>

                    <!-- Updated At -->
                    <div class="flex items-start">
                        <div class="w-32 flex-shrink-0">
                            <span class="text-sm font-semibold text-gray-600">Last Updated:</span>
                        </div>
                        <div class="flex-1">
                            <span class="text-gray-700">{{ $permission->updated_at->format('M d, Y g:i A') }}</span>
                            <span class="text-gray-500 text-sm ml-2">({{ $permission->updated_at->diffForHumans() }})</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Assigned Roles -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-xl font-bold text-gray-900 flex items-center">
                        <i class="fas fa-user-shield text-purple-600 mr-3"></i>
                        Assigned Roles
                    </h2>
                    <span class="px-3 py-1 bg-purple-100 text-purple-700 rounded-full text-sm font-medium">
                        {{ $permission->roles->count() }} {{ Str::plural('role', $permission->roles->count()) }}
                    </span>
                </div>

                @if($permission->roles->count() > 0)
                <div class="space-y-3">
                    @foreach($permission->roles as $role)
                    <div class="flex items-center justify-between p-4 bg-gradient-to-r from-purple-50 to-blue-50 rounded-xl border border-purple-200 hover:border-purple-300 transition-all">
                        <div class="flex items-center flex-1">
                            <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-blue-600 rounded-xl flex items-center justify-center mr-4">
                                <i class="fas fa-user-shield text-white text-lg"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">{{ $role->name }}</h3>
                                <p class="text-sm text-gray-600">
                                    <i class="fas fa-users text-gray-400 mr-1"></i>
                                    {{ $role->users->count() }} {{ Str::plural('user', $role->users->count()) }}
                                    <span class="mx-2">•</span>
                                    <i class="fas fa-key text-gray-400 mr-1"></i>
                                    {{ $role->permissions->count() }} {{ Str::plural('permission', $role->permissions->count()) }}
                                </p>
                            </div>
                        </div>
                        <a href="{{ route('roles.show', $role) }}" class="px-4 py-2 bg-white text-purple-600 rounded-lg hover:bg-purple-50 transition-colors text-sm font-medium">
                            View Role <i class="fas fa-arrow-right ml-1"></i>
                        </a>
                    </div>
                    @endforeach
                </div>
                @else
                <div class="text-center py-12">
                    <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-user-shield text-3xl text-gray-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Not Assigned to Any Roles</h3>
                    <p class="text-gray-600 mb-4">This permission hasn't been assigned to any roles yet.</p>
                    <a href="{{ route('roles.index') }}" class="inline-flex items-center px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition-colors">
                        <i class="fas fa-plus mr-2"></i>
                        Assign to Role
                    </a>
                </div>
                @endif
            </div>

            <!-- Users with This Permission -->
            @if($permission->roles->count() > 0)
            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-xl font-bold text-gray-900 flex items-center">
                        <i class="fas fa-users text-green-600 mr-3"></i>
                        Users with This Permission
                    </h2>
                    @php
                        $totalUsers = $permission->roles->flatMap->users->unique('id')->count();
                    @endphp
                    <span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-sm font-medium">
                        {{ $totalUsers }} {{ Str::plural('user', $totalUsers) }}
                    </span>
                </div>

                @if($totalUsers > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    @foreach($permission->roles->flatMap->users->unique('id') as $user)
                    <div class="flex items-center p-3 bg-green-50 rounded-lg border border-green-200">
                        <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-green-600 rounded-full flex items-center justify-center text-white font-bold mr-3">
                            {{ substr($user->name, 0, 1) }}
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="font-medium text-gray-900 truncate">{{ $user->name }}</p>
                            <p class="text-sm text-gray-600 truncate">{{ $user->email }}</p>
                        </div>
                        <a href="{{ route('users.show', $user) }}" class="text-green-600 hover:text-green-800 ml-2">
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                    @endforeach
                </div>
                @endif
            </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Quick Stats -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-6">
                <h3 class="text-lg font-bold text-gray-900 mb-4">Quick Stats</h3>
                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 bg-blue-50 rounded-lg">
                        <div class="flex items-center">
                            <i class="fas fa-user-shield text-blue-600 mr-3"></i>
                            <span class="text-sm font-medium text-gray-700">Roles</span>
                        </div>
                        <span class="text-lg font-bold text-blue-600">{{ $permission->roles->count() }}</span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-green-50 rounded-lg">
                        <div class="flex items-center">
                            <i class="fas fa-users text-green-600 mr-3"></i>
                            <span class="text-sm font-medium text-gray-700">Users</span>
                        </div>
                        <span class="text-lg font-bold text-green-600">{{ $permission->roles->flatMap->users->unique('id')->count() }}</span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-purple-50 rounded-lg">
                        <div class="flex items-center">
                            <i class="fas fa-layer-group text-purple-600 mr-3"></i>
                            <span class="text-sm font-medium text-gray-700">Module</span>
                        </div>
                        <span class="text-sm font-semibold text-purple-600">{{ ucwords(str_replace('_', ' ', $permission->module)) }}</span>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-6">
                <h3 class="text-lg font-bold text-gray-900 mb-4">Actions</h3>
                <div class="space-y-3">
                    <a href="{{ route('permissions.edit', $permission) }}" class="flex items-center justify-between p-3 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors group">
                        <div class="flex items-center">
                            <i class="fas fa-edit text-blue-600 mr-3"></i>
                            <span class="text-sm font-medium text-gray-700 group-hover:text-blue-700">Edit Permission</span>
                        </div>
                        <i class="fas fa-arrow-right text-blue-600 opacity-0 group-hover:opacity-100 transition-opacity"></i>
                    </a>
                    <a href="{{ route('roles.index') }}" class="flex items-center justify-between p-3 bg-purple-50 hover:bg-purple-100 rounded-lg transition-colors group">
                        <div class="flex items-center">
                            <i class="fas fa-user-shield text-purple-600 mr-3"></i>
                            <span class="text-sm font-medium text-gray-700 group-hover:text-purple-700">Manage Roles</span>
                        </div>
                        <i class="fas fa-arrow-right text-purple-600 opacity-0 group-hover:opacity-100 transition-opacity"></i>
                    </a>
                    <form action="{{ route('permissions.destroy', $permission) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this permission? This will remove it from all roles.');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="w-full flex items-center justify-between p-3 bg-red-50 hover:bg-red-100 rounded-lg transition-colors group">
                            <div class="flex items-center">
                                <i class="fas fa-trash text-red-600 mr-3"></i>
                                <span class="text-sm font-medium text-gray-700 group-hover:text-red-700">Delete Permission</span>
                            </div>
                            <i class="fas fa-arrow-right text-red-600 opacity-0 group-hover:opacity-100 transition-opacity"></i>
                        </button>
                    </form>
                </div>
            </div>

            <!-- Related Permissions -->
            @php
                $relatedPermissions = \App\Models\Permission::where('module', $permission->module)
                    ->where('id', '!=', $permission->id)
                    ->limit(5)
                    ->get();
            @endphp
            @if($relatedPermissions->count() > 0)
            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-6">
                <h3 class="text-lg font-bold text-gray-900 mb-4">Related Permissions</h3>
                <div class="space-y-2">
                    @foreach($relatedPermissions as $related)
                    <a href="{{ route('permissions.show', $related) }}" class="block p-3 bg-gray-50 hover:bg-blue-50 rounded-lg transition-colors group">
                        <p class="text-sm font-medium text-gray-900 group-hover:text-blue-700">{{ $related->name }}</p>
                        <p class="text-xs text-gray-500 font-mono mt-1">{{ $related->slug }}</p>
                    </a>
                    @endforeach
                </div>
                <a href="{{ route('permissions.index') }}" class="block mt-3 text-center text-sm text-blue-600 hover:text-blue-800 font-medium">
                    View All Permissions <i class="fas fa-arrow-right ml-1"></i>
                </a>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
