@extends('components.app-layout')

@section('title', 'Edit Permission')
@section('subtitle', 'Update permission details')

@section('content')
<div class="max-w-4xl mx-auto">
    <!-- Header -->
    <div class="mb-8">
        <a href="{{ route('permissions.show', $permission) }}" class="inline-flex items-center text-blue-600 hover:text-blue-800 mb-4">
            <i class="fas fa-arrow-left mr-2"></i>
            Back to Permission Details
        </a>
        <h1 class="text-3xl font-bold text-gray-900">Edit Permission</h1>
        <p class="text-gray-600 mt-2">Update the details for "{{ $permission->name }}"</p>
    </div>

    <!-- Form Card -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-200 p-8">
        <form action="{{ route('permissions.update', $permission) }}" method="POST">
            @csrf
            @method('PUT')

            <!-- Permission Name -->
            <div class="mb-6">
                <label for="name" class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-tag text-blue-600 mr-2"></i>Permission Name *
                </label>
                <input type="text" 
                       id="name" 
                       name="name" 
                       value="{{ old('name', $permission->name) }}"
                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('name') border-red-500 @enderror"
                       placeholder="e.g., View Members, Create Events, Edit Payments"
                       required>
                @error('name')
                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                @enderror
                <p class="mt-2 text-sm text-gray-500">A descriptive name for the permission</p>
            </div>

            <!-- Permission Slug -->
            <div class="mb-6">
                <label for="slug" class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-code text-purple-600 mr-2"></i>Permission Slug *
                </label>
                <input type="text" 
                       id="slug" 
                       name="slug" 
                       value="{{ old('slug', $permission->slug) }}"
                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-purple-500 focus:border-transparent font-mono @error('slug') border-red-500 @enderror"
                       placeholder="e.g., members.view, events.create, payments.edit"
                       required>
                @error('slug')
                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                @enderror
                <p class="mt-2 text-sm text-gray-500">Use format: module.action (e.g., members.view)</p>
            </div>

            <!-- Module -->
            <div class="mb-6">
                <label for="module" class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-layer-group text-green-600 mr-2"></i>Module *
                </label>
                <select id="module" 
                        name="module" 
                        class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-green-500 focus:border-transparent @error('module') border-red-500 @enderror"
                        required>
                    <option value="">Select a module...</option>
                    @foreach($modules as $mod)
                    <option value="{{ $mod }}" {{ old('module', $permission->module) == $mod ? 'selected' : '' }}>
                        {{ ucwords(str_replace('_', ' ', $mod)) }}
                    </option>
                    @endforeach
                    <option value="new_module" {{ old('module') == 'new_module' ? 'selected' : '' }}>+ Create New Module</option>
                </select>
                @error('module')
                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                @enderror
                <p class="mt-2 text-sm text-gray-500">Group this permission under a module</p>
            </div>

            <!-- New Module Input (Hidden by default) -->
            <div id="new-module-input" class="mb-6 hidden">
                <label for="new_module_name" class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-plus text-orange-600 mr-2"></i>New Module Name
                </label>
                <input type="text" 
                       id="new_module_name" 
                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-orange-500 focus:border-transparent"
                       placeholder="e.g., inventory, finance, reports">
                <p class="mt-2 text-sm text-gray-500">Enter a new module name (lowercase, use underscores for spaces)</p>
            </div>

            <!-- Description -->
            <div class="mb-8">
                <label for="description" class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-align-left text-indigo-600 mr-2"></i>Description
                </label>
                <textarea id="description" 
                          name="description" 
                          rows="4"
                          class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent @error('description') border-red-500 @enderror"
                          placeholder="Describe what this permission allows users to do...">{{ old('description', $permission->description) }}</textarea>
                @error('description')
                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                @enderror
                <p class="mt-2 text-sm text-gray-500">Optional: Provide additional context about this permission</p>
            </div>

            <!-- Action Buttons -->
            <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                <a href="{{ route('permissions.show', $permission) }}" class="px-6 py-3 border border-gray-300 text-gray-700 rounded-xl hover:bg-gray-50 transition-colors">
                    <i class="fas fa-times mr-2"></i>Cancel
                </a>
                <button type="submit" class="px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 text-white rounded-xl hover:from-blue-700 hover:to-purple-700 transition-all duration-200 shadow-lg">
                    <i class="fas fa-save mr-2"></i>Update Permission
                </button>
            </div>
        </form>
    </div>

    <!-- Warning Box -->
    @if($permission->roles->count() > 0)
    <div class="mt-8 bg-yellow-50 border border-yellow-200 rounded-2xl p-6">
        <div class="flex items-start">
            <i class="fas fa-exclamation-triangle text-yellow-600 text-xl mr-3 mt-1"></i>
            <div>
                <h3 class="text-lg font-bold text-yellow-900 mb-2">Warning: Permission In Use</h3>
                <p class="text-sm text-yellow-800 mb-3">
                    This permission is currently assigned to <strong>{{ $permission->roles->count() }} {{ Str::plural('role', $permission->roles->count()) }}</strong> 
                    affecting <strong>{{ $permission->roles->flatMap->users->unique('id')->count() }} {{ Str::plural('user', $permission->roles->flatMap->users->unique('id')->count()) }}</strong>.
                </p>
                <p class="text-sm text-yellow-800">
                    Changing the slug or module may affect existing permission checks in the system. Make sure to update any code that references this permission.
                </p>
            </div>
        </div>
    </div>
    @endif

    <!-- Info Box -->
    <div class="mt-8 bg-blue-50 border border-blue-200 rounded-2xl p-6">
        <h3 class="text-lg font-bold text-blue-900 mb-3">
            <i class="fas fa-info-circle mr-2"></i>Best Practices
        </h3>
        <ul class="space-y-2 text-sm text-blue-800">
            <li class="flex items-start">
                <i class="fas fa-check text-blue-600 mr-2 mt-1"></i>
                <span><strong>Keep slugs consistent:</strong> Avoid changing slugs unless absolutely necessary</span>
            </li>
            <li class="flex items-start">
                <i class="fas fa-check text-blue-600 mr-2 mt-1"></i>
                <span><strong>Use clear names:</strong> Make it obvious what the permission allows</span>
            </li>
            <li class="flex items-start">
                <i class="fas fa-check text-blue-600 mr-2 mt-1"></i>
                <span><strong>Document changes:</strong> Update descriptions when modifying permissions</span>
            </li>
            <li class="flex items-start">
                <i class="fas fa-check text-blue-600 mr-2 mt-1"></i>
                <span><strong>Test after changes:</strong> Verify that roles still have correct access</span>
            </li>
        </ul>
    </div>
</div>

<script>
document.getElementById('module').addEventListener('change', function() {
    const newModuleInput = document.getElementById('new-module-input');
    const newModuleNameInput = document.getElementById('new_module_name');
    
    if (this.value === 'new_module') {
        newModuleInput.classList.remove('hidden');
        newModuleNameInput.required = true;
    } else {
        newModuleInput.classList.add('hidden');
        newModuleNameInput.required = false;
    }
});

// Handle new module
document.getElementById('new_module_name').addEventListener('input', function() {
    const moduleSelect = document.getElementById('module');
    if (this.value) {
        const newValue = this.value.toLowerCase().replace(/\s+/g, '_');
        moduleSelect.value = newValue;
    }
});
</script>
@endsection
