@extends('components.app-layout')

@section('title', 'Inventory Reports')

@php
    $dynamicSubtitle = 'Generate comprehensive reports for ' . ($organizationSettings['name'] ?? 'Presbyterian Church of Ghana') . ' inventory';
@endphp

@section('subtitle', $dynamicSubtitle)

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-indigo-50 to-purple-50 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Header Section -->
        <div class="relative overflow-hidden bg-gradient-to-r from-indigo-600 via-purple-600 to-pink-600 rounded-3xl shadow-2xl">
            <div class="absolute inset-0 bg-black opacity-5"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-16">
                <div class="max-w-4xl mx-auto text-center">
                    <div class="inline-flex items-center justify-center w-20 h-20 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl mb-6 shadow-xl">
                        <i class="fas fa-chart-bar text-3xl text-white"></i>
                    </div>
                    <h1 class="text-5xl font-bold text-white mb-4">Inventory Reports</h1>
                    <p class="text-xl text-white opacity-90 mb-8 max-w-2xl mx-auto">
                        Generate detailed reports and analytics for your inventory management
                    </p>
                    <div class="flex items-center justify-center space-x-8 text-white/80">
                        <div class="flex items-center">
                            <i class="fas fa-file-export mr-2"></i>
                            <span class="text-sm">Export Reports</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-chart-line mr-2"></i>
                            <span class="text-sm">Analytics</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-calendar mr-2"></i>
                            <span class="text-sm">Date Ranges</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Stats Dashboard -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Total Items -->
            <div class="group bg-gradient-to-br from-blue-500 via-blue-600 to-blue-700 rounded-3xl p-6 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-white/20 rounded-2xl backdrop-blur-sm">
                            <i class="fas fa-boxes text-2xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-blue-100 text-sm font-medium uppercase tracking-wider">Total Items</p>
                            <p class="text-3xl font-bold">{{ $stats['total_items'] ?? 0 }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stock Value -->
            <div class="group bg-gradient-to-br from-emerald-500 via-emerald-600 to-emerald-700 rounded-3xl p-6 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-white/20 rounded-2xl backdrop-blur-sm">
                            <i class="fas fa-dollar-sign text-2xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-emerald-100 text-sm font-medium uppercase tracking-wider">Stock Value</p>
                            <p class="text-3xl font-bold">₵{{ number_format($stats['total_stock_value'] ?? 0, 2) }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Low Stock Items -->
            <div class="group bg-gradient-to-br from-orange-500 via-orange-600 to-orange-700 rounded-3xl p-6 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-white/20 rounded-2xl backdrop-blur-sm">
                            <i class="fas fa-exclamation-triangle text-2xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-orange-100 text-sm font-medium uppercase tracking-wider">Low Stock</p>
                            <p class="text-3xl font-bold">{{ $stats['low_stock_items'] ?? 0 }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Categories -->
            <div class="group bg-gradient-to-br from-purple-500 via-purple-600 to-purple-700 rounded-3xl p-6 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-white/20 rounded-2xl backdrop-blur-sm">
                            <i class="fas fa-tags text-2xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-purple-100 text-sm font-medium uppercase tracking-wider">Categories</p>
                            <p class="text-3xl font-bold">{{ $stats['total_categories'] ?? 0 }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Report Generation Section -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            
            <!-- Standard Reports -->
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                <div class="flex items-center space-x-3 mb-6">
                    <div class="w-12 h-12 bg-gradient-to-r from-indigo-600 to-purple-600 rounded-2xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-file-alt text-white text-xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Standard Reports</h2>
                        <p class="text-gray-600">Pre-configured reports for common needs</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <!-- Inventory Summary Report -->
                    <div class="p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl border border-blue-200 hover:shadow-lg transition-all duration-200">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-blue-500 rounded-xl flex items-center justify-center">
                                    <i class="fas fa-list text-white"></i>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900">Inventory Summary</h3>
                                    <p class="text-sm text-gray-600">Complete overview of all items and stock levels</p>
                                </div>
                            </div>
                            <div class="flex space-x-2">
                                <button onclick="generateReport('inventory-summary', 'pdf')" class="px-3 py-2 bg-blue-600 text-white rounded-lg text-sm font-medium hover:bg-blue-700 transition-colors">
                                    <i class="fas fa-file-pdf mr-1"></i>
                                    PDF
                                </button>
                                <button onclick="generateReport('inventory-summary', 'excel')" class="px-3 py-2 bg-green-600 text-white rounded-lg text-sm font-medium hover:bg-green-700 transition-colors">
                                    <i class="fas fa-file-excel mr-1"></i>
                                    Excel
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Low Stock Report -->
                    <div class="p-4 bg-gradient-to-r from-orange-50 to-red-50 rounded-xl border border-orange-200 hover:shadow-lg transition-all duration-200">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-orange-500 rounded-xl flex items-center justify-center">
                                    <i class="fas fa-exclamation-triangle text-white"></i>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900">Low Stock Alert Report</h3>
                                    <p class="text-sm text-gray-600">Items that need immediate restocking</p>
                                </div>
                            </div>
                            <div class="flex space-x-2">
                                <button onclick="generateReport('low-stock', 'pdf')" class="px-3 py-2 bg-orange-600 text-white rounded-lg text-sm font-medium hover:bg-orange-700 transition-colors">
                                    <i class="fas fa-file-pdf mr-1"></i>
                                    PDF
                                </button>
                                <button onclick="generateReport('low-stock', 'excel')" class="px-3 py-2 bg-green-600 text-white rounded-lg text-sm font-medium hover:bg-green-700 transition-colors">
                                    <i class="fas fa-file-excel mr-1"></i>
                                    Excel
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Category Report -->
                    <div class="p-4 bg-gradient-to-r from-purple-50 to-pink-50 rounded-xl border border-purple-200 hover:shadow-lg transition-all duration-200">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-purple-500 rounded-xl flex items-center justify-center">
                                    <i class="fas fa-tags text-white"></i>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900">Category Analysis</h3>
                                    <p class="text-sm text-gray-600">Breakdown by item categories with statistics</p>
                                </div>
                            </div>
                            <div class="flex space-x-2">
                                <button onclick="generateReport('category-analysis', 'pdf')" class="px-3 py-2 bg-purple-600 text-white rounded-lg text-sm font-medium hover:bg-purple-700 transition-colors">
                                    <i class="fas fa-file-pdf mr-1"></i>
                                    PDF
                                </button>
                                <button onclick="generateReport('category-analysis', 'excel')" class="px-3 py-2 bg-green-600 text-white rounded-lg text-sm font-medium hover:bg-green-700 transition-colors">
                                    <i class="fas fa-file-excel mr-1"></i>
                                    Excel
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Valuation Report -->
                    <div class="p-4 bg-gradient-to-r from-emerald-50 to-green-50 rounded-xl border border-emerald-200 hover:shadow-lg transition-all duration-200">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-emerald-500 rounded-xl flex items-center justify-center">
                                    <i class="fas fa-dollar-sign text-white"></i>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900">Inventory Valuation</h3>
                                    <p class="text-sm text-gray-600">Financial value of current stock holdings</p>
                                </div>
                            </div>
                            <div class="flex space-x-2">
                                <button onclick="generateReport('valuation', 'pdf')" class="px-3 py-2 bg-emerald-600 text-white rounded-lg text-sm font-medium hover:bg-emerald-700 transition-colors">
                                    <i class="fas fa-file-pdf mr-1"></i>
                                    PDF
                                </button>
                                <button onclick="generateReport('valuation', 'excel')" class="px-3 py-2 bg-green-600 text-white rounded-lg text-sm font-medium hover:bg-green-700 transition-colors">
                                    <i class="fas fa-file-excel mr-1"></i>
                                    Excel
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Custom Reports -->
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                <div class="flex items-center space-x-3 mb-6">
                    <div class="w-12 h-12 bg-gradient-to-r from-pink-600 to-red-600 rounded-2xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-cogs text-white text-xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Custom Reports</h2>
                        <p class="text-gray-600">Generate reports with custom filters and date ranges</p>
                    </div>
                </div>

                <form id="customReportForm" class="space-y-6">
                    <!-- Report Type -->
                    <div>
                        <label for="report_type" class="block text-sm font-medium text-gray-700 mb-2">Report Type</label>
                        <select name="report_type" id="report_type" class="w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-pink-500/20 focus:border-pink-500 transition-all duration-300">
                            <option value="inventory">Inventory Items</option>
                            <option value="transactions">Stock Transactions</option>
                            <option value="categories">Category Analysis</option>
                            <option value="suppliers">Supplier Report</option>
                        </select>
                    </div>

                    <!-- Date Range -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="start_date" class="block text-sm font-medium text-gray-700 mb-2">Start Date</label>
                            <input type="date" name="start_date" id="start_date" class="w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-pink-500/20 focus:border-pink-500 transition-all duration-300">
                        </div>
                        <div>
                            <label for="end_date" class="block text-sm font-medium text-gray-700 mb-2">End Date</label>
                            <input type="date" name="end_date" id="end_date" class="w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-pink-500/20 focus:border-pink-500 transition-all duration-300">
                        </div>
                    </div>

                    <!-- Category Filter -->
                    <div>
                        <label for="category_filter" class="block text-sm font-medium text-gray-700 mb-2">Category (Optional)</label>
                        <select name="category_filter" id="category_filter" class="w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-pink-500/20 focus:border-pink-500 transition-all duration-300">
                            <option value="">All Categories</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Stock Status Filter -->
                    <div>
                        <label for="stock_status" class="block text-sm font-medium text-gray-700 mb-2">Stock Status (Optional)</label>
                        <select name="stock_status" id="stock_status" class="w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-pink-500/20 focus:border-pink-500 transition-all duration-300">
                            <option value="">All Stock Levels</option>
                            <option value="in_stock">In Stock</option>
                            <option value="low_stock">Low Stock</option>
                            <option value="out_of_stock">Out of Stock</option>
                        </select>
                    </div>

                    <!-- Generate Buttons -->
                    <div class="flex space-x-4">
                        <button type="button" onclick="generateCustomReport('pdf')" class="flex-1 px-6 py-3 bg-gradient-to-r from-pink-600 to-red-600 text-white font-bold rounded-xl hover:from-pink-700 hover:to-red-700 transition-all duration-300 shadow-lg hover:shadow-xl">
                            <i class="fas fa-file-pdf mr-2"></i>
                            Generate PDF
                        </button>
                        <button type="button" onclick="generateCustomReport('excel')" class="flex-1 px-6 py-3 bg-gradient-to-r from-green-600 to-emerald-600 text-white font-bold rounded-xl hover:from-green-700 hover:to-emerald-700 transition-all duration-300 shadow-lg hover:shadow-xl">
                            <i class="fas fa-file-excel mr-2"></i>
                            Generate Excel
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Recent Reports -->
        <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-gradient-to-r from-gray-600 to-gray-700 rounded-2xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-history text-white text-xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Recent Reports</h2>
                        <p class="text-gray-600">Previously generated reports</p>
                    </div>
                </div>
                <button onclick="clearReportHistory()" class="px-4 py-2 text-gray-600 hover:text-gray-800 text-sm font-medium">
                    <i class="fas fa-trash mr-1"></i>
                    Clear History
                </button>
            </div>

            <div id="recentReports" class="space-y-3">
                <div class="text-center py-8 text-gray-500">
                    <i class="fas fa-file-alt text-4xl mb-4"></i>
                    <p>No reports generated yet. Generate your first report above.</p>
                </div>
            </div>
        </div>

        <!-- Back to Dashboard -->
        <div class="text-center">
            <a href="{{ route('inventory.index') }}" class="inline-flex items-center px-6 py-3 bg-white/80 backdrop-blur-sm border border-gray-200 text-gray-700 font-medium rounded-xl hover:bg-gray-50 hover:shadow-lg transition-all duration-200 transform hover:scale-105">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Inventory Dashboard
            </a>
        </div>
    </div>
</div>

<!-- Loading Modal -->
<div id="loadingModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
    <div class="bg-white rounded-2xl shadow-2xl p-8 max-w-sm w-full mx-4">
        <div class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-indigo-600 mx-auto mb-4"></div>
            <h3 class="text-lg font-bold text-gray-900 mb-2">Generating Report</h3>
            <p class="text-gray-600">Please wait while we prepare your report...</p>
        </div>
    </div>
</div>

<script>
function generateReport(type, format) {
    showLoading();
    
    // Simulate report generation
    setTimeout(() => {
        hideLoading();
        addToRecentReports(type, format);
        showNotification(`${type.replace('-', ' ').toUpperCase()} report generated successfully!`, 'success');
        
        // In a real implementation, this would trigger the actual report download
        // window.open(`/inventory/reports/generate/${type}?format=${format}`, '_blank');
    }, 2000);
}

function generateCustomReport(format) {
    const form = document.getElementById('customReportForm');
    const formData = new FormData(form);
    
    showLoading();
    
    // Simulate custom report generation
    setTimeout(() => {
        hideLoading();
        addToRecentReports('custom', format, formData.get('report_type'));
        showNotification(`Custom ${formData.get('report_type')} report generated successfully!`, 'success');
        
        // In a real implementation, this would submit the form data
        // const params = new URLSearchParams(formData);
        // window.open(`/inventory/reports/custom?${params}&format=${format}`, '_blank');
    }, 2500);
}

function showLoading() {
    document.getElementById('loadingModal').classList.remove('hidden');
}

function hideLoading() {
    document.getElementById('loadingModal').classList.add('hidden');
}

function addToRecentReports(type, format, subtype = null) {
    const reportsContainer = document.getElementById('recentReports');
    const now = new Date();
    const timeString = now.toLocaleString();
    
    // Clear empty state if it exists
    if (reportsContainer.querySelector('.text-center')) {
        reportsContainer.innerHTML = '';
    }
    
    const reportName = subtype ? `Custom ${subtype}` : type.replace('-', ' ').toUpperCase();
    const reportItem = document.createElement('div');
    reportItem.className = 'flex items-center justify-between p-4 bg-gray-50 rounded-xl hover:bg-gray-100 transition-colors';
    reportItem.innerHTML = `
        <div class="flex items-center space-x-3">
            <div class="w-10 h-10 bg-indigo-500 rounded-xl flex items-center justify-center">
                <i class="fas fa-file-${format === 'pdf' ? 'pdf' : 'excel'} text-white"></i>
            </div>
            <div>
                <h4 class="font-medium text-gray-900">${reportName} Report</h4>
                <p class="text-sm text-gray-600">Generated on ${timeString}</p>
            </div>
        </div>
        <div class="flex space-x-2">
            <button onclick="downloadReport('${type}', '${format}')" class="px-3 py-2 bg-indigo-600 text-white rounded-lg text-sm font-medium hover:bg-indigo-700 transition-colors">
                <i class="fas fa-download mr-1"></i>
                Download
            </button>
            <button onclick="this.parentElement.parentElement.remove()" class="px-3 py-2 bg-gray-600 text-white rounded-lg text-sm font-medium hover:bg-gray-700 transition-colors">
                <i class="fas fa-trash"></i>
            </button>
        </div>
    `;
    
    reportsContainer.insertBefore(reportItem, reportsContainer.firstChild);
}

function downloadReport(type, format) {
    showNotification(`Downloading ${type} report...`, 'info');
    // In a real implementation, this would trigger the download
}

function clearReportHistory() {
    document.getElementById('recentReports').innerHTML = `
        <div class="text-center py-8 text-gray-500">
            <i class="fas fa-file-alt text-4xl mb-4"></i>
            <p>No reports generated yet. Generate your first report above.</p>
        </div>
    `;
    showNotification('Report history cleared', 'success');
}

function showNotification(message, type = 'success') {
    // Simple notification system
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 px-6 py-3 rounded-lg text-white font-medium z-50 ${
        type === 'success' ? 'bg-green-600' : 
        type === 'error' ? 'bg-red-600' : 
        'bg-blue-600'
    }`;
    notification.textContent = message;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.remove();
    }, 3000);
}

// Set default dates
document.addEventListener('DOMContentLoaded', function() {
    const today = new Date();
    const thirtyDaysAgo = new Date(today.getTime() - (30 * 24 * 60 * 60 * 1000));
    
    document.getElementById('start_date').value = thirtyDaysAgo.toISOString().split('T')[0];
    document.getElementById('end_date').value = today.toISOString().split('T')[0];
});
</script>
@endsection
