@extends('components.app-layout')

@section('title', 'Edit Item')
@section('subtitle', 'Update inventory item details')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Header Section -->
        <div class="relative overflow-hidden bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 rounded-3xl shadow-2xl">
            <div class="absolute inset-0 bg-black opacity-5"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-12">
                <div class="max-w-4xl mx-auto">
                    <div class="flex items-center space-x-6">
                        <div class="w-16 h-16 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl flex items-center justify-center shadow-xl">
                            <i class="fas fa-edit text-2xl text-white"></i>
                        </div>
                        <div>
                            <h1 class="text-4xl font-bold text-white mb-2">Edit Item</h1>
                            <p class="text-xl text-white opacity-90">{{ $item->name }}</p>
                            <p class="text-white/80">{{ $item->item_code }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Edit Form -->
        <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
            <form action="{{ route('inventory.items.update', $item) }}" method="POST" enctype="multipart/form-data" class="space-y-8">
                @csrf
                @method('PUT')

                <!-- Basic Information Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-blue-600 to-indigo-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-info-circle text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Basic Information</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Item Name -->
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Item Name *</label>
                            <input type="text" name="name" id="name" value="{{ old('name', $item->name) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('name') border-red-500 @enderror" 
                                   required>
                            @error('name')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Item Code -->
                        <div>
                            <label for="item_code" class="block text-sm font-medium text-gray-700 mb-2">Item Code *</label>
                            <input type="text" name="item_code" id="item_code" value="{{ old('item_code', $item->item_code) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('item_code') border-red-500 @enderror" 
                                   required>
                            @error('item_code')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Category -->
                        <div>
                            <label for="category_id" class="block text-sm font-medium text-gray-700 mb-2">Category *</label>
                            <div class="relative">
                                <select name="category_id" id="category_id" 
                                        class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md appearance-none @error('category_id') border-red-500 @enderror" 
                                        required>
                                    <option value="">Select Category</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ old('category_id', $item->category_id) == $category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                                    <i class="fas fa-chevron-down text-gray-400"></i>
                                </div>
                            </div>
                            @error('category_id')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Unit of Measure -->
                        <div>
                            <label for="unit_of_measure" class="block text-sm font-medium text-gray-700 mb-2">Unit of Measure</label>
                            <input type="text" name="unit_of_measure" id="unit_of_measure" value="{{ old('unit_of_measure', $item->unit_of_measure) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('unit_of_measure') border-red-500 @enderror" 
                                   placeholder="e.g., pieces, kg, liters">
                            @error('unit_of_measure')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Description -->
                        <div class="md:col-span-2">
                            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                            <textarea name="description" id="description" rows="3" 
                                      class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('description') border-red-500 @enderror" 
                                      placeholder="Item description...">{{ old('description', $item->description) }}</textarea>
                            @error('description')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Stock & Pricing Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-emerald-600 to-green-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-dollar-sign text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Stock & Pricing</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Unit Cost -->
                        <div>
                            <label for="unit_cost" class="block text-sm font-medium text-gray-700 mb-2">Unit Cost (₵)</label>
                            <input type="number" name="unit_cost" id="unit_cost" step="0.01" min="0" value="{{ old('unit_cost', $item->unit_cost) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('unit_cost') border-red-500 @enderror">
                            @error('unit_cost')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Minimum Stock -->
                        <div>
                            <label for="minimum_stock" class="block text-sm font-medium text-gray-700 mb-2">Minimum Stock *</label>
                            <input type="number" name="minimum_stock" id="minimum_stock" min="0" value="{{ old('minimum_stock', $item->minimum_stock) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('minimum_stock') border-red-500 @enderror" 
                                   required>
                            @error('minimum_stock')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Maximum Stock -->
                        <div>
                            <label for="maximum_stock" class="block text-sm font-medium text-gray-700 mb-2">Maximum Stock</label>
                            <input type="number" name="maximum_stock" id="maximum_stock" min="0" value="{{ old('maximum_stock', $item->maximum_stock) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('maximum_stock') border-red-500 @enderror">
                            @error('maximum_stock')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <!-- Current Stock Display -->
                    <div class="mt-6 p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl border border-blue-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-blue-700">Current Stock Level</p>
                                <p class="text-2xl font-bold text-blue-900">{{ $item->current_stock }} {{ $item->unit_of_measure }}</p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm text-blue-600">Stock Value</p>
                                <p class="text-xl font-bold text-blue-800">₵{{ number_format($item->stock_value, 2) }}</p>
                            </div>
                        </div>
                        <p class="text-sm text-blue-600 mt-2">
                            <i class="fas fa-info-circle mr-1"></i>
                            To update stock levels, use the "Update Stock" button after saving changes.
                        </p>
                    </div>
                </div>

                <!-- Location & Supplier Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-purple-600 to-pink-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-map-marker-alt text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Location & Supplier</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Location -->
                        <div>
                            <label for="location" class="block text-sm font-medium text-gray-700 mb-2">Storage Location</label>
                            <input type="text" name="location" id="location" value="{{ old('location', $item->location) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('location') border-red-500 @enderror" 
                                   placeholder="e.g., Storage Room A, Shelf 3">
                            @error('location')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Barcode -->
                        <div>
                            <label for="barcode" class="block text-sm font-medium text-gray-700 mb-2">Barcode</label>
                            <input type="text" name="barcode" id="barcode" value="{{ old('barcode', $item->barcode) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('barcode') border-red-500 @enderror" 
                                   placeholder="Item barcode">
                            @error('barcode')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Supplier -->
                        <div>
                            <label for="supplier" class="block text-sm font-medium text-gray-700 mb-2">Supplier Name</label>
                            <input type="text" name="supplier" id="supplier" value="{{ old('supplier', $item->supplier) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('supplier') border-red-500 @enderror" 
                                   placeholder="Supplier company name">
                            @error('supplier')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Supplier Contact -->
                        <div>
                            <label for="supplier_contact" class="block text-sm font-medium text-gray-700 mb-2">Supplier Contact</label>
                            <input type="text" name="supplier_contact" id="supplier_contact" value="{{ old('supplier_contact', $item->supplier_contact) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('supplier_contact') border-red-500 @enderror" 
                                   placeholder="Phone, email, or address">
                            @error('supplier_contact')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Expiry & Settings Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-orange-600 to-red-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-cog text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Expiry & Settings</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Track Expiry -->
                        <div>
                            <div class="flex items-center space-x-3">
                                <input type="hidden" name="track_expiry" value="0">
                                <input type="checkbox" name="track_expiry" id="track_expiry" value="1" 
                                       {{ old('track_expiry', $item->track_expiry) ? 'checked' : '' }}
                                       class="w-5 h-5 text-orange-600 bg-white border-2 border-gray-300 rounded focus:ring-orange-500 focus:ring-2"
                                       onchange="toggleExpiryDate()">
                                <label for="track_expiry" class="text-sm font-medium text-gray-700">Track expiry date for this item</label>
                            </div>
                        </div>

                        <!-- Is Active -->
                        <div>
                            <div class="flex items-center space-x-3">
                                <input type="hidden" name="is_active" value="0">
                                <input type="checkbox" name="is_active" id="is_active" value="1" 
                                       {{ old('is_active', $item->is_active) ? 'checked' : '' }}
                                       class="w-5 h-5 text-green-600 bg-white border-2 border-gray-300 rounded focus:ring-green-500 focus:ring-2">
                                <label for="is_active" class="text-sm font-medium text-gray-700">Item is active</label>
                            </div>
                        </div>

                        <!-- Expiry Date -->
                        <div id="expiry_date_field" class="{{ old('track_expiry', $item->track_expiry) ? '' : 'hidden' }}">
                            <label for="expiry_date" class="block text-sm font-medium text-gray-700 mb-2">Expiry Date</label>
                            <input type="date" name="expiry_date" id="expiry_date" value="{{ old('expiry_date', $item->expiry_date?->format('Y-m-d')) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-orange-500/20 focus:border-orange-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('expiry_date') border-red-500 @enderror">
                            @error('expiry_date')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Notes Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-gray-600 to-gray-700 rounded-xl flex items-center justify-center">
                            <i class="fas fa-sticky-note text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Additional Notes</h2>
                    </div>

                    <div>
                        <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Notes</label>
                        <textarea name="notes" id="notes" rows="4" 
                                  class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-gray-500/20 focus:border-gray-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('notes') border-red-500 @enderror" 
                                  placeholder="Any additional notes about this item...">{{ old('notes', $item->notes) }}</textarea>
                        @error('notes')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col sm:flex-row justify-between items-center gap-4 pt-8 border-t border-gray-200">
                    <div class="flex space-x-4">
                        <a href="{{ route('inventory.items.show', $item) }}" class="inline-flex items-center px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-200 transition-all duration-200 shadow-md hover:shadow-lg">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Back to Item
                        </a>
                        <a href="{{ route('inventory.items.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-200 transition-all duration-200 shadow-md hover:shadow-lg">
                            <i class="fas fa-list mr-2"></i>
                            All Items
                        </a>
                    </div>
                    
                    <div class="flex space-x-4">
                        <button type="button" onclick="showStockModal()" class="inline-flex items-center px-6 py-3 bg-emerald-600 text-white font-medium rounded-xl hover:bg-emerald-700 transition-colors shadow-lg hover:shadow-xl">
                            <i class="fas fa-plus mr-2"></i>
                            Update Stock
                        </button>
                        <button type="submit" class="inline-flex items-center px-8 py-3 bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 text-white font-bold rounded-xl hover:from-blue-700 hover:via-indigo-700 hover:to-purple-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                            <i class="fas fa-save mr-2"></i>
                            Update Item
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Stock Update Modal -->
<div id="stockModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
    <div class="bg-white rounded-2xl shadow-2xl max-w-md w-full mx-4">
        <div class="p-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-bold text-gray-900">Update Stock</h3>
                <button onclick="closeStockModal()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            
            <form action="{{ route('inventory.items.update-stock', $item) }}" method="POST">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Item</label>
                        <p class="text-gray-900 font-medium">{{ $item->name }}</p>
                        <p class="text-sm text-gray-500">Current stock: {{ $item->current_stock }} {{ $item->unit_of_measure }}</p>
                    </div>
                    
                    <div>
                        <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Transaction Type</label>
                        <select name="type" id="type" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="in">Stock In</option>
                            <option value="out">Stock Out</option>
                            <option value="adjustment">Adjustment</option>
                        </select>
                    </div>
                    
                    <div>
                        <label for="quantity" class="block text-sm font-medium text-gray-700 mb-2">Quantity</label>
                        <input type="number" name="quantity" id="quantity" min="1" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                    </div>
                    
                    <div>
                        <label for="reason" class="block text-sm font-medium text-gray-700 mb-2">Reason</label>
                        <input type="text" name="reason" id="reason" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                    </div>
                    
                    <div>
                        <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Notes (Optional)</label>
                        <textarea name="notes" id="notes" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"></textarea>
                    </div>
                </div>
                
                <div class="flex space-x-3 mt-6">
                    <button type="button" onclick="closeStockModal()" class="flex-1 px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                        Cancel
                    </button>
                    <button type="submit" class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                        Update Stock
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function toggleExpiryDate() {
    const trackExpiry = document.getElementById('track_expiry');
    const expiryField = document.getElementById('expiry_date_field');
    
    if (trackExpiry.checked) {
        expiryField.classList.remove('hidden');
    } else {
        expiryField.classList.add('hidden');
        document.getElementById('expiry_date').value = '';
    }
}

function showStockModal() {
    document.getElementById('stockModal').classList.remove('hidden');
}

function closeStockModal() {
    document.getElementById('stockModal').classList.add('hidden');
}

// Close modal when clicking outside
document.getElementById('stockModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeStockModal();
    }
});

// Initialize expiry date field visibility
document.addEventListener('DOMContentLoaded', function() {
    toggleExpiryDate();
});
</script>
@endsection
