@extends('components.app-layout')

@section('title', 'Add New Item')
@section('subtitle', 'Create a new inventory item')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-emerald-50 to-green-50 py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Header Section -->
        <div class="relative overflow-hidden bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 rounded-3xl shadow-2xl">
            <div class="absolute inset-0 bg-black opacity-5"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-12">
                <div class="max-w-4xl mx-auto">
                    <div class="flex items-center space-x-6">
                        <div class="w-16 h-16 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl flex items-center justify-center shadow-xl">
                            <i class="fas fa-plus text-2xl text-white"></i>
                        </div>
                        <div>
                            <h1 class="text-4xl font-bold text-white mb-2">Add New Item</h1>
                            <p class="text-xl text-white opacity-90">Create a new inventory item for your organization</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Create Form -->
        <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
            <form action="{{ route('inventory.items.store') }}" method="POST" enctype="multipart/form-data" class="space-y-8">
                @csrf

                <!-- Basic Information Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-emerald-600 to-green-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-info-circle text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Basic Information</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Item Name -->
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Item Name *</label>
                            <input type="text" name="name" id="name" value="{{ old('name') }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('name') border-red-500 @enderror" 
                                   placeholder="Enter item name"
                                   required>
                            @error('name')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Item Code -->
                        <div>
                            <label for="item_code" class="block text-sm font-medium text-gray-700 mb-2">Item Code</label>
                            <input type="text" name="item_code" id="item_code" value="{{ old('item_code') }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('item_code') border-red-500 @enderror" 
                                   placeholder="Auto-generated if left empty">
                            @error('item_code')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                            <p class="mt-1 text-xs text-gray-500">Leave empty to auto-generate based on category</p>
                        </div>

                        <!-- Category -->
                        <div>
                            <label for="category_id" class="block text-sm font-medium text-gray-700 mb-2">Category *</label>
                            <div class="relative">
                                <select name="category_id" id="category_id" 
                                        class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md appearance-none @error('category_id') border-red-500 @enderror" 
                                        required>
                                    <option value="">Select Category</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                                    <i class="fas fa-chevron-down text-gray-400"></i>
                                </div>
                            </div>
                            @error('category_id')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                            <p class="mt-1 text-xs text-gray-500">
                                <a href="{{ route('inventory.categories.create') }}" class="text-emerald-600 hover:text-emerald-700 font-medium">
                                    <i class="fas fa-plus mr-1"></i>Create new category
                                </a>
                            </p>
                        </div>

                        <!-- Unit of Measure -->
                        <div>
                            <label for="unit_of_measure" class="block text-sm font-medium text-gray-700 mb-2">Unit of Measure</label>
                            <input type="text" name="unit_of_measure" id="unit_of_measure" value="{{ old('unit_of_measure', 'pieces') }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('unit_of_measure') border-red-500 @enderror" 
                                   placeholder="e.g., pieces, kg, liters">
                            @error('unit_of_measure')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Description -->
                        <div class="md:col-span-2">
                            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                            <textarea name="description" id="description" rows="3" 
                                      class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-emerald-500/20 focus:border-emerald-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('description') border-red-500 @enderror" 
                                      placeholder="Describe the item...">{{ old('description') }}</textarea>
                            @error('description')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Stock & Pricing Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-blue-600 to-indigo-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-dollar-sign text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Stock & Pricing</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                        <!-- Initial Stock -->
                        <div>
                            <label for="current_stock" class="block text-sm font-medium text-gray-700 mb-2">Initial Stock</label>
                            <input type="number" name="current_stock" id="current_stock" min="0" value="{{ old('current_stock', 0) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('current_stock') border-red-500 @enderror">
                            @error('current_stock')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Unit Cost -->
                        <div>
                            <label for="unit_cost" class="block text-sm font-medium text-gray-700 mb-2">Unit Cost (₵)</label>
                            <input type="number" name="unit_cost" id="unit_cost" step="0.01" min="0" value="{{ old('unit_cost', 0) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('unit_cost') border-red-500 @enderror">
                            @error('unit_cost')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Minimum Stock -->
                        <div>
                            <label for="minimum_stock" class="block text-sm font-medium text-gray-700 mb-2">Minimum Stock *</label>
                            <input type="number" name="minimum_stock" id="minimum_stock" min="0" value="{{ old('minimum_stock', 5) }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('minimum_stock') border-red-500 @enderror" 
                                   required>
                            @error('minimum_stock')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Maximum Stock -->
                        <div>
                            <label for="maximum_stock" class="block text-sm font-medium text-gray-700 mb-2">Maximum Stock</label>
                            <input type="number" name="maximum_stock" id="maximum_stock" min="0" value="{{ old('maximum_stock') }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-blue-500/20 focus:border-blue-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('maximum_stock') border-red-500 @enderror">
                            @error('maximum_stock')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                            <p class="mt-1 text-xs text-gray-500">Leave empty to auto-calculate (3x minimum)</p>
                        </div>
                    </div>

                    <!-- Stock Value Preview -->
                    <div class="mt-6 p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl border border-blue-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-blue-700">Initial Stock Value</p>
                                <p class="text-2xl font-bold text-blue-900" id="stock_value_display">₵0.00</p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm text-blue-600">Cost per Unit</p>
                                <p class="text-xl font-bold text-blue-800" id="unit_cost_display">₵0.00</p>
                            </div>
                        </div>
                        <p class="text-sm text-blue-600 mt-2">
                            <i class="fas fa-calculator mr-1"></i>
                            Stock Value = Initial Stock × Unit Cost
                        </p>
                    </div>
                </div>

                <!-- Location & Supplier Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-purple-600 to-pink-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-map-marker-alt text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Location & Supplier</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Location -->
                        <div>
                            <label for="location" class="block text-sm font-medium text-gray-700 mb-2">Storage Location</label>
                            <input type="text" name="location" id="location" value="{{ old('location') }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('location') border-red-500 @enderror" 
                                   placeholder="e.g., Storage Room A, Shelf 3">
                            @error('location')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Barcode -->
                        <div>
                            <label for="barcode" class="block text-sm font-medium text-gray-700 mb-2">Barcode</label>
                            <input type="text" name="barcode" id="barcode" value="{{ old('barcode') }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('barcode') border-red-500 @enderror" 
                                   placeholder="Item barcode">
                            @error('barcode')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Supplier -->
                        <div>
                            <label for="supplier" class="block text-sm font-medium text-gray-700 mb-2">Supplier Name</label>
                            <input type="text" name="supplier" id="supplier" value="{{ old('supplier') }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('supplier') border-red-500 @enderror" 
                                   placeholder="Supplier company name">
                            @error('supplier')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Supplier Contact -->
                        <div>
                            <label for="supplier_contact" class="block text-sm font-medium text-gray-700 mb-2">Supplier Contact</label>
                            <input type="text" name="supplier_contact" id="supplier_contact" value="{{ old('supplier_contact') }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-purple-500/20 focus:border-purple-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('supplier_contact') border-red-500 @enderror" 
                                   placeholder="Phone, email, or address">
                            @error('supplier_contact')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Expiry & Settings Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-orange-600 to-red-600 rounded-xl flex items-center justify-center">
                            <i class="fas fa-cog text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Expiry & Settings</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Track Expiry -->
                        <div>
                            <div class="flex items-center space-x-3">
                                <input type="hidden" name="track_expiry" value="0">
                                <input type="checkbox" name="track_expiry" id="track_expiry" value="1" 
                                       {{ old('track_expiry') ? 'checked' : '' }}
                                       class="w-5 h-5 text-orange-600 bg-white border-2 border-gray-300 rounded focus:ring-orange-500 focus:ring-2"
                                       onchange="toggleExpiryDate()">
                                <label for="track_expiry" class="text-sm font-medium text-gray-700">Track expiry date for this item</label>
                            </div>
                        </div>

                        <!-- Is Active -->
                        <div>
                            <div class="flex items-center space-x-3">
                                <input type="hidden" name="is_active" value="0">
                                <input type="checkbox" name="is_active" id="is_active" value="1" 
                                       {{ old('is_active', true) ? 'checked' : '' }}
                                       class="w-5 h-5 text-green-600 bg-white border-2 border-gray-300 rounded focus:ring-green-500 focus:ring-2">
                                <label for="is_active" class="text-sm font-medium text-gray-700">Item is active</label>
                            </div>
                        </div>

                        <!-- Expiry Date -->
                        <div id="expiry_date_field" class="{{ old('track_expiry') ? '' : 'hidden' }}">
                            <label for="expiry_date" class="block text-sm font-medium text-gray-700 mb-2">Expiry Date</label>
                            <input type="date" name="expiry_date" id="expiry_date" value="{{ old('expiry_date') }}" 
                                   class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-orange-500/20 focus:border-orange-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('expiry_date') border-red-500 @enderror">
                            @error('expiry_date')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Notes Section -->
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="w-10 h-10 bg-gradient-to-r from-gray-600 to-gray-700 rounded-xl flex items-center justify-center">
                            <i class="fas fa-sticky-note text-white"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900">Additional Notes</h2>
                    </div>

                    <div>
                        <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Notes</label>
                        <textarea name="notes" id="notes" rows="4" 
                                  class="block w-full px-4 py-3 bg-white/50 backdrop-blur-sm border-2 border-gray-200/50 rounded-2xl focus:ring-4 focus:ring-gray-500/20 focus:border-gray-500 transition-all duration-300 text-gray-900 font-medium shadow-sm hover:shadow-md @error('notes') border-red-500 @enderror" 
                                  placeholder="Any additional notes about this item...">{{ old('notes') }}</textarea>
                        @error('notes')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col sm:flex-row justify-between items-center gap-4 pt-8 border-t border-gray-200">
                    <div class="flex space-x-4">
                        <a href="{{ route('inventory.items.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-200 transition-all duration-200 shadow-md hover:shadow-lg">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Back to Items
                        </a>
                        <a href="{{ route('inventory.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-200 transition-all duration-200 shadow-md hover:shadow-lg">
                            <i class="fas fa-tachometer-alt mr-2"></i>
                            Dashboard
                        </a>
                    </div>
                    
                    <div class="flex space-x-4">
                        <button type="reset" class="inline-flex items-center px-6 py-3 bg-gray-600 text-white font-medium rounded-xl hover:bg-gray-700 transition-colors shadow-lg hover:shadow-xl">
                            <i class="fas fa-undo mr-2"></i>
                            Reset Form
                        </button>
                        <button type="submit" class="inline-flex items-center px-8 py-3 bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 text-white font-bold rounded-xl hover:from-emerald-700 hover:via-green-700 hover:to-teal-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                            <i class="fas fa-plus mr-2"></i>
                            Create Item
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function toggleExpiryDate() {
    const trackExpiry = document.getElementById('track_expiry');
    const expiryField = document.getElementById('expiry_date_field');
    
    if (trackExpiry.checked) {
        expiryField.classList.remove('hidden');
    } else {
        expiryField.classList.add('hidden');
        document.getElementById('expiry_date').value = '';
    }
}

function updateStockValue() {
    const currentStock = parseFloat(document.getElementById('current_stock').value) || 0;
    const unitCost = parseFloat(document.getElementById('unit_cost').value) || 0;
    const stockValue = currentStock * unitCost;
    
    document.getElementById('stock_value_display').textContent = `₵${stockValue.toFixed(2)}`;
    document.getElementById('unit_cost_display').textContent = `₵${unitCost.toFixed(2)}`;
}

// Initialize expiry date field visibility and stock value calculation
document.addEventListener('DOMContentLoaded', function() {
    toggleExpiryDate();
    updateStockValue();
    
    // Add event listeners for stock value calculation
    document.getElementById('current_stock').addEventListener('input', updateStockValue);
    document.getElementById('unit_cost').addEventListener('input', updateStockValue);
});
</script>
@endsection
