@extends('components.app-layout')

@section('title', 'Inventory Dashboard')

@php
    $dynamicSubtitle = 'Manage ' . ($organizationSettings['name'] ?? 'Presbyterian Church of Ghana') . ' inventory and stock levels';
@endphp

@section('subtitle', $dynamicSubtitle)

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-green-50 to-emerald-50 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Header Section -->
        <div class="relative overflow-hidden bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 rounded-3xl shadow-2xl">
            <div class="absolute inset-0 bg-black opacity-5"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-16">
                <div class="max-w-4xl mx-auto text-center">
                    <div class="inline-flex items-center justify-center w-20 h-20 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl mb-6 shadow-xl">
                        <i class="fas fa-boxes text-3xl text-white"></i>
                    </div>
                    <h1 class="text-5xl font-bold text-white mb-4">Inventory Management</h1>
                    <p class="text-xl text-white opacity-90 mb-8 max-w-2xl mx-auto">
                        Track and manage your church inventory, monitor stock levels, and generate comprehensive reports.
                    </p>
                    <div class="flex items-center justify-center space-x-8 text-white/80">
                        <div class="flex items-center">
                            <i class="fas fa-boxes mr-2"></i>
                            <span class="text-sm">Stock Management</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-chart-line mr-2"></i>
                            <span class="text-sm">Real-time Tracking</span>
                        </div>
                        <div class="flex items-center">
                            <i class="fas fa-bell mr-2"></i>
                            <span class="text-sm">Smart Alerts</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Dashboard -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <!-- Total Items -->
            <div class="group bg-gradient-to-br from-blue-500 via-blue-600 to-blue-700 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 hover:rotate-1 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-boxes text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-blue-100 text-sm font-medium uppercase tracking-wider">Total Items</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300">{{ $stats['total_items'] ?? 0 }}</p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-blue-100">
                        <div class="flex items-center">
                            <i class="fas fa-chart-line mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Active inventory</span>
                        </div>
                        <div class="w-3 h-3 bg-blue-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>

            <!-- Low Stock Items -->
            <div class="group bg-gradient-to-br from-red-500 via-red-600 to-red-700 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 hover:-rotate-1 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-exclamation-triangle text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-red-100 text-sm font-medium uppercase tracking-wider">Low Stock</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300">{{ $stats['low_stock_items'] ?? 0 }}</p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-red-100">
                        <div class="flex items-center">
                            <i class="fas fa-arrow-down mr-2 group-hover:animate-bounce"></i>
                            <span class="text-sm font-medium">Need attention</span>
                        </div>
                        <div class="w-3 h-3 bg-red-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>

            <!-- Categories -->
            <div class="group bg-gradient-to-br from-purple-500 via-purple-600 to-purple-700 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 hover:rotate-1 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-tags text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-purple-100 text-sm font-medium uppercase tracking-wider">Categories</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300">{{ $stats['total_categories'] ?? 0 }}</p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-purple-100">
                        <div class="flex items-center">
                            <i class="fas fa-layer-group mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Item groups</span>
                        </div>
                        <div class="w-3 h-3 bg-purple-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>

            <!-- Stock Value -->
            <div class="group bg-gradient-to-br from-green-500 via-green-600 to-green-700 rounded-3xl p-8 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 hover:-rotate-1 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-6">
                        <div class="p-4 bg-white/20 rounded-2xl backdrop-blur-sm group-hover:bg-white/30 group-hover:scale-110 transition-all duration-300 shadow-lg">
                            <i class="fas fa-dollar-sign text-3xl group-hover:rotate-12 transition-transform duration-300"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-green-100 text-sm font-medium uppercase tracking-wider">Stock Value</p>
                            <p class="text-4xl font-bold group-hover:scale-110 transition-transform duration-300">₵{{ number_format($stats['total_stock_value'] ?? 0, 2) }}</p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between text-green-100">
                        <div class="flex items-center">
                            <i class="fas fa-chart-bar mr-2 group-hover:animate-pulse"></i>
                            <span class="text-sm font-medium">Total worth</span>
                        </div>
                        <div class="w-3 h-3 bg-green-300 rounded-full animate-pulse"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="bg-white/80 backdrop-blur-xl rounded-3xl shadow-xl border border-white/20 p-8">
            <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center gap-6">
                <div class="space-y-3">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-emerald-600 to-green-600 rounded-2xl flex items-center justify-center shadow-xl">
                            <i class="fas fa-bolt text-white text-xl"></i>
                        </div>
                        <div>
                            <h2 class="text-3xl font-bold bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 bg-clip-text text-transparent">Quick Actions</h2>
                            <p class="text-gray-600 text-lg mt-1">Manage your inventory efficiently</p>
                        </div>
                    </div>
                </div>
                <div class="flex flex-wrap items-center gap-4">
                    <a href="{{ route('inventory.items.create') }}" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 text-white font-bold rounded-xl hover:from-emerald-700 hover:via-green-700 hover:to-teal-700 transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105">
                        <i class="fas fa-plus mr-2"></i>
                        Add Item
                    </a>
                    <a href="{{ route('inventory.categories.create') }}" class="inline-flex items-center px-6 py-3 bg-white text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-50 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105">
                        <i class="fas fa-tag mr-2"></i>
                        New Category
                    </a>
                    <a href="{{ route('inventory.alerts') }}" class="inline-flex items-center px-6 py-3 bg-white text-gray-700 font-medium rounded-xl border border-gray-200 hover:bg-gray-50 transition-all duration-200 shadow-md hover:shadow-lg transform hover:scale-105">
                        <i class="fas fa-bell mr-2"></i>
                        View Alerts
                    </a>
                </div>
            </div>
        </div>

        <!-- Recent Activity & Alerts -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Low Stock Alerts -->
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-bold text-gray-900">Low Stock Alerts</h3>
                    <a href="{{ route('inventory.alerts') }}" class="text-red-600 hover:text-red-700 font-medium text-sm">View All</a>
                </div>
                @if($lowStockItems->count() > 0)
                    <div class="space-y-4">
                        @foreach($lowStockItems as $item)
                            <div class="flex items-center justify-between p-4 bg-red-50 border border-red-200 rounded-xl">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-red-500 rounded-full flex items-center justify-center">
                                        <i class="fas fa-exclamation text-white text-sm"></i>
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-900">{{ $item->name }}</p>
                                        <p class="text-sm text-gray-600">{{ $item->category->name ?? 'No Category' }}</p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm font-medium text-red-600">{{ $item->current_stock }} left</p>
                                    <p class="text-xs text-gray-500">Min: {{ $item->minimum_stock }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-check-circle text-green-500 text-4xl mb-4"></i>
                        <p class="text-gray-600">All items are well stocked!</p>
                    </div>
                @endif
            </div>

            <!-- Recent Transactions -->
            <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-bold text-gray-900">Recent Activity</h3>
                    <a href="{{ route('inventory.reports') }}" class="text-blue-600 hover:text-blue-700 font-medium text-sm">View Reports</a>
                </div>
                @if($recentTransactions->count() > 0)
                    <div class="space-y-4">
                        @foreach($recentTransactions as $transaction)
                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-{{ $transaction->type_color }}-500 rounded-full flex items-center justify-center">
                                        <i class="fas fa-{{ $transaction->type === 'in' ? 'arrow-up' : ($transaction->type === 'out' ? 'arrow-down' : 'edit') }} text-white text-sm"></i>
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-900">{{ $transaction->item->name ?? 'Unknown Item' }}</p>
                                        <p class="text-sm text-gray-600">{{ $transaction->type_display }}</p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm font-medium">{{ $transaction->quantity > 0 ? '+' : '' }}{{ $transaction->quantity }}</p>
                                    <p class="text-xs text-gray-500">{{ $transaction->created_at->diffForHumans() }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-history text-gray-400 text-4xl mb-4"></i>
                        <p class="text-gray-600">No recent activity</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
