@extends('components.app-layout')

@section('title', 'Category Details')
@section('subtitle', $category->name)

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-cyan-50 to-blue-50 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
        
        <!-- Header Section -->
        <div class="relative overflow-hidden rounded-3xl shadow-2xl" style="background: linear-gradient(135deg, {{ $category->color ?? '#6B7280' }}, {{ $category->color ?? '#6B7280' }}99, {{ $category->color ?? '#6B7280' }}66)">
            <div class="absolute inset-0 bg-black opacity-10"></div>
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full transform translate-x-32 -translate-y-32"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-white opacity-5 rounded-full transform -translate-x-24 translate-y-24"></div>
            
            <div class="relative px-8 py-12">
                <div class="max-w-4xl mx-auto">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-6">
                            <div class="w-20 h-20 bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl flex items-center justify-center shadow-xl">
                                <i class="{{ $category->icon ?? 'fas fa-tag' }} text-3xl text-white"></i>
                            </div>
                            <div>
                                <div class="flex items-center space-x-3 mb-2">
                                    <h1 class="text-4xl font-bold text-white">{{ $category->name }}</h1>
                                    @if($category->is_active)
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                                            <i class="fas fa-check-circle mr-1"></i>
                                            Active
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                                            <i class="fas fa-times-circle mr-1"></i>
                                            Inactive
                                        </span>
                                    @endif
                                </div>
                                @if($category->description)
                                    <p class="text-xl text-white opacity-90 mb-2">{{ $category->description }}</p>
                                @endif
                                <div class="flex items-center space-x-4 text-white/80">
                                    <span class="flex items-center">
                                        <i class="fas fa-boxes mr-2"></i>
                                        {{ $category->items->count() }} Items
                                    </span>
                                    <span class="flex items-center">
                                        <i class="fas fa-dollar-sign mr-2"></i>
                                        ₵{{ number_format($category->total_stock_value, 2) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="bg-white bg-opacity-20 backdrop-blur-sm rounded-2xl p-6 shadow-xl">
                                <p class="text-white/80 text-sm font-medium uppercase tracking-wider mb-1">Active Items</p>
                                <p class="text-4xl font-bold text-white">{{ $category->activeItems->count() }}</p>
                                <p class="text-white/80 text-sm">out of {{ $category->items->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Category Statistics -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Total Items -->
            <div class="group bg-gradient-to-br from-blue-500 via-blue-600 to-blue-700 rounded-3xl p-6 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-white/20 rounded-2xl backdrop-blur-sm">
                            <i class="fas fa-boxes text-2xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-blue-100 text-sm font-medium uppercase tracking-wider">Total Items</p>
                            <p class="text-3xl font-bold">{{ $category->items->count() }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Active Items -->
            <div class="group bg-gradient-to-br from-emerald-500 via-emerald-600 to-emerald-700 rounded-3xl p-6 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-white/20 rounded-2xl backdrop-blur-sm">
                            <i class="fas fa-check-circle text-2xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-emerald-100 text-sm font-medium uppercase tracking-wider">Active Items</p>
                            <p class="text-3xl font-bold">{{ $category->activeItems->count() }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Low Stock Items -->
            <div class="group bg-gradient-to-br from-orange-500 via-orange-600 to-orange-700 rounded-3xl p-6 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-white/20 rounded-2xl backdrop-blur-sm">
                            <i class="fas fa-exclamation-triangle text-2xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-orange-100 text-sm font-medium uppercase tracking-wider">Low Stock</p>
                            <p class="text-3xl font-bold">{{ $lowStockItems->count() }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Value -->
            <div class="group bg-gradient-to-br from-purple-500 via-purple-600 to-purple-700 rounded-3xl p-6 text-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:scale-105 relative overflow-hidden">
                <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                <div class="relative z-10">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-white/20 rounded-2xl backdrop-blur-sm">
                            <i class="fas fa-dollar-sign text-2xl"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-purple-100 text-sm font-medium uppercase tracking-wider">Total Value</p>
                            <p class="text-3xl font-bold">₵{{ number_format($category->total_stock_value, 2) }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            
            <!-- Category Items -->
            <div class="lg:col-span-2 space-y-8">
                
                <!-- Items List -->
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-2xl font-bold text-gray-900">Category Items</h2>
                        <div class="flex space-x-2">
                            <a href="{{ route('inventory.items.create', ['category' => $category->id]) }}" class="inline-flex items-center px-4 py-2 bg-emerald-600 text-white font-medium rounded-xl hover:bg-emerald-700 transition-colors">
                                <i class="fas fa-plus mr-2"></i>
                                Add Item
                            </a>
                            <a href="{{ route('inventory.items.index', ['category' => $category->id]) }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white font-medium rounded-xl hover:bg-blue-700 transition-colors">
                                <i class="fas fa-list mr-2"></i>
                                View All
                            </a>
                        </div>
                    </div>

                    @if($category->items->count() > 0)
                        <div class="space-y-4">
                            @foreach($category->items->take(10) as $item)
                                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl hover:bg-gray-100 transition-colors">
                                    <div class="flex items-center space-x-4">
                                        <div class="w-12 h-12 rounded-xl flex items-center justify-center shadow-md" style="background: linear-gradient(135deg, {{ $category->color ?? '#6B7280' }}, {{ $category->color ?? '#6B7280' }}99)">
                                            <i class="{{ $category->icon ?? 'fas fa-box' }} text-white"></i>
                                        </div>
                                        <div>
                                            <h3 class="font-medium text-gray-900">{{ $item->name }}</h3>
                                            <p class="text-sm text-gray-600">{{ $item->item_code }}</p>
                                        </div>
                                    </div>
                                    <div class="flex items-center space-x-4">
                                        <div class="text-right">
                                            <p class="text-sm font-medium text-gray-900">{{ $item->current_stock }} {{ $item->unit_of_measure }}</p>
                                            <p class="text-xs text-gray-500">₵{{ number_format($item->stock_value, 2) }}</p>
                                        </div>
                                        @php
                                            $stockStatus = $item->stock_status;
                                            $badgeClass = match($stockStatus) {
                                                'out_of_stock' => 'bg-red-100 text-red-800',
                                                'low_stock' => 'bg-orange-100 text-orange-800',
                                                'overstock' => 'bg-blue-100 text-blue-800',
                                                default => 'bg-green-100 text-green-800'
                                            };
                                        @endphp
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $badgeClass }}">
                                            {{ ucfirst(str_replace('_', ' ', $stockStatus)) }}
                                        </span>
                                        <div class="flex space-x-1">
                                            <a href="{{ route('inventory.items.show', $item) }}" class="p-2 text-blue-600 hover:text-blue-800 hover:bg-blue-50 rounded-lg transition-colors">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('inventory.items.edit', $item) }}" class="p-2 text-gray-600 hover:text-gray-800 hover:bg-gray-50 rounded-lg transition-colors">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        @if($category->items->count() > 10)
                            <div class="mt-6 text-center">
                                <a href="{{ route('inventory.items.index', ['category' => $category->id]) }}" class="inline-flex items-center px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors">
                                    <i class="fas fa-list mr-2"></i>
                                    View All {{ $category->items->count() }} Items
                                </a>
                            </div>
                        @endif
                    @else
                        <div class="text-center py-12">
                            <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-box text-gray-400 text-2xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-900 mb-2">No Items Yet</h3>
                            <p class="text-gray-600 mb-4">This category doesn't have any items yet.</p>
                            <a href="{{ route('inventory.items.create', ['category' => $category->id]) }}" class="inline-flex items-center px-6 py-3 bg-emerald-600 text-white font-medium rounded-xl hover:bg-emerald-700 transition-colors">
                                <i class="fas fa-plus mr-2"></i>
                                Add First Item
                            </a>
                        </div>
                    @endif
                </div>

                <!-- Low Stock Alerts -->
                @if($lowStockItems->count() > 0)
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-8">
                    <div class="flex items-center justify-between mb-6">
                        <div class="flex items-center space-x-3">
                            <div class="w-10 h-10 bg-orange-500 rounded-xl flex items-center justify-center">
                                <i class="fas fa-exclamation-triangle text-white"></i>
                            </div>
                            <h2 class="text-2xl font-bold text-gray-900">Low Stock Alerts</h2>
                        </div>
                        <span class="text-sm text-orange-600 font-medium">{{ $lowStockItems->count() }} items need attention</span>
                    </div>

                    <div class="space-y-3">
                        @foreach($lowStockItems as $item)
                            <div class="flex items-center justify-between p-4 bg-orange-50 border border-orange-200 rounded-xl">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-orange-500 rounded-full flex items-center justify-center">
                                        <i class="fas fa-exclamation text-white text-sm"></i>
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-900">{{ $item->name }}</p>
                                        <p class="text-sm text-gray-600">{{ $item->item_code }}</p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm font-medium text-orange-600">{{ $item->current_stock }} left</p>
                                    <p class="text-xs text-gray-500">Min: {{ $item->minimum_stock }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>

            <!-- Sidebar -->
            <div class="space-y-8">
                
                <!-- Category Information -->
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-6">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Category Information</h3>
                    
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Category Name</label>
                            <p class="text-gray-900 font-medium">{{ $category->name }}</p>
                        </div>
                        
                        @if($category->description)
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Description</label>
                                <p class="text-gray-900">{{ $category->description }}</p>
                            </div>
                        @endif
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Category Color</label>
                            <div class="flex items-center space-x-2">
                                <div class="w-6 h-6 rounded-full border-2 border-gray-300" style="background-color: {{ $category->color ?? '#6B7280' }}"></div>
                                <span class="text-gray-900 font-mono text-sm">{{ $category->color ?? '#6B7280' }}</span>
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Icon</label>
                            <div class="flex items-center space-x-2">
                                <i class="{{ $category->icon ?? 'fas fa-tag' }} text-gray-600"></i>
                                <span class="text-gray-900 font-mono text-sm">{{ $category->icon ?? 'fas fa-tag' }}</span>
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Status</label>
                            @if($category->is_active)
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    <i class="fas fa-check-circle mr-1"></i>
                                    Active
                                </span>
                            @else
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                    <i class="fas fa-times-circle mr-1"></i>
                                    Inactive
                                </span>
                            @endif
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Created</label>
                            <p class="text-gray-900">{{ $category->created_at->format('M d, Y') }}</p>
                        </div>
                        
                        @if($category->updated_at != $category->created_at)
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Last Updated</label>
                                <p class="text-gray-900">{{ $category->updated_at->format('M d, Y') }}</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-6">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Quick Actions</h3>
                    <div class="space-y-3">
                        <a href="{{ route('inventory.categories.edit', $category) }}" class="w-full flex items-center justify-center px-4 py-3 bg-blue-600 text-white font-medium rounded-xl hover:bg-blue-700 transition-colors">
                            <i class="fas fa-edit mr-2"></i>
                            Edit Category
                        </a>
                        <a href="{{ route('inventory.items.create', ['category' => $category->id]) }}" class="w-full flex items-center justify-center px-4 py-3 bg-emerald-600 text-white font-medium rounded-xl hover:bg-emerald-700 transition-colors">
                            <i class="fas fa-plus mr-2"></i>
                            Add Item
                        </a>
                        <a href="{{ route('inventory.items.index', ['category' => $category->id]) }}" class="w-full flex items-center justify-center px-4 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors">
                            <i class="fas fa-list mr-2"></i>
                            View All Items
                        </a>
                        <a href="{{ route('inventory.categories.index') }}" class="w-full flex items-center justify-center px-4 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors">
                            <i class="fas fa-tags mr-2"></i>
                            All Categories
                        </a>
                    </div>
                </div>

                <!-- Category Statistics -->
                <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl border border-gray-100/50 p-6">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Statistics</h3>
                    
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Total Items</span>
                            <span class="font-medium text-gray-900">{{ $category->items->count() }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Active Items</span>
                            <span class="font-medium text-gray-900">{{ $category->activeItems->count() }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Low Stock Items</span>
                            <span class="font-medium text-orange-600">{{ $lowStockItems->count() }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Total Stock Value</span>
                            <span class="font-medium text-gray-900">₵{{ number_format($category->total_stock_value, 2) }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Average Item Value</span>
                            <span class="font-medium text-gray-900">₵{{ $category->items->count() > 0 ? number_format($category->total_stock_value / $category->items->count(), 2) : '0.00' }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
