<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Created</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
        }
        .content {
            padding: 40px 30px;
        }
        .credentials-box {
            background: #f8f9fa;
            border: 2px solid #2563eb;
            border-radius: 8px;
            padding: 25px;
            margin: 25px 0;
        }
        .credential-row {
            margin: 15px 0;
            padding: 10px;
            background: white;
            border-radius: 4px;
        }
        .credential-label {
            font-weight: bold;
            color: #666;
            font-size: 12px;
            text-transform: uppercase;
            margin-bottom: 5px;
        }
        .credential-value {
            font-size: 18px;
            color: #2563eb;
            font-family: 'Courier New', monospace;
            font-weight: bold;
        }
        .button {
            display: inline-block;
            padding: 15px 35px;
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
            font-weight: bold;
        }
        .info-box {
            background: linear-gradient(135deg, #2563eb15 0%, #dc262615 100%);
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #2563eb;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>👤 Account Created Successfully</h1>
        </div>
        
        <div class="content">
            <h2>Dear {{ $user->name }},</h2>
            
            <p>Welcome to {{ $organizationName }}! Your administrator account has been created successfully. You now have access to the church management system.</p>
            
            @if($password)
            <div class="credentials-box">
                <h3 style="margin-top: 0; color: #2563eb; text-align: center;">Your Login Credentials</h3>
                
                <div class="credential-row">
                    <div class="credential-label">Email Address</div>
                    <div class="credential-value">{{ $user->email }}</div>
                </div>
                
                <div class="credential-row">
                    <div class="credential-label">Temporary Password</div>
                    <div class="credential-value">{{ $password }}</div>
                </div>
                
                <div class="credential-row">
                    <div class="credential-label">Role</div>
                    <div class="credential-value">{{ ucfirst($user->role ?? 'User') }}</div>
                </div>
            </div>
            
            <div style="text-align: center;">
                <a href="{{ $loginUrl }}" class="button">Login to Dashboard</a>
            </div>
            
            <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0; border-radius: 4px;">
                <strong>⚠️ Security Reminder:</strong>
                <ul style="margin: 10px 0;">
                    <li>Change your password immediately after first login</li>
                    <li>Use a strong, unique password</li>
                    <li>Never share your credentials with anyone</li>
                    <li>Enable two-factor authentication if available</li>
                </ul>
            </div>
            @else
            <div class="info-box">
                <p style="margin: 0;"><strong>Your account email:</strong> {{ $user->email }}</p>
                <p style="margin: 10px 0 0 0;">You can now log in using the credentials you set during registration.</p>
            </div>
            
            <div style="text-align: center;">
                <a href="{{ $loginUrl }}" class="button">Login to Dashboard</a>
            </div>
            @endif
            
            <div class="info-box">
                <h3 style="margin-top: 0; color: #2563eb;">System Access</h3>
                <p>As a user of the church management system, you can:</p>
                <ul>
                    <li>Manage member information and records</li>
                    <li>Track contributions and finances</li>
                    <li>Organize events and programs</li>
                    <li>Monitor attendance</li>
                    <li>Send communications to members</li>
                    <li>Generate reports and analytics</li>
                </ul>
            </div>
            
            <p>If you have any questions or need assistance, please contact the system administrator.</p>
        </div>
        
        <div class="footer">
            <p><strong>{{ $organizationName }}</strong></p>
            <p>Church Management System</p>
            <p style="font-size: 12px; color: #999; margin-top: 10px;">
                This email contains sensitive information. Please keep it confidential.
            </p>
        </div>
    </div>
</body>
</html>
