<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to Our Church</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            color: white;
            padding: 40px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 32px;
        }
        .welcome-icon {
            font-size: 64px;
            margin-bottom: 10px;
        }
        .content {
            padding: 40px 30px;
        }
        .info-box {
            background: #f8f9fa;
            border-left: 4px solid #2563eb;
            padding: 20px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .info-row {
            margin: 10px 0;
        }
        .info-label {
            font-weight: bold;
            color: #666;
            display: inline-block;
            width: 120px;
        }
        .highlight {
            background: linear-gradient(135deg, #2563eb15 0%, #dc262615 100%);
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="welcome-icon">🙏</div>
            <h1>Registration Received!</h1>
        </div>
        
        <div class="content">
            <h2>Dear {{ $member->full_name }},</h2>
            
            <p>Thank you for registering with {{ $organizationName }}! Your registration has been successfully submitted and is currently being reviewed by our membership committee.</p>
            
            <div class="info-box">
                <h3 style="margin-top: 0; color: #2563eb;">Your Registration Details</h3>
                <div class="info-row">
                    <span class="info-label">Status:</span>
                    <span style="color: #f59e0b; font-weight: bold;">⏳ Pending Approval</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Full Name:</span>
                    <span>{{ $member->full_name }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Email:</span>
                    <span>{{ $member->email ?? 'Not provided' }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Phone:</span>
                    <span>{{ $member->phone }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Registration Date:</span>
                    <span>{{ $member->created_at->format('F d, Y') }}</span>
                </div>
            </div>
            
            <div class="highlight">
                <h3 style="margin-top: 0; color: #2563eb;">What Happens Next?</h3>
                <ul style="margin: 10px 0;">
                    <li><strong>Review:</strong> Your application will be reviewed by the membership committee</li>
                    <li><strong>Contact:</strong> You will be contacted within 5-7 business days</li>
                    <li><strong>Interview:</strong> An interview may be scheduled if required</li>
                    <li><strong>Notification:</strong> You will receive confirmation via email/SMS once approved</li>
                    <li><strong>Welcome:</strong> After approval, you'll receive your member ID and full access</li>
                </ul>
            </div>
            
            <div style="background: #fef3c7; border-left: 4px solid #f59e0b; padding: 15px; border-radius: 4px; margin: 20px 0;">
                <p style="margin: 0; color: #92400e;">
                    <strong>⚠️ Important:</strong> Please check your email regularly for updates on your membership application. If you have any questions, feel free to contact the church office.
                </p>
            </div>
            
            <p style="font-style: italic; color: #666; border-left: 3px solid #2563eb; padding-left: 15px;">
                "Therefore, as God's chosen people, holy and dearly loved, clothe yourselves with compassion, kindness, humility, gentleness and patience." - Colossians 3:12
            </p>
            
            <p>We're excited about your interest in joining our church family. If you have any questions about the process, please don't hesitate to contact us.</p>
            
            <p><strong>God bless you!</strong></p>
        </div>
        
        <div class="footer">
            <p><strong>{{ $organizationName }}</strong></p>
            <p>Thank you for your registration. We'll be in touch soon!</p>
        </div>
    </div>
</body>
</html>
