<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Login Credentials</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
        }
        .content {
            padding: 40px 30px;
        }
        .credentials-box {
            background: #f8f9fa;
            border: 2px solid #2563eb;
            border-radius: 8px;
            padding: 25px;
            margin: 25px 0;
        }
        .credential-row {
            margin: 15px 0;
            padding: 10px;
            background: white;
            border-radius: 4px;
        }
        .credential-label {
            font-weight: bold;
            color: #666;
            font-size: 12px;
            text-transform: uppercase;
            margin-bottom: 5px;
        }
        .credential-value {
            font-size: 18px;
            color: #2563eb;
            font-family: 'Courier New', monospace;
            font-weight: bold;
        }
        .button {
            display: inline-block;
            padding: 15px 35px;
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
            font-weight: bold;
        }
        .warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔐 Your Login Credentials</h1>
        </div>
        
        <div class="content">
            <h2>Dear {{ $member->full_name }},</h2>
            
            <p>Your member portal account has been created! You can now access your personal dashboard to view your information, contributions, attendance, and more.</p>
            
            <div class="credentials-box">
                <h3 style="margin-top: 0; color: #2563eb; text-align: center;">Login Credentials</h3>
                
                <div class="credential-row">
                    <div class="credential-label">Email Address / Username</div>
                    <div class="credential-value">{{ $member->email }}</div>
                </div>
                
                <div class="credential-row">
                    <div class="credential-label">Temporary Password</div>
                    <div class="credential-value">{{ $password }}</div>
                </div>
                
                <div class="credential-row">
                    <div class="credential-label">Member ID</div>
                    <div class="credential-value">{{ $member->member_id }}</div>
                </div>
            </div>
            
            <div style="text-align: center;">
                <a href="{{ $loginUrl }}" class="button">Login to Member Portal</a>
            </div>
            
            <div class="warning">
                <strong>⚠️ Important Security Notice:</strong>
                <ul style="margin: 10px 0;">
                    <li>Please change your password immediately after your first login</li>
                    <li>Do not share your login credentials with anyone</li>
                    <li>Keep this email in a secure location</li>
                    <li>Use a strong, unique password for your account</li>
                </ul>
            </div>
            
            <div style="background: linear-gradient(135deg, #2563eb15 0%, #dc262615 100%); padding: 20px; border-radius: 8px; margin: 20px 0;">
                <h3 style="margin-top: 0; color: #2563eb;">What You Can Do:</h3>
                <ul>
                    <li>View your personal information and membership details</li>
                    <li>Check your contribution history</li>
                    <li>View attendance records</li>
                    <li>Update your contact information</li>
                    <li>Register for events and programs</li>
                    <li>Access church resources and announcements</li>
                </ul>
            </div>
            
            <p>If you have any questions or difficulty logging in, please contact our support team.</p>
        </div>
        
        <div class="footer">
            <p><strong>{{ $organizationName }}</strong></p>
            <p>Login URL: <a href="{{ $loginUrl }}">{{ $loginUrl }}</a></p>
            <p style="font-size: 12px; color: #999; margin-top: 10px;">
                This email contains sensitive information. Please keep it confidential.
            </p>
        </div>
    </div>
</body>
</html>
