<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Attendance List</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; background-color: #f4f4f4; }
        .container { max-width: 600px; margin: 20px auto; background: #ffffff; border-radius: 10px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .header { background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%); color: white; padding: 30px 20px; text-align: center; }
        .header h1 { margin: 0; font-size: 28px; }
        .content { padding: 30px; }
        .event-box { background: linear-gradient(135deg, #2563eb15 0%, #dc262615 100%); border-left: 4px solid #2563eb; padding: 20px; margin: 20px 0; border-radius: 4px; }
        .member-list { background: #f8f9fa; padding: 15px; border-radius: 4px; margin: 20px 0; }
        .member-item { padding: 8px; border-bottom: 1px solid #dee2e6; }
        .member-item:last-child { border-bottom: none; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; color: #666; font-size: 14px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📋 Attendance Confirmed</h1>
        </div>
        
        <div class="content">
            <p>Attendance has been successfully recorded for the following event:</p>
            
            <div class="event-box">
                <h3 style="margin-top: 0; color: #2563eb;">{{ $event->title }}</h3>
                <p><strong>Date:</strong> {{ $event->start_datetime->format('F d, Y') }}</p>
                <p><strong>Time:</strong> {{ $event->start_datetime->format('h:i A') }}</p>
                <p><strong>Location:</strong> {{ $event->location ?? 'Church Premises' }}</p>
                <p><strong>Total Attendees:</strong> {{ $attendees->count() }}</p>
            </div>
            
            <h3>Attendees List:</h3>
            <div class="member-list">
                @foreach($attendees as $attendee)
                <div class="member-item">
                    <strong>{{ $attendee->member->full_name }}</strong> - {{ $attendee->member->member_id }}
                </div>
                @endforeach
            </div>
            
            <p>Thank you all for your faithful attendance!</p>
        </div>
        
        <div class="footer">
            <p><strong>{{ $organizationName }}</strong></p>
        </div>
    </div>
</body>
</html>
