<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Happy Birthday</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            color: white;
            padding: 40px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 32px;
        }
        .birthday-icon {
            font-size: 64px;
            margin-bottom: 10px;
        }
        .content {
            padding: 40px 30px;
        }
        .content h2 {
            color: #2563eb;
            margin-top: 0;
        }
        .message {
            font-size: 16px;
            margin: 20px 0;
            line-height: 1.8;
        }
        .highlight {
            background: linear-gradient(135deg, #2563eb15 0%, #dc262615 100%);
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #2563eb;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #666;
            font-size: 14px;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="birthday-icon">🎉</div>
            <h1>Happy Birthday!</h1>
        </div>
        
        <div class="content">
            <h2>Dear {{ $member->first_name }},</h2>
            
            <div class="message">
                <p>On this special day, we want to take a moment to celebrate you and the blessing you are to our church family!</p>
                
                <div class="highlight">
                    <p style="margin: 0; font-weight: bold; color: #2563eb; font-size: 18px;">
                        🎂 Wishing you {{ $member->age ? $member->age . ' wonderful years and many more to come!' : 'a wonderful year ahead!' }}
                    </p>
                </div>
                
                <p>May this new year of your life be filled with:</p>
                <ul>
                    <li>God's abundant blessings and grace</li>
                    <li>Good health and prosperity</li>
                    <li>Joy, peace, and fulfillment</li>
                    <li>Meaningful connections and relationships</li>
                    <li>Success in all your endeavors</li>
                </ul>
                
                <p><em>"The LORD bless you and keep you; the LORD make his face shine on you and be gracious to you; the LORD turn his face toward you and give you peace." - Numbers 6:24-26</em></p>
                
                <p>We are grateful for your presence in our church community and pray that God continues to guide your steps in the year ahead.</p>
                
                <p>Have a blessed and joyful celebration!</p>
            </div>
        </div>
        
        <div class="footer">
            <p><strong>{{ $organizationName }}</strong></p>
            <p>Your Church Family</p>
            <p style="font-size: 12px; color: #999;">
                This is an automated birthday greeting. You're receiving this because you're a valued member of our congregation.
            </p>
        </div>
    </div>
</body>
</html>
