<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Attendance Confirmed</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; background-color: #f4f4f4; }
        .container { max-width: 600px; margin: 20px auto; background: #ffffff; border-radius: 10px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .header { background: linear-gradient(135deg, #2563eb 0%, #dc2626 100%); color: white; padding: 30px 20px; text-align: center; }
        .header h1 { margin: 0; font-size: 28px; }
        .content { padding: 30px; }
        .event-box { background: #f8f9fa; border-left: 4px solid #2563eb; padding: 20px; margin: 20px 0; border-radius: 4px; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; color: #666; font-size: 14px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>✅ Attendance Confirmed</h1>
        </div>
        
        <div class="content">
            <h2>Dear {{ $attendance->member->first_name }},</h2>
            
            <p>Your attendance has been successfully recorded for the following event:</p>
            
            <div class="event-box">
                <h3 style="margin-top: 0; color: #2563eb;">{{ $event->title }}</h3>
                <p><strong>Date:</strong> {{ $attendance->checked_in_at->format('F d, Y') }}</p>
                <p><strong>Time:</strong> {{ $attendance->checked_in_at->format('h:i A') }}</p>
                <p><strong>Location:</strong> {{ $event->location ?? 'Church Premises' }}</p>
            </div>
            
            <p>Thank you for your faithful attendance. We're blessed to have you as part of our congregation!</p>
        </div>
        
        <div class="footer">
            <p><strong>{{ $organizationName }}</strong></p>
        </div>
    </div>
</body>
</html>
