@extends('components.app-layout')

@section('title', "Today's Birthdays")
@section('subtitle', 'Send birthday messages to members celebrating today')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Today's Birthdays</h1>
            <p class="text-gray-600">{{ $todayBirthdays->count() }} members celebrating their birthday today</p>
        </div>
        <div class="flex gap-3">
            <a href="{{ route('birthday-messages.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Messages
            </a>
        </div>
    </div>

    @if($todayBirthdays->count() > 0)
        <!-- Generate Messages Form -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
            <div class="flex items-center mb-4">
                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-xl flex items-center justify-center mr-3">
                    <i class="fas fa-magic text-white"></i>
                </div>
                <h3 class="text-lg font-semibold text-gray-900">Generate Birthday Messages</h3>
            </div>

            <form method="POST" action="{{ route('birthday-messages.generate-today') }}">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Message Type</label>
                        <select name="message_type" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="sms">SMS Only</option>
                            <option value="email">Email Only</option>
                            <option value="both">Both SMS & Email</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Custom Message (Optional)</label>
                        <textarea name="custom_message" rows="3" placeholder="Leave empty to use auto-generated personalized messages" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"></textarea>
                    </div>
                </div>
                <div class="mt-6">
                    <button type="submit" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-blue-700 text-white font-medium rounded-xl hover:from-blue-700 hover:to-blue-800 transition-all duration-200">
                        <i class="fas fa-magic mr-2"></i>
                        Generate Messages for All ({{ $todayBirthdays->count() }} members)
                    </button>
                </div>
            </form>
        </div>

        <!-- Today's Birthday Members -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100">
            <div class="px-6 py-4 border-b border-gray-100">
                <h3 class="text-lg font-semibold text-gray-900">Birthday Celebrants</h3>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 p-6">
                @foreach($todayBirthdays as $member)
                    <div class="bg-gradient-to-br from-pink-50 to-purple-50 rounded-xl p-6 border border-pink-100 hover:shadow-lg transition-all duration-200">
                        <div class="flex items-center justify-between mb-4">
                            <div class="w-12 h-12 bg-gradient-to-br from-pink-500 to-purple-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-birthday-cake text-white"></i>
                            </div>
                            @if(in_array($member->id, $sentMessages))
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    <i class="fas fa-check-circle mr-1"></i>Message Sent
                                </span>
                            @else
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                    <i class="fas fa-clock mr-1"></i>Pending
                                </span>
                            @endif
                        </div>
                        
                        <div class="mb-4">
                            <h4 class="text-lg font-semibold text-gray-900 mb-1">{{ $member->full_name }}</h4>
                            <p class="text-sm text-gray-600">Member ID: {{ $member->member_id }}</p>
                            @if($member->age)
                                <p class="text-sm text-purple-600 font-medium">Turning {{ $member->age }} years old</p>
                            @endif
                            @if($member->yearGroup)
                                <span class="inline-block mt-2 px-2 py-1 text-xs font-medium rounded-full text-white" style="background-color: {{ $member->yearGroup->color }};">
                                    {{ $member->yearGroup->abbreviation }}
                                </span>
                            @endif
                        </div>
                        
                        <div class="space-y-2 text-sm">
                            @if($member->phone)
                                <div class="flex items-center text-gray-600">
                                    <i class="fas fa-phone mr-2 w-4"></i>
                                    <span>{{ $member->phone }}</span>
                                </div>
                            @endif
                            @if($member->email)
                                <div class="flex items-center text-gray-600">
                                    <i class="fas fa-envelope mr-2 w-4"></i>
                                    <span>{{ $member->email }}</span>
                                </div>
                            @endif
                            @if(!$member->phone && !$member->email)
                                <div class="flex items-center text-red-500">
                                    <i class="fas fa-exclamation-triangle mr-2 w-4"></i>
                                    <span>No contact information</span>
                                </div>
                            @endif
                        </div>
                        
                        @if(!in_array($member->id, $sentMessages) && ($member->phone || $member->email))
                            <div class="mt-4 pt-4 border-t border-pink-200">
                                <form method="POST" action="{{ route('birthday-messages.generate-today') }}" class="inline">
                                    @csrf
                                    <input type="hidden" name="member_ids[]" value="{{ $member->id }}">
                                    <input type="hidden" name="message_type" value="sms">
                                    <button type="submit" class="w-full px-3 py-2 bg-gradient-to-r from-pink-500 to-purple-600 text-white text-sm font-medium rounded-lg hover:from-pink-600 hover:to-purple-700 transition-all duration-200">
                                        <i class="fas fa-paper-plane mr-2"></i>
                                        Send Birthday Message
                                    </button>
                                </form>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    @else
        <!-- No Birthdays Today -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-12">
            <div class="text-center">
                <div class="w-24 h-24 bg-gradient-to-br from-gray-100 to-gray-200 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-birthday-cake text-4xl text-gray-400"></i>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 mb-3">No Birthdays Today</h3>
                <p class="text-gray-600 mb-6">There are no members celebrating their birthday today.</p>
                <div class="flex justify-center space-x-4">
                    <a href="{{ route('birthday-messages.create') }}" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-blue-700 text-white font-medium rounded-xl hover:from-blue-700 hover:to-blue-800 transition-all duration-200">
                        <i class="fas fa-plus mr-2"></i>
                        Create Custom Message
                    </a>
                    <a href="{{ route('members.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-xl hover:bg-gray-200 transition-colors">
                        <i class="fas fa-users mr-2"></i>
                        View All Members
                    </a>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection
