<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\YearGroup;

class YearGroupSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        $yearGroups = [
            [
                'name' => "Children's Service",
                'abbreviation' => 'CS',
                'min_age' => 0,
                'max_age' => 12,
                'description' => 'Children aged 0-12 years participating in specialized children\'s programs and activities.',
                'color' => '#10B981', // Green
                'sort_order' => 1,
            ],
            [
                'name' => 'Junior Youth',
                'abbreviation' => 'JY',
                'min_age' => 13,
                'max_age' => 18,
                'description' => 'Teenagers aged 13-18 years focusing on spiritual growth and leadership development.',
                'color' => '#3B82F6', // Blue
                'sort_order' => 2,
            ],
            [
                'name' => "Young People's Guild",
                'abbreviation' => 'YPG',
                'min_age' => 19,
                'max_age' => 30,
                'description' => 'Young adults aged 19-30 years engaged in fellowship, service, and spiritual development.',
                'color' => '#8B5CF6', // Purple
                'sort_order' => 3,
            ],
            [
                'name' => "Young Adults' Fellowship",
                'abbreviation' => 'YAF',
                'min_age' => 31,
                'max_age' => 40,
                'description' => 'Adults aged 31-40 years focusing on family life, career, and church service.',
                'color' => '#F59E0B', // Amber
                'sort_order' => 4,
            ],
            [
                'name' => 'Adult Fellowship',
                'abbreviation' => 'AF',
                'min_age' => 41,
                'max_age' => 999, // Unlimited
                'description' => 'Mature adults aged 41 and above, including Men\'s and Women\'s Fellowship groups.',
                'color' => '#EF4444', // Red
                'sort_order' => 5,
            ],
        ];

        foreach ($yearGroups as $group) {
            YearGroup::updateOrCreate(
                ['name' => $group['name']],
                $group
            );
        }

        $this->command->info('PCG Year Groups seeded successfully!');
        $this->command->info('Created 5 age groups:');
        $this->command->info('- Children\'s Service (0-12)');
        $this->command->info('- Junior Youth (13-18)');
        $this->command->info('- Young People\'s Guild (19-30)');
        $this->command->info('- Young Adults\' Fellowship (31-40)');
        $this->command->info('- Adult Fellowship (41+)');
    }
}
