<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\InventoryCategory;
use App\Models\InventoryItem;

class InventorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Categories
        $categories = [
            [
                'name' => 'Office Supplies',
                'description' => 'General office supplies and stationery',
                'color' => '#3B82F6',
                'icon' => 'fas fa-pencil-alt'
            ],
            [
                'name' => 'Audio/Visual Equipment',
                'description' => 'Sound systems, projectors, and AV equipment',
                'color' => '#EF4444',
                'icon' => 'fas fa-microphone'
            ],
            [
                'name' => 'Furniture',
                'description' => 'Church furniture and seating',
                'color' => '#10B981',
                'icon' => 'fas fa-chair'
            ],
            [
                'name' => 'Cleaning Supplies',
                'description' => 'Cleaning materials and maintenance supplies',
                'color' => '#F59E0B',
                'icon' => 'fas fa-spray-can'
            ],
            [
                'name' => 'Kitchen Supplies',
                'description' => 'Kitchen equipment and utensils',
                'color' => '#8B5CF6',
                'icon' => 'fas fa-utensils'
            ],
            [
                'name' => 'Books & Materials',
                'description' => 'Bibles, hymnals, and educational materials',
                'color' => '#06B6D4',
                'icon' => 'fas fa-book'
            ]
        ];

        foreach ($categories as $categoryData) {
            $category = InventoryCategory::create($categoryData);

            // Create sample items for each category
            $this->createItemsForCategory($category);
        }
    }

    private function createItemsForCategory($category)
    {
        $items = [];

        switch ($category->name) {
            case 'Office Supplies':
                $items = [
                    ['name' => 'A4 Paper (Ream)', 'unit_cost' => 15.00, 'current_stock' => 25, 'minimum_stock' => 10],
                    ['name' => 'Pens (Box of 12)', 'unit_cost' => 8.50, 'current_stock' => 5, 'minimum_stock' => 8],
                    ['name' => 'Stapler', 'unit_cost' => 12.00, 'current_stock' => 3, 'minimum_stock' => 2],
                    ['name' => 'Printer Ink Cartridge', 'unit_cost' => 45.00, 'current_stock' => 2, 'minimum_stock' => 4],
                ];
                break;

            case 'Audio/Visual Equipment':
                $items = [
                    ['name' => 'Wireless Microphone', 'unit_cost' => 150.00, 'current_stock' => 4, 'minimum_stock' => 2],
                    ['name' => 'HDMI Cable (10ft)', 'unit_cost' => 25.00, 'current_stock' => 8, 'minimum_stock' => 5],
                    ['name' => 'Projector Bulb', 'unit_cost' => 120.00, 'current_stock' => 1, 'minimum_stock' => 2],
                    ['name' => 'Speaker Stand', 'unit_cost' => 80.00, 'current_stock' => 6, 'minimum_stock' => 4],
                ];
                break;

            case 'Furniture':
                $items = [
                    ['name' => 'Plastic Chair', 'unit_cost' => 35.00, 'current_stock' => 150, 'minimum_stock' => 100],
                    ['name' => 'Folding Table', 'unit_cost' => 85.00, 'current_stock' => 20, 'minimum_stock' => 15],
                    ['name' => 'Pulpit', 'unit_cost' => 500.00, 'current_stock' => 2, 'minimum_stock' => 1],
                ];
                break;

            case 'Cleaning Supplies':
                $items = [
                    ['name' => 'Toilet Paper (12-pack)', 'unit_cost' => 18.00, 'current_stock' => 8, 'minimum_stock' => 12],
                    ['name' => 'Floor Cleaner (5L)', 'unit_cost' => 22.00, 'current_stock' => 6, 'minimum_stock' => 10],
                    ['name' => 'Disinfectant Spray', 'unit_cost' => 15.00, 'current_stock' => 4, 'minimum_stock' => 8],
                ];
                break;

            case 'Kitchen Supplies':
                $items = [
                    ['name' => 'Disposable Plates (50-pack)', 'unit_cost' => 12.00, 'current_stock' => 15, 'minimum_stock' => 20],
                    ['name' => 'Disposable Cups (100-pack)', 'unit_cost' => 8.00, 'current_stock' => 10, 'minimum_stock' => 15],
                    ['name' => 'Large Cooking Pot', 'unit_cost' => 65.00, 'current_stock' => 3, 'minimum_stock' => 2],
                ];
                break;

            case 'Books & Materials':
                $items = [
                    ['name' => 'English Bible (NIV)', 'unit_cost' => 25.00, 'current_stock' => 30, 'minimum_stock' => 20],
                    ['name' => 'Hymnal Book', 'unit_cost' => 18.00, 'current_stock' => 45, 'minimum_stock' => 30],
                    ['name' => 'Sunday School Materials', 'unit_cost' => 12.00, 'current_stock' => 8, 'minimum_stock' => 15],
                ];
                break;
        }

        foreach ($items as $itemData) {
            InventoryItem::create([
                'name' => $itemData['name'],
                'description' => 'Sample inventory item for ' . $category->name,
                'category_id' => $category->id,
                'unit_of_measure' => 'pieces',
                'unit_cost' => $itemData['unit_cost'],
                'current_stock' => $itemData['current_stock'],
                'minimum_stock' => $itemData['minimum_stock'],
                'maximum_stock' => $itemData['minimum_stock'] * 3,
                'location' => 'Storage Room A',
                'supplier' => 'Sample Supplier Ltd.',
                'supplier_contact' => '+233-123-456-789',
                'is_active' => true,
                'track_expiry' => false
            ]);
        }
    }
}
