<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add email tracking to member_payments table
        Schema::table('member_payments', function (Blueprint $table) {
            $table->boolean('email_sent')->default(false)->after('sms_sent_at');
            $table->timestamp('email_sent_at')->nullable()->after('email_sent');
        });

        // Add email tracking to attendances table
        Schema::table('attendances', function (Blueprint $table) {
            $table->boolean('email_sent')->default(false)->after('is_verified');
            $table->timestamp('email_sent_at')->nullable()->after('email_sent');
        });

        // Add email tracking to members table
        Schema::table('members', function (Blueprint $table) {
            $table->timestamp('credentials_email_sent_at')->nullable()->after('password');
            $table->timestamp('registration_email_sent_at')->nullable()->after('credentials_email_sent_at');
            $table->timestamp('last_birthday_email_sent_at')->nullable()->after('registration_email_sent_at');
        });

        // Add email tracking to users table
        Schema::table('users', function (Blueprint $table) {
            $table->timestamp('registration_email_sent_at')->nullable()->after('remember_token');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('member_payments', function (Blueprint $table) {
            $table->dropColumn(['email_sent', 'email_sent_at']);
        });

        Schema::table('attendances', function (Blueprint $table) {
            $table->dropColumn(['email_sent', 'email_sent_at']);
        });

        Schema::table('members', function (Blueprint $table) {
            $table->dropColumn(['credentials_email_sent_at', 'registration_email_sent_at', 'last_birthday_email_sent_at']);
        });

        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('registration_email_sent_at');
        });
    }
};
