<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First, temporarily change the column to VARCHAR to allow any value
        DB::statement("ALTER TABLE members MODIFY COLUMN membership_type VARCHAR(50) DEFAULT 'member'");
        
        // Update existing data to map to new PCG values
        DB::statement("UPDATE members SET membership_type = 'communicant' WHERE membership_type IN ('member', 'full')");
        DB::statement("UPDATE members SET membership_type = 'adherent' WHERE membership_type = 'associate'");
        DB::statement("UPDATE members SET membership_type = 'catechumen' WHERE membership_type IN ('visitor', 'friend')");
        
        // Now create the new enum with PCG values
        DB::statement("ALTER TABLE members MODIFY COLUMN membership_type ENUM('communicant', 'baptized', 'confirmed', 'long_distance', 'adherent', 'catechumen') DEFAULT 'communicant'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert to original enum values
        DB::statement("UPDATE members SET membership_type = 'member' WHERE membership_type NOT IN ('member', 'visitor', 'friend', 'associate')");
        DB::statement("ALTER TABLE members MODIFY COLUMN membership_type ENUM('member', 'visitor', 'friend', 'associate') DEFAULT 'member'");
    }
};
