<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('birthday_messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('member_id')->constrained('members')->onDelete('cascade');
            $table->string('message_type')->default('sms'); // sms, email, both
            $table->text('message_content');
            $table->string('phone_number')->nullable();
            $table->string('email_address')->nullable();
            $table->enum('status', ['pending', 'sent', 'failed'])->default('pending');
            $table->timestamp('sent_at')->nullable();
            $table->date('birthday_date');
            $table->text('error_message')->nullable();
            $table->json('delivery_details')->nullable(); // API response details
            $table->timestamps();
            
            // Indexes
            $table->index(['status', 'birthday_date']);
            $table->index(['member_id', 'birthday_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('birthday_messages');
    }
};
