<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('year_groups', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Children's Service"
            $table->string('abbreviation')->nullable(); // e.g., "CS", "JY", "YPG"
            $table->integer('min_age'); // Minimum age for this group
            $table->integer('max_age'); // Maximum age for this group (999 for unlimited)
            $table->text('description')->nullable(); // Description of the group
            $table->string('color')->default('#3B82F6'); // Color for UI display
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0); // For ordering groups
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('year_groups');
    }
};
