<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('members', function (Blueprint $table) {
            // Add missing fields that don't exist yet (based on current table structure)
            
            // Additional Personal Details
            $table->string('surname')->nullable()->after('last_name');
            $table->string('mobile_phone')->nullable()->after('phone');
            $table->string('other_phone')->nullable()->after('mobile_phone');
            $table->string('nationality')->nullable()->after('country');
            $table->string('region_state')->nullable()->after('nationality');
            $table->text('residential_address')->nullable()->after('address');
            $table->string('area')->nullable()->after('residential_address');
            $table->string('ghana_card_number')->nullable()->after('area');
            
            // Guardian Information (for minors)
            $table->string('guardian_name')->nullable()->after('emergency_contact_phone');
            $table->string('guardian_relationship')->nullable()->after('guardian_name');
            $table->string('guardian_phone')->nullable()->after('guardian_relationship');
            $table->text('guardian_address')->nullable()->after('guardian_phone');
            
            // Emergency Contact Enhancement
            $table->string('emergency_contact_occupation')->nullable()->after('guardian_address');
            $table->text('emergency_contact_address')->nullable()->after('emergency_contact_occupation');
            
            // Health Information
            $table->boolean('physically_challenged')->default(false)->after('special_needs');
            $table->enum('disability_type', ['mobility', 'visual', 'hearing', 'speech', 'intellectual', 'learning', 'mental_health', 'chronic_illness', 'multiple', 'other'])->nullable()->after('physically_challenged');
            $table->string('disability_type_other')->nullable()->after('disability_type');
            
            // Baptism Details Enhancement
            $table->string('place_of_baptism')->nullable()->after('baptism_date');
            $table->string('baptism_certificate_number')->nullable()->after('place_of_baptism');
            $table->enum('baptism_type', ['sprinkling', 'immersion', 'pouring', 'water', 'other'])->nullable()->after('baptism_certificate_number');
            $table->string('baptism_officiating_minister')->nullable()->after('baptism_type');
            
            // Confirmation Details Enhancement
            $table->string('place_of_confirmation')->nullable()->after('confirmation_date');
            $table->string('confirmation_certificate_number')->nullable()->after('place_of_confirmation');
            $table->integer('age_confirmed')->nullable()->after('confirmation_certificate_number');
            $table->string('confirmation_bible_verse')->nullable()->after('age_confirmed');
            $table->string('confirmation_officiating_minister')->nullable()->after('confirmation_bible_verse');
            
            // Marriage Details
            $table->boolean('is_married')->default(false)->after('confirmation_officiating_minister');
            $table->date('marriage_date')->nullable()->after('is_married');
            $table->string('place_of_marriage')->nullable()->after('marriage_date');
            $table->string('marriage_certificate_number')->nullable()->after('place_of_marriage');
            $table->enum('marriage_type', ['traditional', 'customary', 'ordinance', 'other'])->nullable()->after('marriage_certificate_number');
            $table->string('marriage_officiating_minister')->nullable()->after('marriage_type');
            
            // Family Information
            $table->boolean('has_family')->default(false)->after('marriage_officiating_minister');
            
            // Schooling Information
            $table->boolean('currently_schooling')->default(false)->after('has_family');
            $table->string('school_name')->nullable()->after('currently_schooling');
            $table->date('school_admission_date')->nullable()->after('school_name');
            $table->date('school_completion_date')->nullable()->after('school_admission_date');
            $table->string('school_telephone')->nullable()->after('school_completion_date');
            $table->text('school_location')->nullable()->after('school_telephone');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('members', function (Blueprint $table) {
            // Remove all added columns in reverse order
            $table->dropColumn([
                'school_location',
                'school_telephone',
                'school_completion_date',
                'school_admission_date',
                'school_name',
                'currently_schooling',
                'has_family',
                'marriage_officiating_minister',
                'marriage_type',
                'marriage_certificate_number',
                'place_of_marriage',
                'marriage_date',
                'is_married',
                'confirmation_officiating_minister',
                'confirmation_bible_verse',
                'age_confirmed',
                'confirmation_certificate_number',
                'place_of_confirmation',
                'baptism_officiating_minister',
                'baptism_type',
                'baptism_certificate_number',
                'place_of_baptism',
                'disability_type_other',
                'disability_type',
                'physically_challenged',
                'emergency_contact_address',
                'emergency_contact_occupation',
                'guardian_address',
                'guardian_phone',
                'guardian_relationship',
                'guardian_name',
                'ghana_card_number',
                'area',
                'residential_address',
                'region_state',
                'nationality',
                'other_phone',
                'mobile_phone',
                'surname'
            ]);
        });
    }
};
