<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InventoryCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'color',
        'icon',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean'
    ];

    // Relationships
    public function items()
    {
        return $this->hasMany(InventoryItem::class, 'category_id');
    }

    public function activeItems()
    {
        return $this->hasMany(InventoryItem::class, 'category_id')->where('is_active', true);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Accessors
    public function getItemsCountAttribute()
    {
        return $this->items()->count();
    }

    public function getActiveItemsCountAttribute()
    {
        return $this->activeItems()->count();
    }

    public function getTotalStockValueAttribute()
    {
        return $this->items()->sum(\DB::raw('current_stock * unit_cost'));
    }
}
