<?php

namespace App\Mail;

use App\Models\Member;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class MemberApprovedEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $member;
    public $organizationName;
    public $congregationSlogan;
    public $password;
    public $loginUrl;

    /**
     * Create a new message instance.
     */
    public function __construct(Member $member, $password = null)
    {
        $this->member = $member;
        $this->password = $password;
        $this->organizationName = \DB::table('settings')
            ->where('key', 'organization_name')
            ->value('value') ?? 'Presbyterian Church of Ghana';
        $this->congregationSlogan = \DB::table('settings')
            ->where('key', 'congregation_slogan')
            ->value('value') ?? 'A Place of Grace and Truth';
        $this->loginUrl = url('/member/login');
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Membership Approved - Welcome to ' . $this->organizationName,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.member-approved',
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}
