<?php

namespace App\Mail;

use App\Models\Attendance;
use App\Models\Event;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class AttendanceMarkedEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $attendance;
    public $event;
    public $organizationName;

    /**
     * Create a new message instance.
     */
    public function __construct(Attendance $attendance)
    {
        $this->attendance = $attendance;
        $this->event = $attendance->event;
        $this->organizationName = \DB::table('settings')
            ->where('key', 'organization_name')
            ->value('value') ?? 'Presbyterian Church of Ghana';
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Attendance Confirmed - ' . $this->event->title,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.attendance-marked',
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}
