<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Color;

class MemberTemplateExport implements FromArray, WithHeadings, WithStyles, WithColumnWidths
{
    public function array(): array
    {
        // Return sample data to show the expected format
        return [
            [
                'John',
                'Kofi',
                'Asare',
                'john.sare@example.com',
                '+233123456789',
                '1990-01-15',
                'male',
                'communicant',
                'active',
                'married',
                '123 Main Street, Adum',
                'Teacher',
                'Kwame Asare',
                '+233987654321',
                'Asare Family'
            ],
            [
                'Mary',
                'Akua',
                'Serwaa',
                'mary.serwaa@example.com',
                '+233234567890',
                '1985-05-20',
                'female',
                'adherent',
                'active',
                'single',
                '456 Oak Avenue, Kumasi',
                'Teacher',
                'Ama Achiaa',
                '+233876543210',
                'Achiaa Family'
            ],
            [
                'Samuel',
                'Kwame',
                'Asante',
                'samuel.asante@gmail.com',
                '+233345678901',
                '1992-03-10',
                'male',
                'communicant',
                'active',
                'single',
                '789 Independence Ave, Tamale',
                'Farmer',
                'Grace Asante',
                '+233765432109',
                'Asante Family'
            ]
        ];
    }

    public function headings(): array
    {
        return [
            'first_name',
            'middle_name',
            'last_name', 
            'email',
            'phone',
            'date_of_birth',
            'gender',
            'membership_type',
            'membership_status',
            'marital_status',
            'address',
            'occupation',
            'emergency_contact_name',
            'emergency_contact_phone',
            'family_name'
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // Style the header row
            1 => [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                ],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '2563eb'], // Blue color
                ],
            ],
            // Add some styling to sample rows
            2 => [
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'F3F4F6'], // Light gray
                ],
            ],
            3 => [
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'F3F4F6'], // Light gray
                ],
            ],
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 15, // first_name
            'B' => 15, // middle_name
            'C' => 15, // last_name
            'D' => 25, // email
            'E' => 15, // phone
            'F' => 15, // date_of_birth
            'G' => 10, // gender
            'H' => 15, // membership_type
            'I' => 15, // membership_status
            'J' => 15, // marital_status
            'K' => 30, // address
            'L' => 20, // occupation
            'M' => 20, // emergency_contact_name
            'N' => 15, // emergency_contact_phone
            'O' => 20, // family_name
        ];
    }
}
